/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.test.tools;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterators;
import com.google.common.collect.Streams;
import com.google.common.io.Files;
import io.confluent.kafka.schemaregistry.ParsedSchema;
import io.confluent.ksql.config.SessionConfig;
import io.confluent.ksql.format.DefaultFormatInjector;
import io.confluent.ksql.function.FunctionRegistry;
import io.confluent.ksql.metastore.MetaStore;
import io.confluent.ksql.metastore.MetaStoreImpl;
import io.confluent.ksql.metastore.MutableMetaStore;
import io.confluent.ksql.metastore.TypeRegistry;
import io.confluent.ksql.name.SourceName;
import io.confluent.ksql.parser.DefaultKsqlParser;
import io.confluent.ksql.parser.KsqlParser;
import io.confluent.ksql.parser.SqlBaseParser;
import io.confluent.ksql.parser.properties.with.CreateSourceProperties;
import io.confluent.ksql.parser.properties.with.SourcePropertiesUtil;
import io.confluent.ksql.parser.tree.CreateSource;
import io.confluent.ksql.parser.tree.RegisterType;
import io.confluent.ksql.parser.tree.TableElements;
import io.confluent.ksql.schema.ksql.Column;
import io.confluent.ksql.schema.ksql.LogicalSchema;
import io.confluent.ksql.schema.ksql.PersistenceSchema;
import io.confluent.ksql.serde.Format;
import io.confluent.ksql.serde.FormatFactory;
import io.confluent.ksql.serde.FormatInfo;
import io.confluent.ksql.serde.SchemaTranslator;
import io.confluent.ksql.serde.SerdeFeature;
import io.confluent.ksql.serde.SerdeFeatures;
import io.confluent.ksql.serde.SerdeFeaturesFactory;
import io.confluent.ksql.statement.ConfiguredStatement;
import io.confluent.ksql.statement.SourcePropertyInjector;
import io.confluent.ksql.test.tools.Record;
import io.confluent.ksql.tools.test.model.Topic;
import io.confluent.ksql.util.KsqlConfig;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public final class TestCaseBuilderUtil {
    private static final String FORMAT_REPLACE_ERROR = "To use {FORMAT} in your statements please set the 'format' test case element";

    private TestCaseBuilderUtil() {
    }

    public static String buildTestName(Path originalFileName, String testName, Optional<String> explicitFormat, Optional<String> config) {
        String prefix = TestCaseBuilderUtil.filePrefix(originalFileName.toString());
        String pf = explicitFormat.map(f -> " - " + f).orElse("");
        String pc = config.map(f -> " - " + f).orElse("");
        return prefix + testName + pf + pc;
    }

    public static String extractSimpleTestName(String originalFileName, String testName) {
        String prefix = TestCaseBuilderUtil.filePrefix(originalFileName);
        if (!testName.startsWith(prefix)) {
            throw new IllegalArgumentException("Not prefixed test name: " + testName);
        }
        return testName.substring(prefix.length());
    }

    public static List<String> buildStatements(List<String> statements, Optional<String> explicitFormat) {
        String format = explicitFormat.orElse(FORMAT_REPLACE_ERROR);
        return statements.stream().map(stmt -> stmt.replace("{FORMAT}", format)).collect(Collectors.toList());
    }

    public static Collection<Topic> getAllTopics(Collection<String> statements, Collection<Topic> topics, Collection<Record> outputs, Collection<Record> inputs, FunctionRegistry functionRegistry, KsqlConfig ksqlConfig) {
        HashMap topicsByName = new HashMap();
        topics.forEach(topic -> topicsByName.put(topic.getName(), topic));
        MetaStoreImpl metaStore = new MetaStoreImpl(functionRegistry);
        for (String sql : statements) {
            TestCaseBuilderUtil.createTopicFromStatement(sql, (MutableMetaStore)metaStore, ksqlConfig).ifPresent(topicFromStatement -> topicsByName.compute(topicFromStatement.getName(), (key, topic) -> {
                if (topic == null) {
                    return topicFromStatement;
                }
                Optional keySchema = Optional.of(topic.getKeySchema()).filter(Optional::isPresent).orElse(topicFromStatement.getKeySchema());
                Optional valueSchema = Optional.of(topic.getValueSchema()).filter(Optional::isPresent).orElse(topicFromStatement.getValueSchema());
                topic = new Topic(topic.getName(), topic.getNumPartitions(), (int)topic.getReplicas(), topic.getKeySchemaId(), topic.getValueSchemaId(), keySchema, valueSchema, topic.getKeySchemaReferences(), topic.getValueSchemaReferences(), topicFromStatement.getKeyFeatures(), topicFromStatement.getValueFeatures());
                return topic;
            }));
        }
        Streams.concat((Stream[])new Stream[]{inputs.stream(), outputs.stream()}).map(record -> new Topic(record.getTopicName(), Optional.empty(), Optional.empty())).forEach(topic -> topicsByName.putIfAbsent(topic.getName(), topic));
        return topicsByName.values();
    }

    private static Optional<Topic> createTopicFromStatement(String sql, MutableMetaStore metaStore, KsqlConfig ksqlConfig) {
        DefaultKsqlParser parser = new DefaultKsqlParser();
        try {
            List parsed = parser.parse(sql);
            if (parsed.size() > 1) {
                throw new IllegalArgumentException("SQL contains more than one statement: " + sql);
            }
            if (parsed.size() == 1) {
                KsqlParser.ParsedStatement stmt = (KsqlParser.ParsedStatement)parsed.get(0);
                if (stmt.getStatement().statement() instanceof SqlBaseParser.RegisterTypeContext) {
                    KsqlParser.PreparedStatement prepare = parser.prepare(stmt, (TypeRegistry)metaStore);
                    TestCaseBuilderUtil.registerType(prepare, (MetaStore)metaStore);
                    return Optional.empty();
                }
                if (TestCaseBuilderUtil.isCsOrCT(stmt)) {
                    KsqlParser.PreparedStatement prepare = parser.prepare(stmt, (TypeRegistry)metaStore);
                    ConfiguredStatement configured = ConfiguredStatement.of((KsqlParser.PreparedStatement)prepare, (SessionConfig)SessionConfig.of((KsqlConfig)ksqlConfig, Collections.emptyMap()));
                    ConfiguredStatement withFormats = new DefaultFormatInjector().inject(configured);
                    ConfiguredStatement withSourceProps = new SourcePropertyInjector().inject(withFormats);
                    return TestCaseBuilderUtil.createTopicFromCreateSource(sql, ksqlConfig, withSourceProps);
                }
            }
            return Optional.empty();
        }
        catch (Exception e) {
            System.out.println("Error parsing statement (which may be expected): " + sql);
            e.printStackTrace(System.out);
            return Optional.empty();
        }
    }

    private static Optional<Topic> createTopicFromCreateSource(String sql, KsqlConfig ksqlConfig, ConfiguredStatement<?> stmt) {
        CreateSource statement = (CreateSource)stmt.getStatement();
        CreateSourceProperties props = statement.getProperties();
        TableElements tableElements = statement.getElements();
        if (Iterators.size((Iterator)tableElements.iterator()) == 0) {
            return Optional.empty();
        }
        LogicalSchema logicalSchema = tableElements.toLogicalSchema();
        FormatInfo keyFormatInfo = SourcePropertiesUtil.getKeyFormat((CreateSourceProperties)props, (SourceName)statement.getName());
        Format keyFormat = FormatFactory.fromName((String)keyFormatInfo.getFormat());
        SerdeFeatures keySerdeFeats = TestCaseBuilderUtil.buildKeyFeatures(keyFormat, logicalSchema);
        Optional keySchema = keyFormat.supportsFeature(SerdeFeature.SCHEMA_INFERENCE) ? TestCaseBuilderUtil.buildSchema(sql, logicalSchema.key(), keyFormatInfo, keyFormat, keySerdeFeats) : Optional.empty();
        FormatInfo valFormatInfo = SourcePropertiesUtil.getValueFormat((CreateSourceProperties)props);
        Format valFormat = FormatFactory.fromName((String)valFormatInfo.getFormat());
        SerdeFeatures valSerdeFeats = TestCaseBuilderUtil.buildValueFeatures(ksqlConfig, props, valFormat, logicalSchema);
        Optional valueSchema = valFormat.supportsFeature(SerdeFeature.SCHEMA_INFERENCE) ? TestCaseBuilderUtil.buildSchema(sql, logicalSchema.value(), valFormatInfo, valFormat, valSerdeFeats) : Optional.empty();
        int partitions = props.getPartitions().orElse(4);
        short rf = props.getReplicas().orElse((short)1);
        return Optional.of(new Topic(props.getKafkaTopic(), partitions, (int)rf, Optional.empty(), Optional.empty(), keySchema, valueSchema, (List)ImmutableList.of(), (List)ImmutableList.of(), keySerdeFeats, valSerdeFeats));
    }

    private static Optional<ParsedSchema> buildSchema(String sql, List<Column> schema, FormatInfo formatInfo, Format format, SerdeFeatures serdeFeatures) {
        if (schema.isEmpty()) {
            return Optional.empty();
        }
        try {
            SchemaTranslator translator = format.getSchemaTranslator(formatInfo.getProperties());
            return Optional.of(translator.toParsedSchema(PersistenceSchema.from(schema, (SerdeFeatures)serdeFeatures)));
        }
        catch (Exception e) {
            System.out.println("Error getting schema translator statement (which may be expected): " + sql);
            e.printStackTrace(System.out);
            return Optional.empty();
        }
    }

    private static SerdeFeatures buildKeyFeatures(Format format, LogicalSchema schema) {
        try {
            return SerdeFeaturesFactory.buildKeyFeatures((LogicalSchema)schema, (Format)format);
        }
        catch (Exception e) {
            return SerdeFeatures.of((SerdeFeature[])new SerdeFeature[0]);
        }
    }

    private static SerdeFeatures buildValueFeatures(KsqlConfig ksqlConfig, CreateSourceProperties props, Format valueFormat, LogicalSchema logicalSchema) {
        try {
            return SerdeFeaturesFactory.buildValueFeatures((LogicalSchema)logicalSchema, (Format)valueFormat, (SerdeFeatures)props.getValueSerdeFeatures(), (KsqlConfig)ksqlConfig);
        }
        catch (Exception e) {
            return SerdeFeatures.of((SerdeFeature[])new SerdeFeature[0]);
        }
    }

    private static void registerType(KsqlParser.PreparedStatement<?> prepare, MetaStore metaStore) {
        if (prepare.getStatement() instanceof RegisterType) {
            RegisterType statement = (RegisterType)prepare.getStatement();
            metaStore.registerType(statement.getName(), statement.getType().getSqlType());
        }
    }

    private static boolean isCsOrCT(KsqlParser.ParsedStatement stmt) {
        return stmt.getStatement().statement() instanceof SqlBaseParser.CreateStreamContext || stmt.getStatement().statement() instanceof SqlBaseParser.CreateTableContext;
    }

    private static String filePrefix(String testPath) {
        return Files.getNameWithoutExtension((String)testPath) + " - ";
    }
}

