/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.test.tools;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import io.confluent.kafka.schemaregistry.ParsedSchema;
import io.confluent.kafka.schemaregistry.client.SchemaMetadata;
import io.confluent.kafka.schemaregistry.client.SchemaRegistryClient;
import io.confluent.ksql.KsqlExecutionContext;
import io.confluent.ksql.config.SessionConfig;
import io.confluent.ksql.engine.KsqlEngine;
import io.confluent.ksql.engine.KsqlPlan;
import io.confluent.ksql.engine.StubInsertValuesExecutor;
import io.confluent.ksql.execution.ddl.commands.KsqlTopic;
import io.confluent.ksql.execution.json.PlanJsonMapper;
import io.confluent.ksql.format.DefaultFormatInjector;
import io.confluent.ksql.function.FunctionRegistry;
import io.confluent.ksql.metastore.MetaStore;
import io.confluent.ksql.metastore.model.DataSource;
import io.confluent.ksql.name.SourceName;
import io.confluent.ksql.parser.KsqlParser;
import io.confluent.ksql.parser.tree.InsertValues;
import io.confluent.ksql.planner.plan.ConfiguredKsqlPlan;
import io.confluent.ksql.query.QueryId;
import io.confluent.ksql.rest.SessionProperties;
import io.confluent.ksql.schema.ksql.inference.DefaultSchemaInjector;
import io.confluent.ksql.schema.ksql.inference.SchemaRegisterInjector;
import io.confluent.ksql.schema.ksql.inference.SchemaRegistryTopicSchemaSupplier;
import io.confluent.ksql.schema.ksql.inference.TopicSchemaSupplier;
import io.confluent.ksql.serde.Format;
import io.confluent.ksql.serde.FormatFactory;
import io.confluent.ksql.serde.SerdeFeature;
import io.confluent.ksql.services.KafkaTopicClient;
import io.confluent.ksql.services.ServiceContext;
import io.confluent.ksql.statement.ConfiguredStatement;
import io.confluent.ksql.statement.Injector;
import io.confluent.ksql.statement.InjectorChain;
import io.confluent.ksql.statement.SourcePropertyInjector;
import io.confluent.ksql.test.tools.TestCase;
import io.confluent.ksql.test.tools.TestCaseBuilderUtil;
import io.confluent.ksql.test.tools.TestExecutionListener;
import io.confluent.ksql.test.tools.TopologyTestDriverContainer;
import io.confluent.ksql.test.tools.stubs.StubKafkaService;
import io.confluent.ksql.tools.test.model.Topic;
import io.confluent.ksql.util.KsqlConfig;
import io.confluent.ksql.util.KsqlConstants;
import io.confluent.ksql.util.KsqlException;
import io.confluent.ksql.util.KsqlHostInfo;
import io.confluent.ksql.util.KsqlStatementException;
import io.confluent.ksql.util.PersistentQueryMetadata;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.stream.Collectors;
import org.apache.kafka.streams.Topology;
import org.apache.kafka.streams.TopologyTestDriver;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.hamcrest.SelfDescribing;
import org.hamcrest.StringDescription;

public final class TestExecutorUtil {
    private static final ObjectMapper PLAN_MAPPER = PlanJsonMapper.INSTANCE.get();

    private TestExecutorUtil() {
    }

    static List<TopologyTestDriverContainer> buildStreamsTopologyTestDrivers(TestCase testCase, ServiceContext serviceContext, KsqlEngine ksqlEngine, KsqlConfig ksqlConfig, StubKafkaService stubKafkaService, TestExecutionListener listener) {
        KsqlConfig maybeUpdatedConfigs = testCase.applyPersistedProperties(ksqlConfig);
        List<PersistentQueryAndSources> queryMetadataList = TestExecutorUtil.doBuildQueries(testCase, serviceContext, ksqlEngine, maybeUpdatedConfigs, stubKafkaService, listener);
        ArrayList<TopologyTestDriverContainer> topologyTestDrivers = new ArrayList<TopologyTestDriverContainer>();
        for (PersistentQueryAndSources persistentQueryAndSources : queryMetadataList) {
            PersistentQueryMetadata persistentQueryMetadata = persistentQueryAndSources.getPersistentQueryMetadata();
            Properties streamsProperties = new Properties();
            streamsProperties.putAll((Map<?, ?>)persistentQueryMetadata.getStreamsProperties());
            Topology topology = persistentQueryMetadata.getTopology();
            TopologyTestDriver topologyTestDriver = new TopologyTestDriver(topology, streamsProperties, Instant.EPOCH);
            List<Topic> sourceTopics = persistentQueryAndSources.getSources().stream().map(dataSource -> {
                stubKafkaService.requireTopicExists(dataSource.getKafkaTopicName());
                return stubKafkaService.getTopic(dataSource.getKafkaTopicName());
            }).collect(Collectors.toList());
            Optional<Topic> sinkTopic = persistentQueryMetadata.getSinkName().map(name -> TestExecutorUtil.buildSinkTopic(ksqlEngine.getMetaStore().getSource(name), stubKafkaService, serviceContext.getSchemaRegistryClient()));
            testCase.setGeneratedTopologies((List<String>)ImmutableList.of((Object)persistentQueryMetadata.getTopologyDescription()));
            testCase.setGeneratedSchemas(persistentQueryMetadata.getQuerySchemas().getLoggerSchemaInfo());
            topologyTestDrivers.add(TopologyTestDriverContainer.of(topologyTestDriver, sourceTopics, sinkTopic));
        }
        return topologyTestDrivers;
    }

    @VisibleForTesting
    static Iterator<PlannedStatement> planTestCase(KsqlEngine engine, TestCase testCase, KsqlConfig ksqlConfig, ServiceContext serviceContext, Optional<SchemaRegistryClient> srClient, StubKafkaService stubKafkaService) {
        TestExecutorUtil.initializeTopics(testCase, engine.getServiceContext(), stubKafkaService, (FunctionRegistry)engine.getMetaStore(), ksqlConfig);
        if (testCase.getExpectedTopology().isPresent() && testCase.getExpectedTopology().get().getPlan().isPresent()) {
            return testCase.getExpectedTopology().get().getPlan().get().stream().map(p -> ConfiguredKsqlPlan.of((KsqlPlan)p, (SessionConfig)SessionConfig.of((KsqlConfig)ksqlConfig, testCase.properties()))).map(PlannedStatement::new).iterator();
        }
        return PlannedStatementIterator.of((KsqlExecutionContext)engine, testCase, ksqlConfig, serviceContext, srClient);
    }

    private static Topic buildSinkTopic(DataSource sinkDataSource, StubKafkaService stubKafkaService, SchemaRegistryClient schemaRegistryClient) {
        String kafkaTopicName = sinkDataSource.getKafkaTopicName();
        KsqlTopic ksqlTopic = sinkDataSource.getKsqlTopic();
        Optional<ParsedSchema> keySchema = TestExecutorUtil.getSchema(ksqlTopic.getKeyFormat().getFormat(), KsqlConstants.getSRSubject((String)ksqlTopic.getKafkaTopicName(), (boolean)true), schemaRegistryClient);
        Optional<ParsedSchema> valueSchema = TestExecutorUtil.getSchema(ksqlTopic.getValueFormat().getFormat(), KsqlConstants.getSRSubject((String)ksqlTopic.getKafkaTopicName(), (boolean)false), schemaRegistryClient);
        Topic sinkTopic = new Topic(kafkaTopicName, keySchema, valueSchema);
        stubKafkaService.ensureTopic(sinkTopic);
        return sinkTopic;
    }

    private static Optional<ParsedSchema> getSchema(String format, String subject, SchemaRegistryClient schemaRegistryClient) {
        Format valueFormat = FormatFactory.fromName((String)format);
        if (!valueFormat.supportsFeature(SerdeFeature.SCHEMA_INFERENCE)) {
            return Optional.empty();
        }
        try {
            SchemaMetadata metadata = schemaRegistryClient.getLatestSchemaMetadata(subject);
            return Optional.of(schemaRegistryClient.getSchemaBySubjectAndId(subject, metadata.getId()));
        }
        catch (Exception exception) {
            return Optional.empty();
        }
    }

    private static List<PersistentQueryAndSources> doBuildQueries(TestCase testCase, ServiceContext serviceContext, KsqlEngine ksqlEngine, KsqlConfig ksqlConfig, StubKafkaService stubKafkaService, TestExecutionListener listener) {
        List<PersistentQueryAndSources> queries = TestExecutorUtil.execute(ksqlEngine, testCase, ksqlConfig, serviceContext, Optional.of(serviceContext.getSchemaRegistryClient()), stubKafkaService, listener);
        if (testCase.getInputRecords().isEmpty()) {
            testCase.expectedException().map(ee -> {
                throw new AssertionError((Object)("Expected test to throw" + StringDescription.toString((SelfDescribing)ee)));
            });
        }
        MatcherAssert.assertThat((String)"test did not generate any queries.", queries, (Matcher)Matchers.is((Matcher)Matchers.not((Matcher)Matchers.empty())));
        return queries;
    }

    private static void initializeTopics(TestCase testCase, ServiceContext serviceContext, StubKafkaService stubKafkaService, FunctionRegistry functionRegistry, KsqlConfig ksqlConfig) {
        KafkaTopicClient topicClient = serviceContext.getTopicClient();
        SchemaRegistryClient srClient = serviceContext.getSchemaRegistryClient();
        Object statements = testCase.getExpectedTopology().isPresent() ? ImmutableList.of() : testCase.statements();
        Collection<Topic> topics = TestCaseBuilderUtil.getAllTopics((Collection<String>)statements, testCase.getTopics(), testCase.getOutputRecords(), testCase.getInputRecords(), functionRegistry, testCase.applyProperties(ksqlConfig));
        for (Topic topic : topics) {
            stubKafkaService.ensureTopic(topic);
            topicClient.createTopic(topic.getName(), topic.getNumPartitions(), topic.getReplicas());
            topic.getKeySchema().ifPresent(schema -> {
                try {
                    srClient.register(KsqlConstants.getSRSubject((String)topic.getName(), (boolean)true), schema);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            });
            topic.getValueSchema().ifPresent(schema -> {
                try {
                    srClient.register(KsqlConstants.getSRSubject((String)topic.getName(), (boolean)false), schema);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            });
        }
    }

    private static List<PersistentQueryAndSources> execute(KsqlEngine engine, TestCase testCase, KsqlConfig ksqlConfig, ServiceContext serviceContext, Optional<SchemaRegistryClient> srClient, StubKafkaService stubKafkaService, TestExecutionListener listener) {
        LinkedHashMap<QueryId, PersistentQueryAndSources> queries = new LinkedHashMap<QueryId, PersistentQueryAndSources>();
        int idx = 0;
        Iterator<PlannedStatement> plans = TestExecutorUtil.planTestCase(engine, testCase, ksqlConfig, serviceContext, srClient, stubKafkaService);
        try {
            while (plans.hasNext()) {
                ++idx;
                PlannedStatement planned = plans.next();
                if (planned.insertValues.isPresent()) {
                    ConfiguredStatement<InsertValues> insertValues = planned.insertValues.get();
                    SessionProperties sessionProperties = new SessionProperties(insertValues.getSessionConfig().getOverrides(), new KsqlHostInfo("host", 50), TestExecutorUtil.buildUrl(), false);
                    StubInsertValuesExecutor.of(stubKafkaService).execute(insertValues, sessionProperties, (KsqlExecutionContext)engine, engine.getServiceContext());
                    continue;
                }
                ConfiguredKsqlPlan plan = planned.plan.orElseThrow(IllegalStateException::new);
                listener.acceptPlan(plan);
                ExecuteResultAndSources result = TestExecutorUtil.executePlan((KsqlExecutionContext)engine, plan);
                if (!result.getSources().isPresent()) continue;
                PersistentQueryMetadata query = (PersistentQueryMetadata)result.getExecuteResult().getQuery().get();
                listener.acceptQuery(query);
                queries.put(query.getQueryId(), new PersistentQueryAndSources(query, result.getSources().get()));
            }
            return ImmutableList.copyOf(queries.values());
        }
        catch (KsqlStatementException e) {
            if (testCase.expectedException().isPresent() && plans.hasNext()) {
                throw new AssertionError("Only the last statement in a negative test should fail. Yet in this case statement " + idx + " failed.", e);
            }
            throw e;
        }
    }

    private static ExecuteResultAndSources executePlan(KsqlExecutionContext executionContext, ConfiguredKsqlPlan plan) {
        KsqlExecutionContext.ExecuteResult executeResult = executionContext.execute(executionContext.getServiceContext(), plan);
        Optional<List<DataSource>> dataSources = plan.getPlan().getQueryPlan().map(queryPlan -> TestExecutorUtil.getSources(queryPlan.getSources(), executionContext.getMetaStore()));
        return new ExecuteResultAndSources(executeResult, dataSources);
    }

    private static List<DataSource> getSources(Collection<SourceName> sources, MetaStore metaStore) {
        ImmutableList.Builder sourceBuilder = new ImmutableList.Builder();
        for (SourceName name : sources) {
            if (metaStore.getSource(name) == null) {
                throw new KsqlException("Source does not exist: " + name.toString());
            }
            sourceBuilder.add((Object)metaStore.getSource(name));
        }
        return sourceBuilder.build();
    }

    private static URL buildUrl() {
        try {
            return new URL("https://someHost:9876");
        }
        catch (MalformedURLException e) {
            throw new AssertionError((Object)"Failed to test URL");
        }
    }

    private static final class PersistentQueryAndSources {
        private final PersistentQueryMetadata persistentQueryMetadata;
        private final List<DataSource> sources;

        PersistentQueryAndSources(PersistentQueryMetadata persistentQueryMetadata, List<DataSource> sources) {
            this.persistentQueryMetadata = Objects.requireNonNull(persistentQueryMetadata, "persistentQueryMetadata");
            this.sources = Objects.requireNonNull(sources, "sources");
        }

        PersistentQueryMetadata getPersistentQueryMetadata() {
            return this.persistentQueryMetadata;
        }

        List<DataSource> getSources() {
            return this.sources;
        }
    }

    private static final class ExecuteResultAndSources {
        private final KsqlExecutionContext.ExecuteResult executeResult;
        private final Optional<List<DataSource>> sources;

        ExecuteResultAndSources(KsqlExecutionContext.ExecuteResult executeResult, Optional<List<DataSource>> sources) {
            this.executeResult = Objects.requireNonNull(executeResult, "executeResult");
            this.sources = Objects.requireNonNull(sources, "sources");
        }

        KsqlExecutionContext.ExecuteResult getExecuteResult() {
            return this.executeResult;
        }

        Optional<List<DataSource>> getSources() {
            return this.sources;
        }
    }

    private static final class PlannedStatementIterator
    implements Iterator<PlannedStatement> {
        private final Iterator<KsqlParser.ParsedStatement> statements;
        private final KsqlExecutionContext executionContext;
        private final Map<String, Object> overrides;
        private final KsqlConfig ksqlConfig;
        private final Optional<InjectorChain> schemaInjector;

        private PlannedStatementIterator(Iterator<KsqlParser.ParsedStatement> statements, KsqlExecutionContext executionContext, Map<String, Object> overrides, KsqlConfig ksqlConfig, Optional<InjectorChain> schemaInjector) {
            this.statements = Objects.requireNonNull(statements, "statements");
            this.executionContext = Objects.requireNonNull(executionContext, "executionContext");
            this.overrides = Objects.requireNonNull(overrides, "overrides");
            this.ksqlConfig = Objects.requireNonNull(ksqlConfig, "ksqlConfig");
            this.schemaInjector = Objects.requireNonNull(schemaInjector, "schemaInjector");
        }

        public static PlannedStatementIterator of(KsqlExecutionContext executionContext, TestCase testCase, KsqlConfig ksqlConfig, ServiceContext serviceContext, Optional<SchemaRegistryClient> srClient) {
            Optional<InjectorChain> schemaInjector = srClient.map(SchemaRegistryTopicSchemaSupplier::new).map(supplier -> InjectorChain.of((Injector[])new Injector[]{new DefaultSchemaInjector((TopicSchemaSupplier)supplier, executionContext, serviceContext), new SchemaRegisterInjector(executionContext, serviceContext)}));
            String sql = testCase.statements().stream().collect(Collectors.joining(System.lineSeparator()));
            Iterator<KsqlParser.ParsedStatement> statements = executionContext.parse(sql).iterator();
            return new PlannedStatementIterator(statements, executionContext, testCase.properties(), ksqlConfig, schemaInjector);
        }

        @Override
        public boolean hasNext() {
            return this.statements.hasNext();
        }

        @Override
        public PlannedStatement next() {
            return this.planStatement(this.statements.next());
        }

        private PlannedStatement planStatement(KsqlParser.ParsedStatement stmt) {
            KsqlParser.PreparedStatement prepared = this.executionContext.prepare(stmt);
            ConfiguredStatement configured = ConfiguredStatement.of((KsqlParser.PreparedStatement)prepared, (SessionConfig)SessionConfig.of((KsqlConfig)this.ksqlConfig, this.overrides));
            if (prepared.getStatement() instanceof InsertValues) {
                return new PlannedStatement((ConfiguredStatement<InsertValues>)configured);
            }
            ConfiguredStatement withFormats = new DefaultFormatInjector().inject(configured);
            ConfiguredStatement withSourceProps = new SourcePropertyInjector().inject(withFormats);
            ConfiguredStatement withSchema = this.schemaInjector.map(injector -> injector.inject(withSourceProps)).orElse(withSourceProps);
            KsqlPlan plan = this.executionContext.plan(this.executionContext.getServiceContext(), withSchema);
            return new PlannedStatement(ConfiguredKsqlPlan.of((KsqlPlan)PlannedStatementIterator.rewritePlan(plan), (SessionConfig)withSchema.getSessionConfig()));
        }

        private static KsqlPlan rewritePlan(KsqlPlan plan) {
            try {
                String serialized = PLAN_MAPPER.writeValueAsString((Object)plan);
                return (KsqlPlan)PLAN_MAPPER.readValue(serialized, KsqlPlan.class);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    static final class PlannedStatement {
        final Optional<ConfiguredKsqlPlan> plan;
        final Optional<ConfiguredStatement<InsertValues>> insertValues;

        PlannedStatement(ConfiguredKsqlPlan plan) {
            this.plan = Optional.of(plan);
            this.insertValues = Optional.empty();
        }

        PlannedStatement(ConfiguredStatement<InsertValues> insertValues) {
            this.plan = Optional.empty();
            this.insertValues = Optional.of(insertValues);
        }
    }
}

