/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.test.tools;

import com.google.common.collect.ImmutableMap;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.confluent.ksql.engine.KsqlPlan;
import io.confluent.ksql.test.model.SchemaNode;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class TopologyAndConfigs {
    private final Optional<List<KsqlPlan>> plan;
    private final String topology;
    private final Map<String, SchemaNode> schemas;
    private final Map<String, String> configs;

    public TopologyAndConfigs(Optional<List<KsqlPlan>> plan, String topology, Map<String, SchemaNode> schemas, Map<String, String> configs) {
        this.plan = Objects.requireNonNull(plan, "plan");
        this.topology = Objects.requireNonNull(topology, "topology");
        this.schemas = ImmutableMap.copyOf(Objects.requireNonNull(schemas, "schemas"));
        this.configs = new HashMap<String, String>(Objects.requireNonNull(configs, "configs"));
    }

    public String getTopology() {
        return this.topology;
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_REP"}, justification="schemas is ImmutableMap")
    public Map<String, SchemaNode> getSchemas() {
        return this.schemas;
    }

    public Map<String, String> getConfigs() {
        return Collections.unmodifiableMap(this.configs);
    }

    public Optional<List<KsqlPlan>> getPlan() {
        return this.plan;
    }
}

