/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.test.tools.conditions;

import com.google.common.collect.ImmutableList;
import io.confluent.ksql.metastore.MetaStore;
import io.confluent.ksql.metastore.model.DataSource;
import io.confluent.ksql.test.model.PostConditionsNode;
import io.confluent.ksql.test.model.SourceNode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;

public class PostConditions {
    public static final String MATCH_NOTHING = "(?!)";
    public static final PostConditions NONE = new PostConditions((Matcher<Iterable<DataSource>>)Matchers.hasItems((Matcher[])new Matcher[]{Matchers.anything()}), (Matcher<Iterable<PostConditionsNode.PostTopicNode>>)Matchers.hasItems((Matcher[])new Matcher[]{Matchers.anything()}), Pattern.compile("(?!)"), new PostConditionsNode((List<SourceNode>)ImmutableList.of(), Optional.empty()));
    private final Matcher<Iterable<DataSource>> sourcesMatcher;
    private final Matcher<Iterable<PostConditionsNode.PostTopicNode>> topicsMatcher;
    private final Pattern topicBlackList;
    private final PostConditionsNode sourceNode;

    public PostConditions(Matcher<Iterable<DataSource>> sourcesMatcher, Matcher<Iterable<PostConditionsNode.PostTopicNode>> topicsMatcher, Pattern topicBlackList, PostConditionsNode sourceNode) {
        this.sourcesMatcher = Objects.requireNonNull(sourcesMatcher, "sourcesMatcher");
        this.topicsMatcher = Objects.requireNonNull(topicsMatcher, "topicsMatcher");
        this.topicBlackList = Objects.requireNonNull(topicBlackList, "topicBlackList");
        this.sourceNode = Objects.requireNonNull(sourceNode, "sourceNode");
    }

    public void verify(MetaStore metaStore, List<PostConditionsNode.PostTopicNode> knownTopics) {
        this.verifyMetaStore(metaStore);
        this.verifyTopics(knownTopics);
    }

    public PostConditionsNode asNode(List<PostConditionsNode.PostTopicNode> topics, List<SourceNode> sources) {
        ArrayList<SourceNode> sortedSources = new ArrayList<SourceNode>(sources);
        sortedSources.sort(Comparator.comparing(SourceNode::getName));
        return new PostConditionsNode(sortedSources, Optional.of(new PostConditionsNode.PostTopicsNode(this.sourceNode.getTopics().flatMap(PostConditionsNode.PostTopicsNode::getBlackList), Optional.of(topics))));
    }

    private void verifyMetaStore(MetaStore metaStore) {
        Collection values = metaStore.getAllDataSources().values();
        String text = values.stream().map(s -> s.getDataSourceType() + ":" + s.getName().text() + ", schema:" + s.getSchema() + ", topic:" + s.getKsqlTopic()).collect(Collectors.joining(System.lineSeparator()));
        MatcherAssert.assertThat((String)("metastore sources after the statements have run:" + System.lineSeparator() + text), values, this.sourcesMatcher);
    }

    private void verifyTopics(List<PostConditionsNode.PostTopicNode> actualTopics) {
        Set blackListed = actualTopics.stream().map(PostConditionsNode.PostTopicNode::getName).filter(this.topicBlackList.asPredicate()).collect(Collectors.toSet());
        MatcherAssert.assertThat((String)"blacklisted topics found", blackListed, (Matcher)Matchers.is((Matcher)Matchers.empty()));
        MatcherAssert.assertThat(actualTopics, this.topicsMatcher);
    }
}

