/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.cel.common.types;

import java.util.Objects;
import org.projectnessie.cel.common.types.TypeT;
import org.projectnessie.cel.common.types.ref.BaseVal;
import org.projectnessie.cel.common.types.ref.Type;
import org.projectnessie.cel.common.types.ref.TypeEnum;
import org.projectnessie.cel.common.types.ref.Val;
import org.projectnessie.cel.common.types.traits.Trait;

public final class UnknownT
extends BaseVal {
    public static final Type UnknownType = TypeT.newTypeValue(TypeEnum.Unknown, new Trait[0]);
    private final long value;

    public static UnknownT unknownOf(long value) {
        return new UnknownT(value);
    }

    private UnknownT(long value) {
        this.value = value;
    }

    @Override
    public <T> T convertToNative(Class<T> typeDesc) {
        if (Long.class.isAssignableFrom(typeDesc) || Long.TYPE.isAssignableFrom(typeDesc) || typeDesc == Object.class) {
            return (T)Long.valueOf(this.value);
        }
        if (typeDesc == Val.class || typeDesc == UnknownT.class) {
            return (T)this;
        }
        throw new RuntimeException(String.format("native type conversion error from '%s' to '%s'", UnknownType, typeDesc.getName()));
    }

    @Override
    public long intValue() {
        return this.value;
    }

    @Override
    public Val convertToType(Type typeVal) {
        return this;
    }

    @Override
    public Val equal(Val other) {
        return this;
    }

    @Override
    public Type type() {
        return UnknownType;
    }

    @Override
    public Object value() {
        return this.value;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UnknownT unknownT = (UnknownT)o;
        return this.value == unknownT.value;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.value);
    }

    public static boolean isUnknown(Object val) {
        return val != null && val.getClass() == UnknownT.class;
    }
}

