/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.multitenant.integration.test;

import com.yammer.metrics.core.Gauge;
import com.yammer.metrics.core.MetricName;
import io.confluent.kafka.multitenant.authorizer.MultiTenantAuthorizer;
import io.confluent.kafka.multitenant.integration.cluster.LogicalCluster;
import io.confluent.kafka.multitenant.integration.cluster.LogicalClusterUser;
import io.confluent.kafka.multitenant.integration.cluster.PhysicalCluster;
import io.confluent.kafka.multitenant.integration.test.IntegrationTestHarness;
import io.confluent.kafka.test.utils.KafkaTestUtils;
import io.confluent.kafka.test.utils.SecurityTestUtils;
import java.time.Duration;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;
import kafka.server.KafkaConfig$;
import org.apache.kafka.clients.admin.AdminClient;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.KafkaFuture;
import org.apache.kafka.common.acl.AccessControlEntry;
import org.apache.kafka.common.acl.AccessControlEntryFilter;
import org.apache.kafka.common.acl.AclBinding;
import org.apache.kafka.common.acl.AclBindingFilter;
import org.apache.kafka.common.acl.AclOperation;
import org.apache.kafka.common.acl.AclPermissionType;
import org.apache.kafka.common.errors.AuthorizationException;
import org.apache.kafka.common.errors.ClusterAuthorizationException;
import org.apache.kafka.common.errors.InvalidRequestException;
import org.apache.kafka.common.errors.TopicAuthorizationException;
import org.apache.kafka.common.errors.UnknownTopicOrPartitionException;
import org.apache.kafka.common.resource.PatternType;
import org.apache.kafka.common.resource.ResourcePattern;
import org.apache.kafka.common.resource.ResourcePatternFilter;
import org.apache.kafka.common.resource.ResourceType;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.security.scram.internals.ScramMechanism;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.server.metrics.KafkaYammerMetrics;
import org.apache.kafka.test.TestUtils;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.TestInfo;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;

@Tag(value="integration")
public class MultiTenantAuthorizerTest {
    private TestInfo testInfo;
    protected IntegrationTestHarness testHarness;
    private final String topic = "test.topic";
    private final String consumerGroup = "test.consumer.group";
    protected PhysicalCluster physicalCluster;
    private LogicalCluster logicalCluster;
    private LogicalClusterUser user1;
    private LogicalClusterUser user2;

    @BeforeEach
    public void setUp(TestInfo testInfo) throws Exception {
        this.testInfo = testInfo;
    }

    @AfterEach
    public void tearDown() throws Exception {
        this.clearYammerMetrics();
        this.testHarness.shutdown();
        KafkaTestUtils.verifyThreadCleanup();
    }

    @AfterAll
    public static void verifyCleanup() {
        KafkaTestUtils.verifyThreadCleanup();
    }

    protected void startTestHarness() {
        this.startTestHarness(this.nodeConfigOverrides());
    }

    protected void startTestHarness(Properties nodeConfigOverrides) {
        this.testHarness = new IntegrationTestHarness(this.testInfo);
        this.physicalCluster = this.testHarness.start(nodeConfigOverrides, nodeConfigOverrides, true, Optional.empty(), cluster -> {});
        this.logicalCluster = this.physicalCluster.createLogicalCluster("tenantA", "testOrg", "testEnv", 100, 1, 2);
        this.user1 = this.logicalCluster.user(1);
        this.user2 = this.logicalCluster.user(2);
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testLiteralAcls(String quorum) throws Throwable {
        this.startTestHarness();
        MultiTenantAuthorizerTest.verifyAclCountMetric(0);
        this.addProducerAcls(this.user1, "test.topic", PatternType.LITERAL);
        this.addConsumerAcls(this.user2, "test.topic", "test.consumer.group", PatternType.LITERAL);
        this.testHarness.produceConsume(this.user1, this.user2, "test.topic", "test.consumer.group", 0);
        this.verifyTopicAuthorizationFailure(this.user1, "sometopic");
        this.verifyConsumerGroupAuthorizationFailure(this.user1, "test.topic", "somegroup");
        SecurityTestUtils.verifyConfluentLicense(this.physicalCluster.kafkaCluster(), null);
        MultiTenantAuthorizerTest.verifyAclCountMetric(6);
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testPrefixedAcls(String quorum) throws Throwable {
        this.startTestHarness();
        this.addProducerAcls(this.user1, "test", PatternType.PREFIXED);
        this.addConsumerAcls(this.user2, "test", "test", PatternType.PREFIXED);
        this.testHarness.produceConsume(this.user1, this.user2, "test.topic", "test.consumer.group", 0);
        this.verifyTopicAuthorizationFailure(this.user1, "sometopic");
        this.verifyConsumerGroupAuthorizationFailure(this.user1, "test.topic", "somegroup");
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testWildcardAcls(String quorum) throws Throwable {
        this.startTestHarness();
        this.physicalCluster.newAclCommand().produceAclArgs(this.prefixedKafkaPrincipal(this.user1), this.user1.tenantPrefix(), PatternType.PREFIXED).execute();
        this.physicalCluster.newAclCommand().consumeAclArgs(this.prefixedKafkaPrincipal(this.user2), this.user2.tenantPrefix(), this.user2.tenantPrefix(), PatternType.PREFIXED).execute();
        this.testHarness.produceConsume(this.user1, this.user2, "test.topic", "test.consumer.group", 0);
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testSuperUsers(String quorum) throws Throwable {
        this.startTestHarness();
        this.testHarness.produceConsume(this.logicalCluster.adminUser(), this.logicalCluster.adminUser(), "test.topic", "test.consumer.group", 0);
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testAclUpdateInZooKeeper(String quorum) throws Throwable {
        this.startTestHarness();
        String topic = "test.topic";
        String consumerGroup = "test.group";
        this.physicalCluster.kafkaCluster().createTopic(this.user1.withPrefix(topic), 3, 1);
        try (KafkaConsumer<String, String> consumer = this.testHarness.createConsumer(this.user1, consumerGroup, SecurityProtocol.SASL_PLAINTEXT);){
            Assertions.assertFalse((boolean)this.checkAuthorized(consumer, topic));
            this.physicalCluster.newAclCommand().addTopicAclArgs(this.prefixedKafkaPrincipal(this.user1), this.user1.withPrefix(topic), AclOperation.DESCRIBE, PatternType.LITERAL).execute();
            this.physicalCluster.newAclCommand().addConsumerGroupAclArgs(this.prefixedKafkaPrincipal(this.user1), this.user1.withPrefix("test.group"), AclOperation.DESCRIBE, PatternType.LITERAL).execute();
            TestUtils.waitForCondition(() -> this.checkAuthorized(consumer, topic), (String)"ACL not applied within timeout");
        }
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testLogicalClusterScope(String quorum) throws Throwable {
        this.startTestHarness();
        this.addProducerAcls(this.user1, "test.topic", PatternType.LITERAL);
        this.addConsumerAcls(this.user1, "test.topic", "test.consumer.group", PatternType.LITERAL);
        this.testHarness.produceConsume(this.user1, this.user1, "test.topic", "test.consumer.group", 0);
        int userId = this.user1.userMetadata.userId();
        LogicalCluster cluster2 = this.physicalCluster.createLogicalCluster("anotherCluster", 100, userId);
        LogicalClusterUser cluster2user1 = cluster2.user(userId);
        this.verifyTopicAuthorizationFailure(cluster2user1, "sometopic");
        this.verifyConsumerGroupAuthorizationFailure(cluster2user1, "test.topic", "somegroup");
        this.addProducerAcls(cluster2user1, "test.topic", PatternType.LITERAL);
        this.addConsumerAcls(cluster2user1, "test.topic", "test.consumer.group", PatternType.LITERAL);
        this.testHarness.produceConsume(cluster2user1, cluster2user1, "test.topic", "test.consumer.group", 0);
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testLiteralAclsUsingAdminClient(String quorum) throws Throwable {
        this.startTestHarness();
        this.addProducerAclsUsingAdminClient(this.user1, "test.topic", PatternType.LITERAL);
        this.addConsumerAclsUsingAdminClient(this.user2, "test.topic", "test.consumer.group", PatternType.LITERAL);
        this.testHarness.produceConsume(this.user1, this.user2, "test.topic", "test.consumer.group", 0);
        this.verifyTopicAuthorizationFailure(this.user1, "sometopic");
        this.verifyConsumerGroupAuthorizationFailure(this.user1, "test.topic", "somegroup");
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testPrefixAclsUsingAdminClient(String quorum) throws Throwable {
        this.startTestHarness();
        this.addProducerAclsUsingAdminClient(this.user1, "test.", PatternType.PREFIXED);
        this.addConsumerAclsUsingAdminClient(this.user2, "test.", "test.", PatternType.PREFIXED);
        this.testHarness.produceConsume(this.user1, this.user2, "test.topic", "test.consumer.group", 0);
        this.verifyTopicAuthorizationFailure(this.user1, "sometopic");
        this.verifyConsumerGroupAuthorizationFailure(this.user1, "test.topic", "somegroup");
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testWildcardAclsUsingAdminClient(String quorum) throws Throwable {
        this.startTestHarness();
        this.addProducerAclsUsingAdminClient(this.user1, "*", PatternType.LITERAL);
        this.addConsumerAclsUsingAdminClient(this.user2, "*", "*", PatternType.LITERAL);
        this.testHarness.produceConsume(this.user1, this.user2, "test.topic", "test.consumer.group", 0);
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testAclCreateDescribeDeleteUsingAdminClient(String quorum) throws Throwable {
        this.startTestHarness();
        this.physicalCluster.newAclCommand().topicBrokerReadAclArgs(PhysicalCluster.BROKER_PRINCIPAL).execute();
        AdminClient superAdminClient = this.physicalCluster.superAdminClient();
        LogicalCluster logicalClusterB = this.physicalCluster.createLogicalCluster("tenantB", 100, 11);
        LogicalClusterUser userB1 = logicalClusterB.user(11);
        AdminClient adminClientA = this.testHarness.createAdminClient(this.logicalCluster.adminUser());
        AdminClient adminClientB = this.testHarness.createAdminClient(logicalClusterB.adminUser());
        ConsumerAcls aclsA = new ConsumerAcls(adminClientA, true);
        ConsumerAcls aclsB = new ConsumerAcls(adminClientB, true);
        aclsA.addAcls(this.user1, "test1.topic", "test1.group", PatternType.LITERAL);
        aclsA.addAcls(this.user2, "prefixed.test2", "prefixed.test2", PatternType.PREFIXED);
        aclsB.addAcls(userB1, "*", "*", PatternType.LITERAL);
        this.physicalCluster.kafkaCluster().createTopic("tenantA_test1.topic", 1, 1);
        this.physicalCluster.kafkaCluster().createTopic("tenantA_prefixed.test2.topic", 2, 1);
        this.physicalCluster.kafkaCluster().createTopic("tenantB_test1.topic", 1, 1);
        KafkaConsumer<String, String> consumer1 = this.testHarness.createConsumer(this.user1, "test1.group", SecurityProtocol.SASL_PLAINTEXT);
        KafkaConsumer<String, String> consumer2 = this.testHarness.createConsumer(this.user2, "prefixed.test2.group", SecurityProtocol.SASL_PLAINTEXT);
        KafkaConsumer<String, String> consumerB1 = this.testHarness.createConsumer(userB1, "test1.group", SecurityProtocol.SASL_PLAINTEXT);
        Assertions.assertTrue((boolean)this.checkAuthorized(consumer1, "test1.topic"));
        Assertions.assertFalse((boolean)this.checkAuthorized(consumer2, "test1.topic"));
        Assertions.assertTrue((boolean)this.checkAuthorized(consumer2, "prefixed.test2.topic"));
        Assertions.assertFalse((boolean)this.checkAuthorized(consumer1, "prefixed.test2.topic"));
        Assertions.assertTrue((boolean)this.checkAuthorized(consumerB1, "test1.topic"));
        ConsumerAcls baseAcls = new ConsumerAcls(superAdminClient, false);
        baseAcls.verifyAllAcls(null, PatternType.ANY);
        baseAcls.verifyAllAcls(null, PatternType.MATCH);
        baseAcls.verifyAcls(ResourceType.TOPIC, null, PatternType.LITERAL, null, new String[]{"*", "tenantA_test1.topic"});
        baseAcls.verifyAcls(ResourceType.GROUP, null, PatternType.PREFIXED, null, new String[]{"tenantA_prefixed.test2", "tenantB_"});
        baseAcls.verifyAcls(ResourceType.ANY, null, PatternType.LITERAL, null, new String[]{"*", "tenantA_test1.topic", "tenantA_test1.group", "tenantA_kafka-cluster", "tenantB_kafka-cluster"});
        baseAcls.verifyAcls(ResourceType.TOPIC, null, PatternType.ANY, null, new String[]{"*", "tenantA_test1.topic", "tenantA_prefixed.test2", "tenantB_"});
        aclsA.verifyAllAcls(null, PatternType.ANY);
        aclsA.verifyAllAcls(null, PatternType.MATCH);
        aclsA.verifyAcls(ResourceType.TOPIC, null, PatternType.LITERAL, null, new String[]{"test1.topic"});
        aclsA.verifyAcls(ResourceType.GROUP, null, PatternType.PREFIXED, null, new String[]{"prefixed.test2"});
        aclsA.verifyAcls(ResourceType.ANY, null, PatternType.LITERAL, null, new String[]{"test1.topic", "test1.group", "kafka-cluster"});
        aclsA.verifyAcls(ResourceType.ANY, null, PatternType.LITERAL, this.user1, new String[]{"test1.topic", "test1.group", "kafka-cluster"});
        aclsA.verifyAcls(ResourceType.TOPIC, null, PatternType.ANY, null, new String[]{"test1.topic", "prefixed.test2"});
        aclsB.verifyAllAcls(null, PatternType.ANY);
        aclsB.verifyAcls(ResourceType.TOPIC, "*", PatternType.LITERAL, userB1, new String[]{"*"});
        aclsB.verifyAcls(ResourceType.TOPIC, "*", PatternType.ANY, userB1, new String[]{"*"});
        aclsB.verifyAcls(ResourceType.TOPIC, "*", PatternType.PREFIXED, userB1, new String[0]);
        aclsB.verifyAcls(ResourceType.TOPIC, null, PatternType.LITERAL, userB1, new String[]{"*"});
        aclsB.verifyAcls(ResourceType.ANY, null, PatternType.LITERAL, null, new String[]{"*", "kafka-cluster"});
        aclsB.verifyAcls(ResourceType.TOPIC, null, PatternType.PREFIXED, userB1, new String[0]);
        aclsB.verifyAcls(ResourceType.ANY, "kafka-cluster", PatternType.LITERAL, userB1, new String[]{"kafka-cluster"});
        baseAcls.verifyAcls(ResourceType.ANY, "tenantA_prefixed.test2.topic", PatternType.MATCH, null, new String[]{"tenantA_prefixed.test2", "*"});
        baseAcls.verifyAcls(ResourceType.TOPIC, null, PatternType.MATCH, null, new String[]{"tenantA_test1.topic", "tenantA_prefixed.test2", "tenantB_", "*"});
        aclsA.verifyAcls(ResourceType.ANY, "prefixed.test2.topic", PatternType.MATCH, null, new String[]{"prefixed.test2"});
        aclsA.verifyAcls(ResourceType.ANY, "prefixed.test2.topic", PatternType.MATCH, this.user2, new String[]{"prefixed.test2"});
        aclsA.verifyAcls(ResourceType.TOPIC, null, PatternType.MATCH, this.user1, new String[]{"test1.topic"});
        aclsB.verifyAcls(ResourceType.TOPIC, "test", PatternType.MATCH, userB1, new String[]{"*"});
        aclsB.verifyAcls(ResourceType.TOPIC, "*", PatternType.MATCH, userB1, new String[]{"*"});
        aclsB.verifyAcls(ResourceType.TOPIC, null, PatternType.MATCH, null, new String[]{"*"});
        Assertions.assertTrue((boolean)this.checkAuthorized(consumer1, "test1.topic"));
        aclsA.deleteAcls(ResourceType.TOPIC, "test1.topic", PatternType.LITERAL, null);
        TestUtils.retryOnExceptionWithTimeout(() -> {
            Assertions.assertFalse((boolean)this.checkAuthorized(consumer1, "test1.topic"));
            aclsA.verifyAllAcls(null, PatternType.ANY);
            Assertions.assertTrue((boolean)this.checkAuthorized(consumer2, "prefixed.test2.topic"));
        });
        aclsA.deleteAcls(ResourceType.TOPIC, "prefixed.test2.topic", PatternType.MATCH, this.user2);
        TestUtils.retryOnExceptionWithTimeout(() -> {
            Assertions.assertFalse((boolean)this.checkAuthorized(consumer2, "prefixed.test2.topic"));
            aclsA.verifyAllAcls(null, PatternType.ANY);
            Assertions.assertTrue((boolean)this.checkAuthorized(consumerB1, "test1.topic"));
        });
        aclsB.deleteAcls(ResourceType.TOPIC, null, PatternType.MATCH, userB1);
        TestUtils.retryOnExceptionWithTimeout(() -> {
            Assertions.assertFalse((boolean)this.checkAuthorized(consumerB1, "test1.topic"));
            aclsB.verifyAllAcls(null, PatternType.MATCH);
        });
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testAclLimit(String quorum) throws Throwable {
        this.startTestHarness();
        this.addProducerAcls(this.user1, "test.topic", PatternType.LITERAL);
        this.addConsumerAcls(this.user2, "test.topic", "test.consumer.group", PatternType.LITERAL);
        Function<String, AclBinding> topicAcl = topic -> new AclBinding(new ResourcePattern(ResourceType.TOPIC, topic, PatternType.LITERAL), new AccessControlEntry(this.unprefixedKafkaPrincipal(this.user1), "*", AclOperation.WRITE, AclPermissionType.ALLOW));
        try (AdminClient adminClient = this.testHarness.createAdminClient(this.logicalCluster.adminUser());){
            int aclCount = ((Collection)adminClient.describeAcls(new AclBindingFilter(new ResourcePatternFilter(ResourceType.ANY, null, PatternType.ANY), new AccessControlEntryFilter(null, null, AclOperation.ANY, AclPermissionType.ANY))).values().get()).size();
            for (int i = 0; i < 100 - aclCount; ++i) {
                adminClient.createAcls(Collections.singleton(topicAcl.apply("topic" + i))).all().get();
            }
            TestUtils.assertFutureThrows((Future)adminClient.createAcls(Collections.singleton(topicAcl.apply("othertopic"))).all(), InvalidRequestException.class);
        }
        LogicalCluster logicalCluster2 = this.physicalCluster.createLogicalCluster("anotherCluster", 100, new Integer[0]);
        try (AdminClient adminClient = this.testHarness.createAdminClient(logicalCluster2.adminUser());){
            adminClient.createAcls(Collections.singleton(topicAcl.apply("sometopic"))).all().get();
        }
        this.testHarness.produceConsume(this.user1, this.user2, "test.topic", "test.consumer.group", 0);
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testAclMultiTenantValidation(String quorum) throws Throwable {
        this.startTestHarness();
        AdminClient superAdminClient = this.physicalCluster.superAdminClient();
        AclBinding user1TopicAcl = new AclBinding(new ResourcePattern(ResourceType.TOPIC, this.user1.withPrefix("test.topic"), PatternType.LITERAL), new AccessControlEntry(this.prefixedKafkaPrincipal(this.user1).toString(), "*", AclOperation.READ, AclPermissionType.ALLOW));
        AclBinding user1ConsumerGroupAcl = new AclBinding(new ResourcePattern(ResourceType.GROUP, this.user1.withPrefix("test.consumer.group"), PatternType.LITERAL), new AccessControlEntry(this.prefixedKafkaPrincipal(this.user1).toString(), "*", AclOperation.ALL, AclPermissionType.ALLOW));
        Map successResult = superAdminClient.createAcls(Arrays.asList(user1TopicAcl, user1ConsumerGroupAcl)).values();
        Assertions.assertEquals((int)2, (int)successResult.size());
        for (Map.Entry entry : successResult.entrySet()) {
            ((KafkaFuture)entry.getValue()).get();
            Assertions.assertTrue((boolean)((KafkaFuture)entry.getValue()).isDone());
            Assertions.assertFalse((boolean)((KafkaFuture)entry.getValue()).isCompletedExceptionally());
        }
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testAclMultiTenantValidationFailureMultipleTenants(String quorum) throws Throwable {
        this.startTestHarness();
        AdminClient superAdminClient = this.physicalCluster.superAdminClient();
        AclBinding user1TopicAcl = new AclBinding(new ResourcePattern(ResourceType.TOPIC, this.user1.withPrefix("test.topic"), PatternType.LITERAL), new AccessControlEntry(this.prefixedKafkaPrincipal(this.user1).toString(), "*", AclOperation.READ, AclPermissionType.ALLOW));
        LogicalCluster logicalCluster2 = this.physicalCluster.createLogicalCluster("tenantB", "testOrg", "testEnv", 100, 1, 2);
        LogicalClusterUser logicalCluster2User = logicalCluster2.user(1);
        AclBinding user2TopicAcl = new AclBinding(new ResourcePattern(ResourceType.TOPIC, logicalCluster2User.withPrefix("test.topic"), PatternType.LITERAL), new AccessControlEntry(this.prefixedKafkaPrincipal(logicalCluster2User).toString(), "*", AclOperation.READ, AclPermissionType.ALLOW));
        InvalidRequestException exception = (InvalidRequestException)TestUtils.assertFutureThrows((Future)superAdminClient.createAcls(Arrays.asList(user1TopicAcl, user2TopicAcl)).all(), InvalidRequestException.class);
        Assertions.assertTrue((boolean)exception.getMessage().startsWith("Internal error: Could not create ACLs because all principals are not in the same scope"));
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testAclMultiTenantValidationFailureMultiTenantsAndNonMultiTenants(String quorum) throws Throwable {
        this.startTestHarness();
        AdminClient superAdminClient = this.physicalCluster.superAdminClient();
        AclBinding user1TopicAcl = new AclBinding(new ResourcePattern(ResourceType.TOPIC, this.user1.withPrefix("test.topic"), PatternType.LITERAL), new AccessControlEntry(this.prefixedKafkaPrincipal(this.user1).toString(), "*", AclOperation.READ, AclPermissionType.ALLOW));
        AclBinding nonMtTopicAcl = new AclBinding(new ResourcePattern(ResourceType.TOPIC, "test.topic", PatternType.LITERAL), new AccessControlEntry(new KafkaPrincipal("User", "Bob").toString(), "*", AclOperation.READ, AclPermissionType.ALLOW));
        InvalidRequestException exception = (InvalidRequestException)TestUtils.assertFutureThrows((Future)superAdminClient.createAcls(Arrays.asList(nonMtTopicAcl, user1TopicAcl)).all(), InvalidRequestException.class);
        Assertions.assertTrue((boolean)exception.getMessage().startsWith("Internal error: Could not create ACLs because all principals are not in the same scope"));
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testAuthorizerDisabledUsingAclLimit(String quorum) throws Throwable {
        Properties nodeConfigOverrides = this.nodeConfigOverrides();
        nodeConfigOverrides.put("confluent.max.acls.per.tenant", "0");
        this.startTestHarness(nodeConfigOverrides);
        AclBinding topicAcl = new AclBinding(new ResourcePattern(ResourceType.TOPIC, "test.topic", PatternType.LITERAL), new AccessControlEntry(this.unprefixedKafkaPrincipal(this.user1), "*", AclOperation.WRITE, AclPermissionType.ALLOW));
        AclBindingFilter topicFilter = new AclBindingFilter(new ResourcePatternFilter(ResourceType.ANY, null, PatternType.ANY), new AccessControlEntryFilter(null, null, AclOperation.ANY, AclPermissionType.ANY));
        try (AdminClient adminClient = this.testHarness.createAdminClient(this.logicalCluster.adminUser());){
            try {
                adminClient.createAcls(Collections.singleton(topicAcl)).all().get();
            }
            catch (ExecutionException e) {
                this.verifyAclsDisabledException(e);
            }
            try {
                adminClient.describeAcls(topicFilter).values().get();
            }
            catch (ExecutionException e) {
                this.verifyAclsDisabledException(e);
            }
            try {
                adminClient.deleteAcls(Collections.singleton(topicFilter)).all().get();
            }
            catch (ExecutionException e) {
                this.verifyAclsDisabledException(e);
            }
        }
        this.testHarness.produceConsume(this.user1, this.user2, "test.topic", "test.consumer.group", 0);
    }

    private void verifyAclsDisabledException(ExecutionException e) {
        Throwable cause = e.getCause();
        Assertions.assertTrue((boolean)(cause instanceof InvalidRequestException), (String)("Unexpected exception: " + cause));
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testInvalidAcl(String quorum) {
        this.startTestHarness();
        try (AdminClient adminClient = this.testHarness.createAdminClient(this.logicalCluster.adminUser());){
            List<String> invalidPrincipals = Arrays.asList("", "userWithoutPrincipalType");
            invalidPrincipals.forEach(principal -> {
                AclBinding acl = new AclBinding(new ResourcePattern(ResourceType.TOPIC, "test.topic", PatternType.LITERAL), new AccessControlEntry(principal, "*", AclOperation.WRITE, AclPermissionType.ALLOW));
                try {
                    adminClient.createAcls(Collections.singleton(acl)).all().get();
                    Assertions.fail((String)"createAcls didn't fail with invalid principal");
                }
                catch (Exception e) {
                    Assertions.assertTrue((e instanceof ExecutionException && e.getCause() instanceof InvalidRequestException ? 1 : 0) != 0, (String)("Invalid exception: " + e));
                }
            });
        }
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testAuthorizeByResourceType(String quorum) throws Throwable {
        this.startTestHarness();
        this.physicalCluster.kafkaCluster().createTopic(this.user1.withPrefix("test.topic"), 1, 1);
        AdminClient adminClient = this.testHarness.createAdminClient(this.user1);
        this.physicalCluster.newAclCommand().addTopicAclArgs(this.prefixedKafkaPrincipal(this.user1), this.user1.withPrefix("test.topic"), AclOperation.DESCRIBE, PatternType.LITERAL).execute();
        TestUtils.waitForCondition(() -> this.checkDescribeAuthorized(adminClient, "test.topic"), (String)"ACL not applied within timeout");
        this.verifyIdempotentProducer(this.user1, "test.topic", ClusterAuthorizationException.class);
        this.physicalCluster.newAclCommand().addTopicAclArgs(this.prefixedKafkaPrincipal(this.user1), this.user1.withPrefix("prefix"), AclOperation.ALL, PatternType.PREFIXED).execute();
        TestUtils.waitForCondition(() -> this.checkDescribeAuthorized(adminClient, "prefix.topic1"), (String)"ACL not applied within timeout");
        this.physicalCluster.newAclCommand().addTopicDenyAclArgs(this.prefixedKafkaPrincipal(this.user1), this.user1.withPrefix("prefix"), AclOperation.ALL, PatternType.PREFIXED).execute();
        TestUtils.waitForCondition(() -> !this.checkDescribeAuthorized(adminClient, "prefix.topic2"), (String)"ACL not applied within timeout");
        this.verifyIdempotentProducer(this.user1, "test.topic", ClusterAuthorizationException.class);
        this.physicalCluster.newAclCommand().addTopicAclArgs(this.prefixedKafkaPrincipal(this.user2), this.user2.tenantPrefix(), AclOperation.ALL, PatternType.PREFIXED).execute();
        this.verifyIdempotentProducer(this.user1, "test.topic", ClusterAuthorizationException.class);
        this.physicalCluster.newAclCommand().addTopicAclArgs(this.prefixedKafkaPrincipal(this.user1), this.user1.withPrefix("another"), AclOperation.ALL, PatternType.PREFIXED).execute();
        TestUtils.waitForCondition(() -> this.checkDescribeAuthorized(adminClient, "another.topic"), (String)"ACL not applied within timeout");
        this.verifyIdempotentProducer(this.user1, "test.topic", TopicAuthorizationException.class);
        this.physicalCluster.newAclCommand().addTopicAclArgs(this.prefixedKafkaPrincipal(this.user1), this.user1.withPrefix("test.topic"), AclOperation.WRITE, PatternType.LITERAL).execute();
        this.verifyIdempotentProducer(this.user1, "test.topic", null);
    }

    protected Properties nodeConfigOverrides() {
        Properties props = new Properties();
        props.put(KafkaConfig$.MODULE$.AuthorizerClassNameProp(), MultiTenantAuthorizer.class.getName());
        props.put("confluent.max.acls.per.tenant", "100");
        props.put("confluent.broker.type.topic.enabled", "false");
        return props;
    }

    protected void addProducerAcls(LogicalClusterUser user, String topic, PatternType patternType) {
        this.physicalCluster.newAclCommand().produceAclArgs(this.prefixedKafkaPrincipal(user), user.withPrefix(topic), patternType).execute();
    }

    protected void addConsumerAcls(LogicalClusterUser user, String topic, String consumerGroup, PatternType patternType) {
        this.physicalCluster.newAclCommand().consumeAclArgs(this.prefixedKafkaPrincipal(user), user.withPrefix(topic), user.withPrefix(consumerGroup), patternType).execute();
    }

    protected void addTopicDenyAcls(LogicalClusterUser user, String topic, PatternType patternType) {
        this.physicalCluster.newAclCommand().addTopicDenyAclArgs(this.prefixedKafkaPrincipal(user), user.withPrefix(topic), AclOperation.ALL, patternType).execute();
    }

    private void addProducerAclsUsingAdminClient(LogicalClusterUser user, String topic, PatternType patternType) throws Exception {
        try (AdminClient adminClient = this.testHarness.createAdminClient(this.logicalCluster.adminUser());){
            this.addProducerAcls(adminClient, user, topic, patternType);
        }
    }

    private void addProducerAcls(AdminClient adminClient, LogicalClusterUser user, String topic, PatternType patternType) throws Exception {
        AclBinding topicAcl = new AclBinding(new ResourcePattern(ResourceType.TOPIC, topic, patternType), new AccessControlEntry(this.unprefixedKafkaPrincipal(user), "*", AclOperation.WRITE, AclPermissionType.ALLOW));
        AclBinding clusterAcl = new AclBinding(new ResourcePattern(ResourceType.CLUSTER, "kafka-cluster", patternType), new AccessControlEntry(this.unprefixedKafkaPrincipal(user), "*", AclOperation.DESCRIBE, AclPermissionType.ALLOW));
        adminClient.createAcls(Arrays.asList(topicAcl, clusterAcl)).all().get();
    }

    private void addConsumerAclsUsingAdminClient(LogicalClusterUser user, String topic, String consumerGroup, PatternType patternType) throws Exception {
        try (AdminClient adminClient = this.testHarness.createAdminClient(this.logicalCluster.adminUser());){
            this.addConsumerAcls(adminClient, user, topic, consumerGroup, patternType);
        }
    }

    private void addConsumerAcls(AdminClient adminClient, LogicalClusterUser user, String topic, String consumerGroup, PatternType patternType) throws Exception {
        List<AclBinding> acls = this.consumerAcls(user, topic, consumerGroup, patternType);
        adminClient.createAcls(acls).all().get();
    }

    private List<AclBinding> consumerAcls(LogicalClusterUser user, String topic, String consumerGroup, PatternType patternType) {
        AclBinding topicAcl = new AclBinding(new ResourcePattern(ResourceType.TOPIC, topic, patternType), new AccessControlEntry(this.unprefixedKafkaPrincipal(user), "*", AclOperation.READ, AclPermissionType.ALLOW));
        AclBinding consumerGroupAcl = new AclBinding(new ResourcePattern(ResourceType.GROUP, consumerGroup, patternType), new AccessControlEntry(this.unprefixedKafkaPrincipal(user), "*", AclOperation.ALL, AclPermissionType.ALLOW));
        AclBinding clusterAcl = new AclBinding(new ResourcePattern(ResourceType.CLUSTER, "kafka-cluster", patternType), new AccessControlEntry(this.unprefixedKafkaPrincipal(user), "*", AclOperation.DESCRIBE, AclPermissionType.ALLOW));
        return Arrays.asList(topicAcl, consumerGroupAcl, clusterAcl);
    }

    protected KafkaPrincipal prefixedKafkaPrincipal(LogicalClusterUser user) {
        return user.prefixedKafkaPrincipal();
    }

    protected String unprefixedKafkaPrincipal(LogicalClusterUser user) {
        return user.unprefixedKafkaPrincipal().toString();
    }

    protected void verifyTopicAuthorizationFailure(LogicalClusterUser user, String topic) {
        try (KafkaProducer<String, String> producer = this.testHarness.createProducer(user, SecurityProtocol.SASL_PLAINTEXT);){
            try {
                producer.partitionsFor(topic);
                Assertions.fail((String)"Authorization should have failed");
            }
            catch (AuthorizationException authorizationException) {
                // empty catch block
            }
        }
    }

    protected void verifyConsumerGroupAuthorizationFailure(LogicalClusterUser user, String topic, String group) {
        try (KafkaConsumer<String, String> consumer = this.testHarness.createConsumer(user, group, SecurityProtocol.SASL_PLAINTEXT);){
            consumer.subscribe(Collections.singleton(topic));
            consumer.poll(Duration.ofSeconds(5L));
            Assertions.fail((String)"Authorization should have failed");
        }
        catch (AuthorizationException authorizationException) {
            // empty catch block
        }
    }

    private boolean checkAuthorized(KafkaConsumer<?, ?> consumer, String topic) {
        try {
            consumer.partitionsFor(topic).size();
            return true;
        }
        catch (AuthorizationException e) {
            return false;
        }
    }

    protected boolean checkDescribeAuthorized(AdminClient adminClient, String topic) {
        return this.checkDescribeAuthorized(adminClient, Arrays.asList(topic));
    }

    protected boolean checkDescribeAuthorized(AdminClient adminClient, Collection<String> topics) {
        try {
            try {
                adminClient.describeTopics(topics).allTopicNames().get(15L, TimeUnit.SECONDS);
            }
            catch (ExecutionException e) {
                throw e.getCause();
            }
            return true;
        }
        catch (AuthorizationException e) {
            return false;
        }
        catch (UnknownTopicOrPartitionException e) {
            return true;
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }

    protected void verifyIdempotentProducer(LogicalClusterUser user, String topic, Class<? extends AuthorizationException> exceptionClass) throws Throwable {
        Properties producerProps = KafkaTestUtils.producerProps(this.physicalCluster.bootstrapServers(), SecurityProtocol.SASL_PLAINTEXT, ScramMechanism.SCRAM_SHA_256.mechanismName(), user.saslJaasConfig());
        producerProps.setProperty("enable.idempotence", "true");
        try (KafkaProducer producer = new KafkaProducer(producerProps);){
            if (exceptionClass != null) {
                KafkaException exception = (KafkaException)Assertions.assertThrows(KafkaException.class, () -> KafkaTestUtils.sendRecords((KafkaProducer<String, String>)producer, topic, 0, 1));
                if (exception instanceof AuthorizationException) {
                    Assertions.assertTrue((boolean)exceptionClass.isInstance((Object)exception));
                } else {
                    Assertions.assertTrue((boolean)exceptionClass.isInstance(exception.getCause()));
                }
            } else {
                KafkaTestUtils.sendRecords((KafkaProducer<String, String>)producer, topic, 0, 1);
            }
        }
    }

    public static void verifyAclCountMetric(int expectedValue) {
        Set metrics = KafkaYammerMetrics.defaultRegistry().allMetrics().entrySet().stream().filter(e -> ((MetricName)e.getKey()).getName().equals("AclCount")).map(Map.Entry::getValue).collect(Collectors.toSet());
        Assertions.assertFalse((boolean)metrics.isEmpty());
        long value = metrics.stream().mapToLong(m -> ((Number)((Gauge)m).value()).longValue()).sum();
        Assertions.assertEquals((long)expectedValue, (long)value);
    }

    private void clearYammerMetrics() {
        for (MetricName metricName : KafkaYammerMetrics.defaultRegistry().allMetrics().keySet()) {
            KafkaYammerMetrics.defaultRegistry().removeMetric(metricName);
        }
    }

    private class ConsumerAcls {
        private final AdminClient adminClient;
        private final Set<AclBinding> acls;
        private final boolean tenantOnly;

        ConsumerAcls(AdminClient adminClient, boolean tenantOnly) throws Exception {
            this.adminClient = adminClient;
            this.tenantOnly = tenantOnly;
            this.acls = new HashSet<AclBinding>();
            this.acls.addAll(this.describeAcls(null, PatternType.ANY));
        }

        private void addAcls(LogicalClusterUser user, String topic, String consumerGroup, PatternType patternType) throws Exception {
            List consumerAcls = MultiTenantAuthorizerTest.this.consumerAcls(user, topic, consumerGroup, patternType);
            this.adminClient.createAcls((Collection)consumerAcls).all().get();
            this.acls.addAll(consumerAcls);
        }

        private void deleteAcls(ResourceType resourceType, String resourceName, PatternType patternType, LogicalClusterUser user) throws Exception {
            String principal = user == null ? null : MultiTenantAuthorizerTest.this.unprefixedKafkaPrincipal(user);
            Collection deletedAcls = (Collection)this.adminClient.deleteAcls(Collections.singletonList(new AclBindingFilter(new ResourcePatternFilter(resourceType, resourceName, patternType), new AccessControlEntryFilter(principal, null, AclOperation.ANY, AclPermissionType.ANY)))).all().get();
            this.acls.removeAll(deletedAcls);
        }

        private Set<AclBinding> describeAcls(String resourceName, PatternType patternType) throws Exception {
            Collection describedAcls = (Collection)this.adminClient.describeAcls(new AclBindingFilter(new ResourcePatternFilter(ResourceType.ANY, resourceName, patternType), new AccessControlEntryFilter(null, null, AclOperation.ANY, AclPermissionType.ANY))).values().get();
            return new HashSet<AclBinding>(describedAcls);
        }

        private void verifyAllAcls(String resourceName, PatternType patternType) throws Exception {
            Set<AclBinding> describedAcls = this.describeAcls(resourceName, patternType);
            Assertions.assertEquals(this.acls, describedAcls);
        }

        private void verifyAcls(ResourceType resourceType, String resourceName, PatternType patternType, LogicalClusterUser user, String ... expectedResources) throws Exception {
            String principal = user == null ? null : MultiTenantAuthorizerTest.this.unprefixedKafkaPrincipal(user);
            Collection acls = (Collection)this.adminClient.describeAcls(new AclBindingFilter(new ResourcePatternFilter(resourceType, resourceName, patternType), new AccessControlEntryFilter(principal, null, AclOperation.ANY, AclPermissionType.ANY))).values().get();
            Set aclResources = acls.stream().map(acl -> acl.pattern().name()).collect(Collectors.toSet());
            Assertions.assertEquals((Object)Utils.mkSet((Object[])expectedResources), aclResources);
            if (this.tenantOnly) {
                acls.forEach(acl -> Assertions.assertFalse((boolean)acl.entry().principal().contains(PhysicalCluster.BROKER_PRINCIPAL.getName()), (String)("Unexpected acl " + acl)));
            }
        }
    }
}

