/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.server.plugins.auth;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.confluent.kafka.multitenant.MultiTenantPrincipal;
import io.confluent.kafka.server.plugins.auth.AbstractFileBasedPlainSaslAuthenticatorTest;
import io.confluent.kafka.server.plugins.auth.AuthAttemptCache;
import io.confluent.kafka.server.plugins.auth.FileBasedPlainSaslAuthenticator;
import io.confluent.kafka.server.plugins.auth.MultiTenantSaslConfigEntry;
import io.confluent.kafka.server.plugins.auth.MultiTenantSaslSecrets;
import io.confluent.kafka.server.plugins.auth.MultiTenantSaslSecretsLoader;
import java.io.File;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Collections;
import java.util.Optional;
import org.apache.kafka.common.errors.SaslAuthenticationException;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.Time;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class FileBasedPlainSaslAuthenticatorCachingTest
extends AbstractFileBasedPlainSaslAuthenticatorTest {
    private AuthAttemptCache successfulAuthCache;
    private AuthAttemptCache failedAuthCache;
    private MultiTenantSaslSecretsLoader secretsLoader;

    @Override
    @BeforeEach
    public void setUp() throws Exception {
        this.failedAuthCache = new AuthAttemptCache();
        this.successfulAuthCache = new AuthAttemptCache();
        this.secretsLoader = new MultiTenantSaslSecretsLoader(3);
        super.setUp();
    }

    @Override
    protected FileBasedPlainSaslAuthenticator createAuthenticator() {
        return new FileBasedPlainSaslAuthenticator(this.successfulAuthCache, this.failedAuthCache, this.secretsLoader);
    }

    @Test
    public void testCacheSuccess() throws Exception {
        MultiTenantPrincipal principal = this.saslAuth.authenticate("bkey", "MKRWvhKV5Xd8VQ05JYre6f+aAq0UBXutZjsHWnQd/GYNR6DfqFeay+VNnReeTRpe", Optional.empty(), Optional.empty(), Optional.empty());
        Assertions.assertNotNull((Object)principal);
        String hash = this.successfulAuthCache.get("bkey", "MKRWvhKV5Xd8VQ05JYre6f+aAq0UBXutZjsHWnQd/GYNR6DfqFeay+VNnReeTRpe");
        Assertions.assertNotNull((Object)hash);
        Assertions.assertNull((Object)this.failedAuthCache.get("bkey", "MKRWvhKV5Xd8VQ05JYre6f+aAq0UBXutZjsHWnQd/GYNR6DfqFeay+VNnReeTRpe"));
    }

    @Test
    public void testCacheFailure() throws Exception {
        String wrongPwd = "wrong pwd";
        try {
            this.saslAuth.authenticate("bkey", wrongPwd, Optional.empty(), Optional.empty(), Optional.empty());
            Assertions.fail((String)"Should throw exception");
        }
        catch (SaslAuthenticationException saslAuthenticationException) {
            // empty catch block
        }
        String hash = this.failedAuthCache.get("bkey", wrongPwd);
        Assertions.assertNotNull((Object)hash);
        Assertions.assertNull((Object)this.successfulAuthCache.get("bkey", wrongPwd));
    }

    @Test
    public void testTtlSuccessfulAuth() throws Exception {
        MockTime time = new MockTime();
        long ttl = 10000L;
        this.successfulAuthCache = new AuthAttemptCache(ttl, 10000, (Time)time, 10);
        super.setUp();
        MultiTenantPrincipal principal = this.saslAuth.authenticate("bkey", "MKRWvhKV5Xd8VQ05JYre6f+aAq0UBXutZjsHWnQd/GYNR6DfqFeay+VNnReeTRpe", Optional.empty(), Optional.empty(), Optional.empty());
        Assertions.assertNotNull((Object)principal);
        Assertions.assertNotNull((Object)this.successfulAuthCache.get("bkey", "MKRWvhKV5Xd8VQ05JYre6f+aAq0UBXutZjsHWnQd/GYNR6DfqFeay+VNnReeTRpe"));
        time.sleep(ttl - 1L);
        this.successfulAuthCache.get("foo", "bar");
        Assertions.assertNotNull((Object)this.successfulAuthCache.get("bkey", "MKRWvhKV5Xd8VQ05JYre6f+aAq0UBXutZjsHWnQd/GYNR6DfqFeay+VNnReeTRpe"));
        time.sleep(ttl - 1L);
        this.successfulAuthCache.get("foo", "bar");
        Assertions.assertNotNull((Object)this.successfulAuthCache.get("bkey", "MKRWvhKV5Xd8VQ05JYre6f+aAq0UBXutZjsHWnQd/GYNR6DfqFeay+VNnReeTRpe"));
        time.sleep(ttl);
        this.successfulAuthCache.get("foo", "bar");
        Assertions.assertNull((Object)this.successfulAuthCache.get("bkey", "MKRWvhKV5Xd8VQ05JYre6f+aAq0UBXutZjsHWnQd/GYNR6DfqFeay+VNnReeTRpe"));
    }

    @Test
    public void testTtlFailedAuth() throws Exception {
        MockTime time = new MockTime();
        long ttl = 10000L;
        this.failedAuthCache = new AuthAttemptCache(ttl, 10000, (Time)time, 10);
        super.setUp();
        String badPwd = "bad pwd";
        try {
            this.saslAuth.authenticate("bkey", badPwd, Optional.empty(), Optional.empty(), Optional.empty());
            Assertions.fail((String)"Should throw exception");
        }
        catch (SaslAuthenticationException saslAuthenticationException) {
            // empty catch block
        }
        Assertions.assertNotNull((Object)this.failedAuthCache.get("bkey", badPwd));
        time.sleep(ttl - 1L);
        this.failedAuthCache.get("foo", "bar");
        Assertions.assertNotNull((Object)this.failedAuthCache.get("bkey", badPwd));
        time.sleep(ttl - 1L);
        this.failedAuthCache.get("foo", "bar");
        Assertions.assertNotNull((Object)this.failedAuthCache.get("bkey", badPwd));
        time.sleep(ttl);
        this.failedAuthCache.get("foo", "bar");
        Assertions.assertNull((Object)this.failedAuthCache.get("bkey", badPwd));
    }

    @Test
    public void testUserRemoved() throws Exception {
        MultiTenantPrincipal principal = this.saslAuth.authenticate("bkey", "MKRWvhKV5Xd8VQ05JYre6f+aAq0UBXutZjsHWnQd/GYNR6DfqFeay+VNnReeTRpe", Optional.empty(), Optional.empty(), Optional.empty());
        Assertions.assertNotNull((Object)principal);
        Assertions.assertNotNull((Object)this.successfulAuthCache.get("bkey", "MKRWvhKV5Xd8VQ05JYre6f+aAq0UBXutZjsHWnQd/GYNR6DfqFeay+VNnReeTRpe"));
        File file = File.createTempFile("kafka", ".tmp");
        try {
            Files.write(file.toPath(), new String("{\"keys\":{}}").getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
            this.saslAuth.setConfigFilePath(file.getAbsolutePath());
            Assertions.assertThrows(SaslAuthenticationException.class, () -> this.saslAuth.authenticate("bkey", "MKRWvhKV5Xd8VQ05JYre6f+aAq0UBXutZjsHWnQd/GYNR6DfqFeay+VNnReeTRpe", Optional.empty(), Optional.empty(), Optional.empty()));
        }
        finally {
            Files.delete(file.toPath());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testUserPasswordChanged() throws Exception {
        MultiTenantPrincipal principal = this.saslAuth.authenticate("bkey", "MKRWvhKV5Xd8VQ05JYre6f+aAq0UBXutZjsHWnQd/GYNR6DfqFeay+VNnReeTRpe", Optional.empty(), Optional.empty(), Optional.empty());
        Assertions.assertNotNull((Object)principal);
        Assertions.assertNotNull((Object)this.successfulAuthCache.get("bkey", "MKRWvhKV5Xd8VQ05JYre6f+aAq0UBXutZjsHWnQd/GYNR6DfqFeay+VNnReeTRpe"));
        MultiTenantSaslSecrets secrets = new MultiTenantSaslSecrets(Collections.singletonMap("bkey", new MultiTenantSaslConfigEntry("PLAIN", "foobar", "none", "23", "lkc-bkey", false, "u-23")));
        ObjectMapper objectMapper = new ObjectMapper();
        File file = File.createTempFile("kafka", ".tmp");
        try {
            objectMapper.writeValue(file, (Object)secrets);
            this.saslAuth.setConfigFilePath(file.getAbsolutePath());
            Assertions.assertThrows(SaslAuthenticationException.class, () -> this.saslAuth.authenticate("bkey", "MKRWvhKV5Xd8VQ05JYre6f+aAq0UBXutZjsHWnQd/GYNR6DfqFeay+VNnReeTRpe", Optional.empty(), Optional.empty(), Optional.empty()));
            this.saslAuth.authenticate("bkey", "foobar", Optional.empty(), Optional.empty(), Optional.empty());
        }
        finally {
            Files.delete(file.toPath());
        }
    }
}

