/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.shell.confluent;

import java.io.File;
import java.util.Collections;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import kafka.common.TenantHelpers;
import kafka.utils.FileLock;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.image.loader.MetadataLoader;
import org.apache.kafka.metadata.KafkaConfigSchema;
import org.apache.kafka.metadata.MetadataEncryptorFactory;
import org.apache.kafka.metadata.util.ClusterMetadataSource;
import org.apache.kafka.raft.RaftClient;
import org.apache.kafka.server.fault.FaultHandler;
import org.apache.kafka.server.fault.LoggingFaultHandler;
import org.apache.kafka.shell.node.RootShellNode;
import org.apache.kafka.shell.state.MetadataShellPublisher;
import org.apache.kafka.shell.state.MetadataShellState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ShellSourceManager
implements AutoCloseable {
    private static final Logger log = LoggerFactory.getLogger(ShellSourceManager.class);
    private final MetadataShellState state;
    private final FaultHandler faultHandler;
    private final ClusterMetadataSource source;
    private final MetadataEncryptorFactory encryptorFactory;
    private final MetadataLoader loader;
    private final MetadataShellPublisher publisher;
    private AtomicReference<FileLock> fileLock;

    static File parent(File file) {
        File parent = file.getParentFile();
        if (parent == null) {
            return file;
        }
        return parent;
    }

    static FileLock takeDirectoryLockIfExists(File directory) {
        if (new File(directory, ".lock").exists()) {
            return ShellSourceManager.takeDirectoryLock(directory);
        }
        return null;
    }

    static FileLock takeDirectoryLock(File directory) {
        FileLock fileLock = new FileLock(new File(directory, ".lock"));
        try {
            if (!fileLock.tryLock()) {
                throw new RuntimeException("Unable to lock " + directory.getAbsolutePath() + ". Please ensure that no broker or controller process is using this directory before proceeding.");
            }
        }
        catch (Throwable e) {
            fileLock.destroy();
            throw e;
        }
        return fileLock;
    }

    public ShellSourceManager(ClusterMetadataSource source, Properties configProps, KafkaConfigSchema configSchema, Optional<File> directoryPath) throws Exception {
        this.fileLock = directoryPath.isPresent() ? new AtomicReference<FileLock>(ShellSourceManager.takeDirectoryLockIfExists(ShellSourceManager.parent(directoryPath.get()))) : new AtomicReference<Object>(null);
        this.state = new MetadataShellState(configSchema);
        this.faultHandler = new LoggingFaultHandler("shell", () -> this.state.numFaultsSeen().incrementAndGet());
        this.source = source;
        this.encryptorFactory = MetadataEncryptorFactory.fromProperties((Properties)configProps);
        MetadataLoader.Builder builder = new MetadataLoader.Builder().setNodeId(-1).setThreadNamePrefix("metadata-shell-").setFaultHandler(this.faultHandler).setHighWaterMarkAccessor(() -> source.highWaterMark()).setMetadataEncryptorFactory(this.encryptorFactory);
        if (configProps.get("multitenant.metadata.class") != null) {
            builder.setNameToTenantCallback(TenantHelpers.NAME_TO_TENANT_CALLBACK);
        } else {
            builder.setNameToTenantCallback(TenantHelpers.NAME_TO_NULL_CALLBACK);
        }
        this.loader = builder.build();
        this.publisher = new MetadataShellPublisher(this.state);
        this.loader.installPublishers(Collections.singletonList(this.publisher)).get(15L, TimeUnit.MINUTES);
    }

    void start() throws Exception {
        this.source.start((RaftClient.Listener)this.loader);
    }

    MetadataShellState state() {
        return this.state;
    }

    void waitUntilCaughtUp() throws InterruptedException {
        Optional<String> reasonDelayed;
        while ((reasonDelayed = this.getReasonDelayed()).isPresent()) {
            log.debug("Not caught up yet: {}", (Object)reasonDelayed.get());
            Thread.sleep(10L);
        }
    }

    Optional<String> getReasonDelayed() {
        OptionalLong highWaterMark = this.source.highWaterMark();
        if (!highWaterMark.isPresent()) {
            return Optional.of("the source high water mark is not known yet");
        }
        RootShellNode root = (RootShellNode)this.publisher.state().root();
        long imageOffset = root.image().provenance().lastContainedOffset();
        if (imageOffset + 1L < highWaterMark.getAsLong()) {
            return Optional.of("the image offset " + imageOffset + " is too small. The high water mark is " + highWaterMark.getAsLong());
        }
        return Optional.empty();
    }

    @Override
    public void close() throws Exception {
        Utils.closeQuietly((AutoCloseable)this.source, (String)"source");
        Utils.closeQuietly((AutoCloseable)this.loader, (String)"loader");
        FileLock prevFileLock = this.fileLock.getAndSet(null);
        if (prevFileLock != null) {
            try {
                prevFileLock.destroy();
            }
            catch (Exception e) {
                log.error("Error destroying fileLock", (Throwable)e);
            }
        }
    }
}

