/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.replication.push.buffer;

import io.confluent.kafka.replication.push.PushSession;
import java.util.concurrent.CompletableFuture;
import org.apache.kafka.common.TopicIdPartition;
import org.apache.kafka.common.record.AbstractRecords;
import org.apache.kafka.common.record.FileRecords;
import org.apache.kafka.common.record.MemoryRecords;

public final class PushReplicationEvent<T> {
    private final TopicIdPartition topicIdPartition;
    private final int replicaId;
    private final T payload;
    private final Type type;

    public static PushReplicationEvent<PushSession> forStartPush(TopicIdPartition topicIdPartition, int replicaId, PushSession pushSession) {
        return new PushReplicationEvent<PushSession>(topicIdPartition, replicaId, pushSession, Type.START_PUSH);
    }

    public static PushReplicationEvent<RecordsPayload> forRecords(TopicIdPartition topicIdPartition, int replicaId, AbstractRecords records, long appendOffset, long highWatermark) {
        Type type;
        if (records instanceof MemoryRecords) {
            type = Type.MEMORY_RECORDS;
        } else if (records instanceof FileRecords) {
            type = Type.FILE_RECORDS;
        } else {
            throw new IllegalStateException("Unexpected AbstractRecords type: " + records);
        }
        return new PushReplicationEvent<RecordsPayload>(topicIdPartition, replicaId, new RecordsPayload(records, appendOffset, highWatermark), type);
    }

    public static PushReplicationEvent<TransitionRecordsPayload> forTransitionRecords(PushReplicationEvent<RecordsPayload> fileRecordsEvent, CompletableFuture<Void> startFuture) {
        if (fileRecordsEvent.type != Type.FILE_RECORDS) {
            throw new IllegalArgumentException("A " + (Object)((Object)Type.FILE_RECORDS) + " event expectd");
        }
        if (startFuture == null || startFuture.isDone()) {
            throw new IllegalArgumentException("A non-null but still incomplete future expected");
        }
        return new PushReplicationEvent<TransitionRecordsPayload>(fileRecordsEvent.topicIdPartition, fileRecordsEvent.replicaId, new TransitionRecordsPayload((RecordsPayload)fileRecordsEvent.payload, startFuture), Type.TRANSITION_RECORDS);
    }

    public static PushReplicationEvent<OffsetPayload> forHighWatermarkUpdate(TopicIdPartition topicIdPartition, int replicaId, long updatedHighWatermark) {
        return new PushReplicationEvent<OffsetPayload>(topicIdPartition, replicaId, new OffsetPayload(updatedHighWatermark), Type.HWM_UPDATE);
    }

    public static PushReplicationEvent<OffsetPayload> forLogStartOffsetUpdate(TopicIdPartition topicIdPartition, int replicaId, long updatedLogStartOffset) {
        return new PushReplicationEvent<OffsetPayload>(topicIdPartition, replicaId, new OffsetPayload(updatedLogStartOffset), Type.LSO_UPDATE);
    }

    public static PushReplicationEvent<CompletableFuture<Void>> forStopPush(TopicIdPartition topicIdPartition, int replicaId) {
        return new PushReplicationEvent<CompletableFuture<Void>>(topicIdPartition, replicaId, new CompletableFuture(), Type.STOP_PUSH);
    }

    private PushReplicationEvent(TopicIdPartition topicIdPartition, int replicaId, T payload, Type type) {
        this.topicIdPartition = topicIdPartition;
        this.replicaId = replicaId;
        this.payload = payload;
        this.type = type;
    }

    public TopicIdPartition topicIdPartition() {
        return this.topicIdPartition;
    }

    public int replicaId() {
        return this.replicaId;
    }

    public T payload() {
        return this.payload;
    }

    public Type type() {
        return this.type;
    }

    public String toString() {
        return "PushReplicationEvent{topicIdPartition=" + this.topicIdPartition + ", replicaId=" + this.replicaId + ", payload=" + this.payload + ", type=" + (Object)((Object)this.type) + '}';
    }

    public static final class TransitionRecordsPayload
    extends RecordsPayload {
        private final CompletableFuture<Void> startFuture;

        public TransitionRecordsPayload(RecordsPayload payload, CompletableFuture<Void> startFuture) {
            super(payload.records, payload.appendOffset, payload.highWatermark);
            this.startFuture = startFuture;
        }

        public CompletableFuture<Void> startFuture() {
            return this.startFuture;
        }

        @Override
        public String toString() {
            return "TransitionRecordsPayload{appendOffset=" + this.appendOffset() + ", highWatermark=" + this.highWatermark() + '}';
        }
    }

    public static class RecordsPayload {
        private final AbstractRecords records;
        private final long appendOffset;
        private final long highWatermark;

        public RecordsPayload(AbstractRecords records, long appendOffset, long highWatermark) {
            this.records = records;
            this.appendOffset = appendOffset;
            this.highWatermark = highWatermark;
        }

        public AbstractRecords records() {
            return this.records;
        }

        public long appendOffset() {
            return this.appendOffset;
        }

        public long highWatermark() {
            return this.highWatermark;
        }

        public String toString() {
            return "RecordsPayload{appendOffset=" + this.appendOffset + ", highWatermark=" + this.highWatermark + '}';
        }
    }

    public static final class OffsetPayload {
        private final long offset;

        public OffsetPayload(long offset) {
            this.offset = offset;
        }

        public long offset() {
            return this.offset;
        }

        public String toString() {
            return "OffsetPayload{offset=" + this.offset + '}';
        }
    }

    public static enum Type {
        START_PUSH,
        TRANSITION_RECORDS,
        FILE_RECORDS,
        MEMORY_RECORDS,
        HWM_UPDATE,
        LSO_UPDATE,
        STOP_PUSH;

    }
}

