/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.rbacapi.app;

import io.confluent.common.security.auth.RestUserPrincipal;
import java.security.Principal;
import java.util.Arrays;
import java.util.List;
import javax.security.auth.Subject;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.security.ServerAuthException;
import org.eclipse.jetty.security.UserAuthentication;
import org.eclipse.jetty.security.authentication.BasicAuthenticator;
import org.eclipse.jetty.server.Authentication;
import org.eclipse.jetty.server.UserIdentity;

public class MdsBasicAuthenticator
extends BasicAuthenticator {
    public static final List<String> MDS_NO_AUTH_ENDPOINTS = Arrays.asList("/security/1.0/features", "/security/1.0/oidc/authenticate", "/security/1.0/oidc/authorization-code/callback", "/security/1.0/oidc/device/authenticate", "/security/1.0/oidc/device/check-auth");

    public Authentication validateRequest(ServletRequest req, ServletResponse res, boolean mandatory) throws ServerAuthException {
        HttpServletResponse response = (HttpServletResponse)res;
        HttpServletRequest request = (HttpServletRequest)req;
        MdsResponse mdsResponse = new MdsResponse(response);
        boolean requestIsForNoAuthEndpoint = MDS_NO_AUTH_ENDPOINTS.stream().anyMatch(noAuthEndpoint -> request.getRequestURI().equalsIgnoreCase((String)noAuthEndpoint));
        if (requestIsForNoAuthEndpoint) {
            UserIdentity userIdentity = this._identityService.newUserIdentity(new Subject(), (Principal)new RestUserPrincipal(""), new String[0]);
            return new UserAuthentication(this.getAuthMethod(), userIdentity);
        }
        return super.validateRequest(req, (ServletResponse)mdsResponse, mandatory);
    }

    public class MdsResponse
    extends HttpServletResponseWrapper {
        public MdsResponse(HttpServletResponse response) {
            super(response);
        }

        public void setHeader(String name, String value) {
            if (StringUtils.equals((CharSequence)HttpHeader.WWW_AUTHENTICATE.asString(), (CharSequence)name)) {
                super.setHeader(name, "none");
            } else {
                super.setHeader(name, value);
            }
        }
    }
}

