/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.rbacapi.entities;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Joiner;
import io.confluent.security.authorizer.ResourcePattern;
import io.confluent.security.authorizer.Scope;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.kafka.common.security.auth.KafkaPrincipal;

@NotThreadSafe
public class ManagedRoleBindings {
    @JsonProperty(value="scope")
    private final Scope scope;
    @JsonProperty(value="cluster_role_bindings")
    private final Map<KafkaPrincipal, List<ManagedClusterBinding>> clusterRoleBindings;
    @JsonProperty(value="resource_role_bindings")
    private final Map<KafkaPrincipal, List<ManagedResourceBinding>> resourceRoleBindings;

    public ManagedRoleBindings(Scope scope) {
        this(scope, new HashMap<KafkaPrincipal, List<ManagedClusterBinding>>(), new HashMap<KafkaPrincipal, List<ManagedResourceBinding>>());
    }

    @JsonCreator
    private ManagedRoleBindings(@JsonProperty(value="scope") Scope scope, @JsonProperty(value="cluster_role_bindings") Map<KafkaPrincipal, List<ManagedClusterBinding>> clusterRoleBindings, @JsonProperty(value="resource_role_bindings") Map<KafkaPrincipal, List<ManagedResourceBinding>> resourceRoleBindings) {
        this.scope = Objects.requireNonNull(scope, "scope");
        this.clusterRoleBindings = Objects.requireNonNull(clusterRoleBindings, "clusterRoleBindings");
        this.resourceRoleBindings = Objects.requireNonNull(resourceRoleBindings, "resourceRoleBindings");
    }

    public void add(KafkaPrincipal principal, ManagedClusterBinding managedClusterBinding) {
        this.clusterRoleBindings.computeIfAbsent(principal, k -> new ArrayList()).add(managedClusterBinding);
    }

    public void add(KafkaPrincipal principal, ManagedResourceBinding managedResourceBinding) {
        this.resourceRoleBindings.computeIfAbsent(principal, k -> new ArrayList()).add(managedResourceBinding);
    }

    public Map<KafkaPrincipal, List<ManagedClusterBinding>> getClusterRoleBindings() {
        return this.clusterRoleBindings;
    }

    public Map<KafkaPrincipal, List<ManagedResourceBinding>> getResourceRoleBindings() {
        return this.resourceRoleBindings;
    }

    public static class ManagedResourceBinding {
        @JsonProperty(value="role")
        private final String role;
        @JsonProperty(value="resourceType")
        private final String resourceType;
        @JsonProperty(value="resourceName")
        private final String resourceName;
        @JsonProperty(value="resourcePattern")
        private final String resourcePattern;
        @JsonProperty(value="alterAccess")
        private final boolean alterAccess;

        @JsonCreator
        private ManagedResourceBinding(@JsonProperty(value="role") String role, @JsonProperty(value="resourceType") String resourceType, @JsonProperty(value="resourceName") String resourceName, @JsonProperty(value="resourcePattern") String resourcePattern, @JsonProperty(value="alterAccess") boolean alterAccess) {
            this.role = Objects.requireNonNull(role, "role");
            this.resourceType = Objects.requireNonNull(resourceType, "resourceType");
            this.resourceName = Objects.requireNonNull(resourceName, "resourceName");
            this.resourcePattern = Objects.requireNonNull(resourcePattern, "resourcePattern");
            this.alterAccess = Objects.requireNonNull(Boolean.valueOf(alterAccess), "alterAccess");
        }

        public ManagedResourceBinding(String role, ResourcePattern resourcePattern, boolean alterAccess) {
            this(role, resourcePattern.resourceType().name(), resourcePattern.name(), resourcePattern.patternType().name(), alterAccess);
        }

        public String getRole() {
            return this.role;
        }

        public int hashCode() {
            return Objects.hash(this.role, this.resourceType, this.resourceName, this.resourcePattern, this.alterAccess);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof ManagedResourceBinding)) {
                return false;
            }
            ManagedResourceBinding that = (ManagedResourceBinding)o;
            return this.role.equals(that.role) && this.resourceType.equals(that.resourceType) && this.resourceName.equals(that.resourceName) && this.resourcePattern.equals(that.resourcePattern) && this.alterAccess == that.alterAccess;
        }

        public String toString() {
            return Joiner.on((String)",").join((Object)this.role, (Object)this.resourceType, new Object[]{this.resourceName, this.resourcePattern, this.alterAccess});
        }
    }

    public static class ManagedClusterBinding {
        @JsonProperty(value="role")
        private final String role;
        @JsonProperty(value="alterAccess")
        private final boolean alterAccess;

        @JsonCreator
        public ManagedClusterBinding(@JsonProperty(value="role") String role, @JsonProperty(value="alterAccess") boolean alterAccess) {
            this.role = Objects.requireNonNull(role, "role");
            this.alterAccess = Objects.requireNonNull(Boolean.valueOf(alterAccess), "alterAccess");
        }

        public int hashCode() {
            return Objects.hash(this.role, this.alterAccess);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof ManagedClusterBinding)) {
                return false;
            }
            ManagedClusterBinding that = (ManagedClusterBinding)o;
            return this.role.equals(that.role) && this.alterAccess == that.alterAccess;
        }

        public String toString() {
            return Joiner.on((String)",").join((Object)this.role, (Object)this.alterAccess, new Object[0]);
        }
    }
}

