/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.rbacapi.utils;

import io.confluent.rbacapi.authorizer.SecurityMetadataAuthorizer;
import io.confluent.security.auth.metadata.AuthCache;
import io.confluent.security.authorizer.Operation;
import io.confluent.security.authorizer.Scope;
import java.util.Collections;
import java.util.Set;
import java.util.stream.Collectors;
import javax.ws.rs.core.SecurityContext;
import org.apache.kafka.common.errors.AuthorizationException;
import org.apache.kafka.common.security.auth.KafkaPrincipal;

public class ScopeUtils {
    public static Set<Scope> knownContainedScopes(Scope specifiedScope, AuthCache authCache) {
        Set<Scope> containedScopes = authCache.knownScopes().stream().filter(arg_0 -> ((Scope)specifiedScope).containsScope(arg_0)).collect(Collectors.toSet());
        if (containedScopes.size() == 0) {
            return Collections.singleton(specifiedScope);
        }
        return containedScopes;
    }

    public static Set<Scope> securityMetadataAuthorizedScopesAllowDescribeSelf(Set<Scope> scopes, KafkaPrincipal targetPrincipal, SecurityContext context, Operation operation, SecurityMetadataAuthorizer metadataAuthorizer) {
        Set<Scope> results = scopes.stream().filter(scope -> {
            try {
                metadataAuthorizer.authorizeSecurityMetadataAccessAllowDescribeSelf(context, (Scope)scope, targetPrincipal, operation);
                return true;
            }
            catch (AuthorizationException e) {
                return false;
            }
        }).collect(Collectors.toSet());
        if (results.size() == 0) {
            KafkaPrincipal callingPrincipal = metadataAuthorizer.userPrincipal(context);
            throw new AuthorizationException("No authorized scopes found for " + callingPrincipal);
        }
        return results;
    }
}

