/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.rbacapi.validation.v1;

import com.google.common.collect.ImmutableSet;
import io.confluent.rbacapi.entities.MdsScope;
import io.confluent.security.authorizer.Scope;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.Set;
import javax.validation.Constraint;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import javax.validation.Payload;
import org.apache.commons.lang3.StringUtils;

@Target(value={ElementType.PARAMETER, ElementType.FIELD})
@Retention(value=RetentionPolicy.RUNTIME)
@Constraint(validatedBy={MdsScopeValidator.class})
public @interface V1ValidMdsScope {
    public Class<?>[] groups() default {};

    public Class<? extends Payload>[] payload() default {};

    public String message() default "Invalid Scope";

    public static class MdsScopeValidator
    implements ConstraintValidator<V1ValidMdsScope, MdsScope> {
        private static final String KAFKA_CLUSTER = "kafka-cluster";
        private static final Set<String> validClusterKeys = ImmutableSet.of((Object)"kafka-cluster", (Object)"connect-cluster", (Object)"ksql-cluster", (Object)"schema-registry-cluster");

        public void initialize(V1ValidMdsScope constraintAnnotation) {
        }

        public boolean isValid(MdsScope mdsScope, ConstraintValidatorContext context) {
            context.disableDefaultConstraintViolation();
            if (mdsScope == null) {
                context.buildConstraintViolationWithTemplate("Invalid Scope : Empty Scope. Check format.").addConstraintViolation();
                return false;
            }
            if (mdsScope.scope() != null) {
                Scope scope = mdsScope.scope();
                if (scope.path() != null && !scope.path().isEmpty()) {
                    context.buildConstraintViolationWithTemplate("Invalid Scope : path should be empty").addConstraintViolation();
                    return false;
                }
                if (StringUtils.isNotBlank((CharSequence)mdsScope.clusterName())) {
                    context.buildConstraintViolationWithTemplate("Invalid Scope : either 'clusters' map or 'clusterName' should be specified but not both. Check format.").addConstraintViolation();
                    return false;
                }
                if (StringUtils.isBlank((CharSequence)mdsScope.clusterName()) && scope.clusters().isEmpty() && scope.path().isEmpty()) {
                    context.buildConstraintViolationWithTemplate("Invalid Scope : Scope is empty. Check format.").addConstraintViolation();
                    return false;
                }
                if (scope.clusters() == null || scope.clusters().size() == 0 || scope.clusters().size() > 2) {
                    context.buildConstraintViolationWithTemplate("Invalid Scope : clusters should only contain one or two cluster id keys").addConstraintViolation();
                    return false;
                }
                if (!scope.clusters().keySet().contains(KAFKA_CLUSTER)) {
                    context.buildConstraintViolationWithTemplate("Invalid Scope : kafka-cluster should always be defined").addConstraintViolation();
                    return false;
                }
                if (scope.clusters().keySet().stream().anyMatch(key -> !validClusterKeys.contains(key))) {
                    context.buildConstraintViolationWithTemplate("Invalid Scope : invalid cluster key found").addConstraintViolation();
                    return false;
                }
                if (scope.clusters().values().stream().anyMatch(StringUtils::isBlank)) {
                    context.buildConstraintViolationWithTemplate("Invalid Scope : cluster value cannot be blank").addConstraintViolation();
                    return false;
                }
            }
            return true;
        }
    }
}

