/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.rbacapi.validation.v1;

import io.confluent.rbacapi.validator.StringValidator;
import io.confluent.security.authorizer.ResourcePattern;
import io.confluent.security.authorizer.ResourceType;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.regex.Pattern;
import javax.validation.Constraint;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import javax.validation.Payload;
import org.apache.kafka.common.resource.PatternType;

@Target(value={ElementType.PARAMETER, ElementType.FIELD})
@Retention(value=RetentionPolicy.RUNTIME)
@Constraint(validatedBy={ResourcePatternValidator.class})
public @interface V1ValidResourcePattern {
    public Class<?>[] groups() default {};

    public Class<? extends Payload>[] payload() default {};

    public String message() default "Not a valid Resource Pattern. Found: ${validatedValue}";

    public static class ResourcePatternValidator
    implements ConstraintValidator<V1ValidResourcePattern, ResourcePattern> {
        private static final ResourceType KSQL_CLUSTER = new ResourceType("KsqlCluster");
        private static final ResourceType CLUSTER = new ResourceType("Cluster");
        private static final ResourceType TOPIC = new ResourceType("Topic");
        private static final int MAX_LENGTH_RESOURCEPATTERN_NAME = 1000;
        private static final int MIN_LENGTH_RESOURCEPATTERN_NAME = 1;
        private static final int TOPIC_MAX_NAME_LENGTH = 249;
        private static final Pattern VALID_TOPIC_NAME_REGEX = Pattern.compile("^[a-zA-Z0-9._-]+$");

        public void initialize(V1ValidResourcePattern constraintAnnotation) {
        }

        public boolean isValid(ResourcePattern resourcePattern, ConstraintValidatorContext context) {
            context.disableDefaultConstraintViolation();
            if (!(!CLUSTER.equals((Object)resourcePattern.resourceType()) || PatternType.LITERAL.equals((Object)resourcePattern.patternType()) && "kafka-cluster".equals(resourcePattern.name()))) {
                context.buildConstraintViolationWithTemplate("Invalid resource pattern : " + resourcePattern).addConstraintViolation();
                return false;
            }
            if (!(!KSQL_CLUSTER.equals((Object)resourcePattern.resourceType()) || PatternType.LITERAL.equals((Object)resourcePattern.patternType()) && "ksql-cluster".equals(resourcePattern.name()))) {
                context.buildConstraintViolationWithTemplate("Invalid resource pattern : " + resourcePattern).addConstraintViolation();
                return false;
            }
            if (resourcePattern.name().equals("*")) {
                if (resourcePattern.patternType().equals((Object)PatternType.LITERAL)) {
                    return true;
                }
                context.buildConstraintViolationWithTemplate("Invalid resource pattern : to make a wildcard match, the pattern type should be Literal").addConstraintViolation();
            }
            if (TOPIC.equals((Object)resourcePattern.resourceType())) {
                if (!StringValidator.isValidLength(resourcePattern.name(), 249)) {
                    context.buildConstraintViolationWithTemplate(String.format("Invalid resource pattern: resource name should not be longer than %d bytes.", 249)).addConstraintViolation();
                    return false;
                }
                if (!StringValidator.isValidDataPattern(resourcePattern.name(), VALID_TOPIC_NAME_REGEX)) {
                    context.buildConstraintViolationWithTemplate("Invalid resource pattern: resource name should contain only ASCII alphanumerics, '.', '_' and '-'").addConstraintViolation();
                    return false;
                }
            } else {
                if (!StringValidator.isValidMinLength(resourcePattern.name())) {
                    context.buildConstraintViolationWithTemplate("Invalid resource pattern : The length of name cannot be less than 1 characters").addConstraintViolation();
                    return false;
                }
                if (!StringValidator.isValidLength(resourcePattern.name(), 1000)) {
                    context.buildConstraintViolationWithTemplate("Invalid resource pattern : The length of name cannot be over1000 characters").addConstraintViolation();
                    return false;
                }
            }
            return true;
        }
    }
}

