/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.tokenapi.jwt;

import io.confluent.kafka.clients.plugins.auth.jwt.PublicKeyJwks;
import io.confluent.tokenapi.jwt.JwsConfig;
import io.confluent.tokenapi.jwt.KeyPairHandler;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.Key;
import java.security.KeyPair;
import java.security.PublicKey;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.kafka.common.Configurable;
import org.apache.kafka.common.config.ConfigException;
import org.jose4j.jwk.PublicJsonWebKey;
import org.jose4j.jws.JsonWebSignature;
import org.jose4j.jwt.JwtClaims;
import org.jose4j.keys.resolvers.JwksVerificationKeyResolver;
import org.jose4j.keys.resolvers.VerificationKeyResolver;
import org.jose4j.lang.JoseException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JwsProvider
implements Configurable {
    private static final Logger log = LoggerFactory.getLogger(JwsProvider.class);
    private JsonWebSignature jws;
    private PublicKey publicKey;
    private KeyPairHandler keyHandler;
    VerificationKeyResolver jwksResolver;

    public void configure(Map<String, ?> props) {
        JwsConfig config = new JwsConfig(props);
        String tokenKeyPath = config.getString("token.key.path");
        String userStore = config.getString("user.store");
        String passphrase = config.getPassword("token.key.passphrase").value();
        if ("NONE".equals(userStore)) {
            this.loadPublicKey(Paths.get(tokenKeyPath, new String[0]));
        } else {
            String signatureAlgorithm = config.getString("token.signature.algorithm");
            if (Algorithm.NONE.name().equals(signatureAlgorithm)) {
                this.jws = this.newJwsSignatory(null, Algorithm.NONE);
                this.jwksResolver = new JwksVerificationKeyResolver(new ArrayList());
                return;
            }
            if (tokenKeyPath.isEmpty()) {
                throw new ConfigException(String.format("Missing required configuration %s which has no default value.", "token.key.path"));
            }
            Path keyPairPath = Paths.get(tokenKeyPath, new String[0]);
            this.keyHandler = new KeyPairHandler(keyPairPath, passphrase);
            this.loadKeys(Algorithm.valueOf(signatureAlgorithm));
        }
    }

    public PublicKey getPublicKey() {
        return this.publicKey;
    }

    private JsonWebSignature newJwsSignatory(KeyPair keyPair, Algorithm signatureAlgorithm) {
        JsonWebSignature jws = new JsonWebSignature();
        if (signatureAlgorithm.equals((Object)Algorithm.NONE)) {
            jws.setAlgorithmHeaderValue("none");
            return jws;
        }
        PublicJsonWebKey jwk = JwsProvider.buildPublicJsonWebKey(keyPair);
        jws.setAlgorithmHeaderValue(signatureAlgorithm.name());
        jws.setKey((Key)jwk.getPrivateKey());
        jws.setKeyIdHeaderValue(jwk.getKeyId());
        return jws;
    }

    synchronized String signClaims(JwtClaims claims) throws JoseException {
        this.jws.setPayload(claims.toJson());
        return this.jws.getCompactSerialization();
    }

    private void loadPublicKey(Path tokenKeyPath) {
        try {
            this.publicKey = (PublicKey)PublicKeyJwks.loadPublicKey((String)tokenKeyPath.toString()).stream().findFirst().orElseThrow(() -> new IllegalStateException(String.format("No token key file(s) could be loaded from config %s with path:%s", "token.key.path", tokenKeyPath)));
            log.info(String.format("Loaded %s as a public key", tokenKeyPath));
        }
        catch (Throwable t) {
            throw new IllegalStateException(String.format("No token key file(s) could be loaded from config %s with path:%s", "token.key.path", tokenKeyPath));
        }
    }

    private void loadKeys(Algorithm signatureAlgorithm) {
        List<KeyPair> keyPairs = this.keyHandler.getKeyPairs();
        KeyPair firstKeyPair = keyPairs.get(0);
        this.publicKey = firstKeyPair.getPublic();
        this.jws = this.newJwsSignatory(firstKeyPair, signatureAlgorithm);
        List jwkList = keyPairs.stream().map(JwsProvider::buildPublicJsonWebKey).collect(Collectors.toList());
        JwksVerificationKeyResolver keyResolver = new JwksVerificationKeyResolver(jwkList);
        keyResolver.setDisambiguateWithVerifySignature(true);
        this.jwksResolver = keyResolver;
    }

    private static PublicJsonWebKey buildPublicJsonWebKey(KeyPair keyPair) {
        try {
            PublicJsonWebKey jwk = PublicJsonWebKey.Factory.newPublicJwk((Key)keyPair.getPublic());
            jwk.setPrivateKey(keyPair.getPrivate());
            return jwk;
        }
        catch (JoseException je) {
            String errorMsg = "Unable to convert keyPair into a PublicJsonWebKey";
            log.error(errorMsg, (Throwable)je);
            throw new IllegalStateException("Unable to create PublicJsonWebKey key", je);
        }
    }

    public static enum Algorithm {
        RS256,
        NONE;

    }
}

