/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.tools.recovery;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.confluent.kafka.tools.recovery.CheckpointRecord;
import io.confluent.kafka.tools.recovery.CommandException;
import io.confluent.kafka.tools.recovery.FreezableAppender;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import kafka.log.MergedLog;
import kafka.utils.FileLock;
import net.sourceforge.argparse4j.impl.Arguments;
import net.sourceforge.argparse4j.inf.ArgumentType;
import net.sourceforge.argparse4j.inf.Namespace;
import net.sourceforge.argparse4j.inf.Subparser;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.internals.Topic;
import org.apache.kafka.common.memory.MemoryPool;
import org.apache.kafka.common.message.SnapshotFooterRecord;
import org.apache.kafka.common.message.SnapshotFooterRecordJsonConverter;
import org.apache.kafka.common.message.SnapshotHeaderRecord;
import org.apache.kafka.common.message.SnapshotHeaderRecordJsonConverter;
import org.apache.kafka.common.metadata.MetadataJsonConverters;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.ControlRecordType;
import org.apache.kafka.common.utils.BufferSupplier;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.metadata.MetadataRecordSerde;
import org.apache.kafka.raft.OffsetAndEpoch;
import org.apache.kafka.raft.internals.BatchMemoryPool;
import org.apache.kafka.server.common.ApiMessageAndVersion;
import org.apache.kafka.server.common.serialization.RecordSerde;
import org.apache.kafka.snapshot.FileRawSnapshotReader;
import org.apache.kafka.snapshot.FileRawSnapshotWriter;
import org.apache.kafka.snapshot.RawSnapshotReader;
import org.apache.kafka.snapshot.RawSnapshotWriter;
import org.apache.kafka.snapshot.RecordsSnapshotReader;
import org.apache.kafka.snapshot.RecordsSnapshotWriter;
import org.apache.kafka.snapshot.SnapshotPath;
import org.apache.kafka.snapshot.SnapshotWriter;
import org.apache.kafka.snapshot.Snapshots;

public final class MetadataRecoveryUtils {
    public static final String RECOVERY_DIRECTORY_OPTION = "--recovery-directory";
    public static final String KAFKA_METADATA_RECOVERY_DIR = ".kafka-metadata-recovery";
    public static final String LOG_DIR = MergedLog.logDirName((TopicPartition)new TopicPartition("__cluster_metadata", Topic.CLUSTER_METADATA_TOPIC_PARTITION.partition()));
    public static final String CONFIG_FILE = "config.properties";
    private static final String METADATA_LOG_DIR_OPTION = "--metadata-log-dir";
    private static final String END_OFFSET_OPTION = "--end-offset";
    private static final String EPOCH_OPTION = "--epoch";
    private static final String OUT_DIRECTORY_OPTION = "--out-directory";

    public static void addRecoveryDirectoryOption(Subparser subparser) {
        subparser.addArgument(new String[]{RECOVERY_DIRECTORY_OPTION}).dest(RECOVERY_DIRECTORY_OPTION).metavar(new String[]{"<recovery-path>"}).help("Specify a different base metadata recovery directory").type((ArgumentType)Arguments.fileType().verifyCanCreate());
    }

    public static Path recoveryLogDirectory(Namespace namespace) {
        String recoveryDirectory = Optional.ofNullable(namespace.getString(RECOVERY_DIRECTORY_OPTION)).orElseGet(() -> System.getProperty("user.dir"));
        return Paths.get(System.getProperty("user.dir"), new String[0]).resolve(recoveryDirectory).resolve(KAFKA_METADATA_RECOVERY_DIR).resolve(LOG_DIR).toAbsolutePath();
    }

    public static Properties loadRecoveryConfig(Namespace namespace) {
        Properties configProps = new Properties();
        Path configFile = MetadataRecoveryUtils.recoveryLogDirectory(namespace).resolve(CONFIG_FILE);
        try (FileInputStream fis = new FileInputStream(configFile.toString());){
            configProps.load(fis);
        }
        catch (IOException e) {
            throw new UncheckedIOException(String.format("Config file doesn't exist in the metadata recovery log dir at expected location: %s", configFile), e);
        }
        return configProps;
    }

    public static FreezableAppender<ApiMessageAndVersion> metadataAppender(Namespace namespace, long lastContainedLogTimestamp, String checkpointOption, String jsonOption) {
        if (namespace.getBoolean(checkpointOption).booleanValue()) {
            Long offset = namespace.getLong(END_OFFSET_OPTION);
            if (offset == null) {
                throw new CommandException(String.format("the option %s must be specified", END_OFFSET_OPTION), 1);
            }
            Integer epoch = namespace.getInt(EPOCH_OPTION);
            if (epoch == null) {
                throw new CommandException(String.format("the option %s must be specified", EPOCH_OPTION), 1);
            }
            Path outDirectory = Optional.ofNullable(namespace.getString(OUT_DIRECTORY_OPTION)).map(x$0 -> Paths.get(x$0, new String[0])).orElseGet(() -> Paths.get("", new String[0]).toAbsolutePath());
            return MetadataRecoveryUtils.checkpointAppender(offset, epoch, lastContainedLogTimestamp, outDirectory);
        }
        if (namespace.getBoolean(jsonOption).booleanValue()) {
            return MetadataRecoveryUtils.jsonAppender(System.out, lastContainedLogTimestamp);
        }
        throw new IllegalArgumentException("one 'to' option must be specified");
    }

    public static FreezableAppender<ApiMessageAndVersion> checkpointAppender(long offset, int epoch, long lastContainedLogTimestamp, Path outDirectory) {
        RecordsSnapshotWriter snapshotWriter = RecordsSnapshotWriter.createWithHeader((RawSnapshotWriter)FileRawSnapshotWriter.create((Path)outDirectory, (OffsetAndEpoch)new OffsetAndEpoch(offset, epoch), Optional.empty()), (int)0x800000, (MemoryPool)new BatchMemoryPool(5, 0x800000), (Time)Time.SYSTEM, (long)lastContainedLogTimestamp, (CompressionType)CompressionType.NONE, (RecordSerde)MetadataRecordSerde.INSTANCE);
        return new FreezableAppender<ApiMessageAndVersion>((SnapshotWriter)snapshotWriter){
            final /* synthetic */ SnapshotWriter val$snapshotWriter;
            {
                this.val$snapshotWriter = snapshotWriter;
            }

            @Override
            public void append(List<ApiMessageAndVersion> records) {
                this.val$snapshotWriter.append(records);
            }

            @Override
            public void freeze() {
                this.val$snapshotWriter.freeze();
            }

            @Override
            public void close() {
                Utils.closeQuietly((AutoCloseable)this.val$snapshotWriter, (String)"snapshot writer");
            }
        };
    }

    public static FreezableAppender<ApiMessageAndVersion> jsonAppender(OutputStream out, long lastContainedLogTimestamp) {
        JsonGenerator generator;
        final ObjectMapper mapper = new ObjectMapper();
        JsonFactory factory = mapper.getFactory();
        try {
            generator = factory.createGenerator(out);
            generator.writeStartArray();
            generator.writeRaw("\n  ");
            SnapshotHeaderRecord header = new SnapshotHeaderRecord().setVersion((short)0).setLastContainedLogTimestamp(lastContainedLogTimestamp);
            mapper.writeValue(generator, (Object)new CheckpointRecord(SnapshotHeaderRecordJsonConverter.write((SnapshotHeaderRecord)header, (short)header.version()), ControlRecordType.SNAPSHOT_HEADER.type(), header.version(), true));
        }
        catch (IOException e) {
            throw new UncheckedIOException("error in json generator", e);
        }
        return new FreezableAppender<ApiMessageAndVersion>(){

            @Override
            public void append(List<ApiMessageAndVersion> records) {
                try {
                    for (ApiMessageAndVersion record : records) {
                        generator.writeRaw("\n  ");
                        mapper.writeValue(generator, (Object)new CheckpointRecord(MetadataJsonConverters.writeJson((ApiMessage)record.message(), (short)record.version()), record.message().apiKey(), record.version(), false));
                    }
                }
                catch (IOException e) {
                    throw new UncheckedIOException("error writing json node", e);
                }
            }

            @Override
            public void freeze() {
                try {
                    SnapshotFooterRecord footer = new SnapshotFooterRecord().setVersion((short)0);
                    generator.writeRaw("\n  ");
                    mapper.writeValue(generator, (Object)new CheckpointRecord(SnapshotFooterRecordJsonConverter.write((SnapshotFooterRecord)footer, (short)footer.version()), ControlRecordType.SNAPSHOT_FOOTER.type(), footer.version(), true));
                    generator.writeRaw("\n  ");
                    generator.writeEndArray();
                    generator.writeRaw("\n");
                }
                catch (IOException e) {
                    throw new UncheckedIOException("error in json generator", e);
                }
            }

            @Override
            public void close() {
                Utils.closeQuietly((AutoCloseable)generator, (String)"json generator");
            }
        };
    }

    public static Optional<FileLock> maybeSetupFileLock(Namespace namespace) throws IllegalArgumentException {
        if (namespace.getString(METADATA_LOG_DIR_OPTION) != null) {
            Path logsDir = Paths.get(namespace.getString(METADATA_LOG_DIR_OPTION), new String[0]);
            Path lockFile = logsDir.resolve(".lock");
            if (!Files.exists(lockFile, new LinkOption[0])) {
                throw new IllegalStateException(String.format("Unable to find %s file in target log directory", lockFile));
            }
            FileLock lock = new FileLock(lockFile.toFile());
            if (!lock.tryLock()) {
                throw new IllegalStateException(String.format("Cluster may be active, unable to acquire %s file", lockFile));
            }
            return Optional.of(lock);
        }
        return Optional.empty();
    }

    public static FileRawSnapshotReader openFileRawSnapshotReader(Path path) {
        Path parentPath = path.getParent() != null ? path.getParent() : Paths.get(".", new String[0]).getParent();
        SnapshotPath snapshotPath = (SnapshotPath)Snapshots.parse((Path)path).orElseThrow(() -> new IllegalArgumentException(String.format("Provided incorrectly name snapshot file: %s", path)));
        return FileRawSnapshotReader.open((Path)parentPath, (OffsetAndEpoch)snapshotPath.snapshotId);
    }

    public static RecordsSnapshotReader<ApiMessageAndVersion> openSnapshotReader(FileRawSnapshotReader reader) {
        return RecordsSnapshotReader.of((RawSnapshotReader)reader, (RecordSerde)MetadataRecordSerde.INSTANCE, (BufferSupplier)BufferSupplier.create(), (int)0x800000, (boolean)true);
    }
}

