/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.tools.recovery;

import io.confluent.kafka.tools.recovery.MetadataRecoveryPartition;
import io.confluent.kafka.tools.recovery.MetadataRecoveryUtils;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Properties;
import net.sourceforge.argparse4j.impl.Arguments;
import net.sourceforge.argparse4j.inf.ArgumentType;
import net.sourceforge.argparse4j.inf.Namespace;
import net.sourceforge.argparse4j.inf.Subparser;
import net.sourceforge.argparse4j.inf.Subparsers;

final class NewCommand {
    static final String COMMAND = "new";
    private static final String ENCRYPTOR_CONFIG_OPTION = "--encryptor-config";

    NewCommand() {
    }

    static void addCommand(Subparsers subparsers) {
        Subparser newCmd = subparsers.addParser(COMMAND).help("create a new metadata recovery session");
        newCmd.addArgument(new String[]{ENCRYPTOR_CONFIG_OPTION}).dest(ENCRYPTOR_CONFIG_OPTION).metavar(new String[]{"<path-properties-file>"}).help("Specify a .properties file to extract encryption config info from").type((ArgumentType)Arguments.fileType());
        MetadataRecoveryUtils.addRecoveryDirectoryOption(newCmd);
    }

    static int execute(Namespace namespace) {
        return NewCommand.createNew(namespace);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static int createNew(Namespace namespace) {
        Path logDir = MetadataRecoveryUtils.recoveryLogDirectory(namespace);
        Path tempFile = null;
        try {
            Files.createDirectories(logDir, new FileAttribute[0]);
            Path configOut22 = logDir.resolve("config.properties");
            tempFile = Files.createTempFile(logDir, "temp", ".properties", new FileAttribute[0]);
            if (namespace.getString(ENCRYPTOR_CONFIG_OPTION) != null) {
                Properties newProperties = NewCommand.readEncryptorProperties(namespace);
                try (FileOutputStream fileOutputStream = new FileOutputStream(tempFile.toString());){
                    newProperties.store(fileOutputStream, "Selected properties from kafka.properties");
                }
            }
            Files.move(tempFile, configOut22, StandardCopyOption.ATOMIC_MOVE);
            MetadataRecoveryPartition.createNewMetadataPartitionFile(logDir);
            if (tempFile == null) return 0;
        }
        catch (IOException e) {
            try {
                throw new UncheckedIOException("Failed to create recovery directory, log directory, or config file", e);
            }
            catch (Throwable throwable) {
                if (tempFile == null) throw throwable;
                try {
                    Files.deleteIfExists(tempFile);
                    throw throwable;
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        try {
            Files.deleteIfExists(tempFile);
            return 0;
        }
        catch (IOException configOut22) {
            return 0;
        }
    }

    private static Properties readEncryptorProperties(Namespace namespace) {
        String config = namespace.getString(ENCRYPTOR_CONFIG_OPTION);
        Path propertyPath = Paths.get(config, new String[0]);
        if (!propertyPath.isAbsolute()) {
            propertyPath = Paths.get(System.getProperty("user.dir"), new String[0]).resolve(config);
        }
        Properties properties = new Properties();
        try (FileInputStream fileInputStream = new FileInputStream(propertyPath.toFile());){
            properties.load(fileInputStream);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        String activeEncryptor = properties.getProperty("confluent.metadata.active.encryptor");
        String encryptorClasses = properties.getProperty("confluent.metadata.encryptor.classes");
        String encryptorSecrets = properties.getProperty("confluent.metadata.encryptor.secrets");
        Properties newProperties = new Properties();
        newProperties.setProperty("confluent.metadata.encryptor.secrets", encryptorSecrets);
        newProperties.setProperty("confluent.metadata.encryptor.classes", encryptorClasses);
        newProperties.setProperty("confluent.metadata.active.encryptor", activeEncryptor);
        return newProperties;
    }
}

