/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.tools;

import io.confluent.kafka.clients.CloudAdmin;
import io.confluent.kafka.clients.DescribeNetworkOptions;
import io.confluent.kafka.clients.DescribeNetworkResult;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;
import net.sourceforge.argparse4j.impl.Arguments;
import net.sourceforge.argparse4j.inf.ArgumentAction;
import net.sourceforge.argparse4j.inf.Namespace;
import net.sourceforge.argparse4j.inf.Subparser;
import net.sourceforge.argparse4j.inf.Subparsers;
import org.apache.kafka.common.KafkaFuture;
import org.apache.kafka.common.message.DescribeNetworkResponseData;
import org.apache.kafka.common.utils.Exit;
import org.apache.kafka.tools.CloudAdminCommand;
import org.apache.kafka.tools.CloudAdminCommandBase;
import org.apache.kafka.tools.ToolsUtils;

public class MultiTenantInfoCommand
extends CloudAdminCommandBase {
    static final String COMMAND_NAME = "kafka-mt-info.sh";
    static final String COMMAND_DESCRIPTION = "CLI to get the tenant information from the kafka broker";
    static final List<CloudAdminCommand> COMMANDS = Arrays.asList(new DescribeNetworkInfo());

    public static void main(String[] args) throws Exception {
        MultiTenantInfoCommand.execute(COMMAND_NAME, COMMAND_DESCRIPTION, args, COMMANDS, System.out);
    }

    static class DescribeNetworkInfo
    implements CloudAdminCommand {
        private static final String TENANT_ID_ARG = "tenant_id";
        private static final String LISTENER_NAME_ARG = "listener_name";
        private static final String IP_ADDRESS_ARG = "ip_addresses";
        private static final String BROKER_ID_ARG = "broker_ids";
        private static final String CLIENT_API_KEYS_ARG = "client_api_keys";
        private static final String DEFAULT_LISTENER_NAME = "EXTERNAL";
        private static final String CMD_NAME = "describe-network";
        private static final String[] TENANT_IPADDR_HEADER = new String[]{"Tenant", "ClientIpAddress"};
        private static final String[] CLIENT_APIKEY_IPADDR_HEADER = new String[]{"ClientApiKey", "ClientIpAddress"};

        DescribeNetworkInfo() {
        }

        @Override
        public String name() {
            return CMD_NAME;
        }

        @Override
        public void addSubparser(Subparsers subparsers) {
            Subparser parser = subparsers.addParser(this.name()).help("get the network information for the given tenant or the ip addresses/client api keys. Empty argument list fetches the network information for all the client ip addresses from the broker");
            parser.addArgument(new String[]{this.makeArg(BROKER_ID_ARG)}).help("Target broker-ids to fetch the network information").action((ArgumentAction)Arguments.store()).type(String.class).required(true);
            parser.addArgument(new String[]{this.makeArg(TENANT_ID_ARG)}).help("network information to be fetched for the given tenant id").action((ArgumentAction)Arguments.store()).type(String.class).required(false);
            parser.addArgument(new String[]{this.makeArg(LISTENER_NAME_ARG)}).help("Name of the socket server listener (ex: Internal, External etc..)").action((ArgumentAction)Arguments.store()).type(String.class).required(false);
            parser.addArgument(new String[]{this.makeArg(IP_ADDRESS_ARG)}).help("network information to be fetched for the given client ip addresses").action((ArgumentAction)Arguments.store()).type(String.class).required(false);
            parser.addArgument(new String[]{this.makeArg(CLIENT_API_KEYS_ARG)}).help("network information to be fetched for the given client api keys").action((ArgumentAction)Arguments.store()).type(String.class).required(false);
        }

        @Override
        public void execute(CloudAdmin admin, Namespace ns, PrintStream out) throws Exception {
            if (admin == null) {
                CloudAdminCommandBase.printErrorAndExit("Failed to execute the command due to null adminClient value");
            }
            try {
                String tenant = this.getTenantIdFromArgs(ns);
                String listenerName = this.getListenerNameFromArgs(ns);
                List<String> clientIps = this.getMultiStrArgument(ns, IP_ADDRESS_ARG);
                List<String> clientApikeys = this.getMultiStrArgument(ns, CLIENT_API_KEYS_ARG);
                List<String> brokerIds = this.getMultiStrArgument(ns, BROKER_ID_ARG);
                DescribeNetworkResult results = admin.describeNetwork(tenant, listenerName, clientIps, clientApikeys, (Collection)brokerIds.stream().map(Integer::valueOf).collect(Collectors.toList()), new DescribeNetworkOptions());
                HashMap<String, Set<String>> tenantIpList = new HashMap<String, Set<String>>();
                HashMap<String, Set<String>> clientApiKeyIpList = new HashMap<String, Set<String>>();
                for (KafkaFuture result : results.value()) {
                    DescribeNetworkResponseData data = (DescribeNetworkResponseData)result.get();
                    data.tenantIpAddrList().forEach(entry -> tenantIpList.computeIfAbsent(entry.tenantId(), k -> new HashSet()).add(entry.ipAddress()));
                    data.clientApiKeyIpAddrList().forEach(entry -> clientApiKeyIpList.computeIfAbsent(entry.clientApiKey(), k -> new HashSet()).add(entry.ipAddress()));
                }
                out.println(String.format("Tenant IpAddress List: %d", tenantIpList.size()));
                this.printIpAddressMap(tenantIpList, TENANT_IPADDR_HEADER, out);
                out.println(String.format("\nAuthentication Failed IpAddress List: %d", clientApiKeyIpList.size()));
                this.printIpAddressMap(clientApiKeyIpList, CLIENT_APIKEY_IPADDR_HEADER, out);
            }
            catch (ExecutionException e) {
                CloudAdminCommandBase.printErrorAndExit("Failed to fetch the network information", e.getCause());
            }
            Exit.exit((int)0);
        }

        private String makeArg(String arg) {
            return String.format("--%s", arg.replace('_', '-'));
        }

        private List<String> getMultiStrArgument(Namespace ns, String argName) {
            Optional<String> arg = Optional.ofNullable(ns.getString(argName));
            if (arg.isPresent()) {
                String args = arg.get();
                return Arrays.stream(args.split(",")).collect(Collectors.toList());
            }
            return Collections.emptyList();
        }

        private String getListenerNameFromArgs(Namespace ns) throws Exception {
            String listenerName = ns.getString(LISTENER_NAME_ARG);
            return listenerName == null ? DEFAULT_LISTENER_NAME : listenerName;
        }

        private String getTenantIdFromArgs(Namespace ns) throws Exception {
            String tenantId = ns.getString(TENANT_ID_ARG);
            return tenantId == null ? "" : tenantId;
        }

        private void printIpAddressMap(Map<String, Set<String>> ipAddrList, String[] header, PrintStream out) {
            if (!ipAddrList.isEmpty()) {
                ArrayList<String[]> rows = new ArrayList<String[]>();
                ipAddrList.forEach((tenant, ipList) -> ipList.forEach(ip -> rows.add(new String[]{tenant, ip})));
                ToolsUtils.prettyPrintTable(header, rows, out);
            }
        }
    }
}

