/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.tools.cellsadmincmd;

import io.confluent.kafka.clients.CellLoadResult;
import io.confluent.kafka.clients.CloudAdmin;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import net.sourceforge.argparse4j.impl.Arguments;
import net.sourceforge.argparse4j.inf.ArgumentAction;
import net.sourceforge.argparse4j.inf.Namespace;
import net.sourceforge.argparse4j.inf.Subparser;
import net.sourceforge.argparse4j.inf.Subparsers;
import org.apache.kafka.common.message.DescribeCellLoadResponseData;
import org.apache.kafka.tools.CloudAdminCommand;
import org.apache.kafka.tools.ToolsUtils;
import org.apache.kafka.tools.cellsadmincmd.CellsAdminCommand;

public class DescribeCellLoadCommand
implements CloudAdminCommand {
    public static final String[] OUTPUT_HEADERS = new String[]{"CellId", "Load"};

    @Override
    public String name() {
        return "describe-cell-load";
    }

    @Override
    public void addSubparser(Subparsers subparsers) {
        Subparser parser = subparsers.addParser(this.name()).help("Describes the load information of the cells in the cluster");
        parser.addArgument(new String[]{"--cell-ids"}).help("cell ids to describe separated by commas, an empty list describes all the cells in the cluster").action((ArgumentAction)Arguments.store()).type(String.class).required(false);
    }

    @Override
    public void execute(CloudAdmin admin, Namespace ns, PrintStream out) throws Exception {
        List cellLoads;
        try {
            List<Integer> cellIds = CellsAdminCommand.getCellIdsFromArgs(ns);
            CellLoadResult result = admin.describeCellLoad(cellIds);
            cellLoads = (List)result.value().get();
        }
        catch (ExecutionException e) {
            CellsAdminCommand.printErrorAndExit("Failed to describe cell load", e.getCause());
            return;
        }
        ArrayList<String[]> rows = new ArrayList<String[]>();
        for (DescribeCellLoadResponseData.CellLoad load : cellLoads) {
            rows.add(new String[]{Integer.toString(load.cellId()), Double.toString(load.load())});
        }
        ToolsUtils.prettyPrintTable(OUTPUT_HEADERS, rows, out);
    }
}

