/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.tools.test.model;

import com.google.common.collect.ImmutableList;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.confluent.kafka.schemaregistry.ParsedSchema;
import io.confluent.ksql.serde.SerdeFeature;
import io.confluent.ksql.serde.SerdeFeatures;
import io.confluent.ksql.tools.test.model.SchemaReference;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class Topic {
    public static final int DEFAULT_PARTITIONS = 4;
    public static final short DEFAULT_RF = 1;
    private final String name;
    private final int numPartitions;
    private final short replicas;
    final Optional<Integer> keySchemaId;
    final Optional<Integer> valueSchemaId;
    private final Optional<ParsedSchema> keySchema;
    private final Optional<ParsedSchema> valueSchema;
    private final List<SchemaReference> keySchemaReferences;
    private final List<SchemaReference> valueSchemaReferences;
    private final SerdeFeatures keyFeatures;
    private final SerdeFeatures valueFeatures;

    public Topic(String name, Optional<ParsedSchema> keySchema, Optional<ParsedSchema> valueSchema) {
        this(name, 4, 1, Optional.empty(), Optional.empty(), keySchema, valueSchema, (List<SchemaReference>)ImmutableList.of(), (List<SchemaReference>)ImmutableList.of(), SerdeFeatures.of((SerdeFeature[])new SerdeFeature[0]), SerdeFeatures.of((SerdeFeature[])new SerdeFeature[0]));
    }

    public Topic(String name, int numPartitions, int replicas, Optional<Integer> keySchemaId, Optional<Integer> valueSchemaId, Optional<ParsedSchema> keySchema, Optional<ParsedSchema> valueSchema, List<SchemaReference> keySchemaReferences, List<SchemaReference> valueSchemaReferences, SerdeFeatures keyFeatures, SerdeFeatures valueFeatures) {
        this.name = Objects.requireNonNull(name, "name");
        this.keySchemaId = Objects.requireNonNull(keySchemaId, "keySchemaId");
        this.valueSchemaId = Objects.requireNonNull(valueSchemaId, "valueSchemaId");
        this.keySchema = Objects.requireNonNull(keySchema, "keySchema");
        this.valueSchema = Objects.requireNonNull(valueSchema, "valueSchema");
        this.keySchemaReferences = Objects.requireNonNull(keySchemaReferences, "keySchemaReferences");
        this.valueSchemaReferences = Objects.requireNonNull(valueSchemaReferences, "valueSchemaReferences");
        this.numPartitions = numPartitions;
        this.replicas = (short)replicas;
        this.keyFeatures = keyFeatures;
        this.valueFeatures = valueFeatures;
    }

    public String getName() {
        return this.name;
    }

    public Optional<Integer> getKeySchemaId() {
        return this.keySchemaId;
    }

    public Optional<Integer> getValueSchemaId() {
        return this.valueSchemaId;
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_REP"}, justification="keySchemaReferences is ImmutableList")
    public List<SchemaReference> getKeySchemaReferences() {
        return this.keySchemaReferences;
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_REP"}, justification="valueSchemaReferences is ImmutableList")
    public List<SchemaReference> getValueSchemaReferences() {
        return this.valueSchemaReferences;
    }

    public Optional<ParsedSchema> getKeySchema() {
        return this.keySchema;
    }

    public Optional<ParsedSchema> getValueSchema() {
        return this.valueSchema;
    }

    public int getNumPartitions() {
        return this.numPartitions;
    }

    public short getReplicas() {
        return this.replicas;
    }

    public SerdeFeatures getKeyFeatures() {
        return this.keyFeatures;
    }

    public SerdeFeatures getValueFeatures() {
        return this.valueFeatures;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Topic topic = (Topic)o;
        return this.numPartitions == topic.numPartitions && this.replicas == topic.replicas && Objects.equals(this.name, topic.name) && Objects.equals(this.keySchemaId, topic.keySchemaId) && Objects.equals(this.valueSchemaId, topic.valueSchemaId) && Objects.equals(this.keySchema, topic.keySchema) && Objects.equals(this.valueSchema, topic.valueSchema);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.numPartitions, this.replicas, this.keySchemaId, this.valueSchemaId, this.keySchema, this.valueSchema);
    }
}

