/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.tools.test.parser;

import io.confluent.ksql.metastore.TypeRegistry;
import io.confluent.ksql.parser.AstBuilder;
import io.confluent.ksql.parser.CaseInsensitiveStream;
import io.confluent.ksql.parser.DefaultKsqlParser;
import io.confluent.ksql.parser.KsqlParser;
import io.confluent.ksql.parser.ParsingException;
import io.confluent.ksql.parser.SqlBaseLexer;
import io.confluent.ksql.parser.SqlBaseParser;
import io.confluent.ksql.parser.exception.ParseFailedException;
import io.confluent.ksql.tools.test.parser.DirectiveParser;
import io.confluent.ksql.tools.test.parser.TestStatement;
import io.confluent.ksql.util.ParserUtil;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Deque;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import org.antlr.v4.runtime.ANTLRErrorListener;
import org.antlr.v4.runtime.BaseErrorListener;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CharStreams;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.RecognitionException;
import org.antlr.v4.runtime.Recognizer;
import org.antlr.v4.runtime.Token;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;

public final class SqlTestReader
implements Iterator<TestStatement> {
    private static final BaseErrorListener ERROR_LISTENER = new BaseErrorListener(){

        public void syntaxError(Recognizer<?, ?> recognizer, Object offendingSymbol, int line, int charPositionInLine, String message, RecognitionException e) {
            throw new ParsingException(message, line, charPositionInLine);
        }
    };
    private final SqlBaseParser parser;
    private final CommonTokenStream tks;
    private final Deque<KsqlParser.ParsedStatement> cachedRunScript = new LinkedList<KsqlParser.ParsedStatement>();
    private int directiveIdx = 0;
    private boolean cachedStatement = false;
    private SqlBaseParser.TestStatementContext testStatement;

    public static SqlTestReader of(String test) {
        return new SqlTestReader((CharStream)CharStreams.fromString((String)test));
    }

    public static SqlTestReader of(Path file) throws IOException {
        CharStream chars = CharStreams.fromPath((Path)file);
        return new SqlTestReader(chars);
    }

    private SqlTestReader(CharStream chars) {
        Objects.requireNonNull(chars, "chars");
        SqlBaseLexer lexer = new SqlBaseLexer((CharStream)new CaseInsensitiveStream(chars));
        lexer.removeErrorListeners();
        lexer.addErrorListener((ANTLRErrorListener)ERROR_LISTENER);
        this.tks = new CommonTokenStream((TokenSource)lexer);
        this.parser = new SqlBaseParser((TokenStream)this.tks);
        this.parser.removeErrorListeners();
        this.parser.addErrorListener((ANTLRErrorListener)ERROR_LISTENER);
    }

    @Override
    public boolean hasNext() {
        return this.cachedStatement || !this.cachedRunScript.isEmpty() || !this.parser.isMatchedEOF() || this.hasMoreDirectives();
    }

    private boolean hasMoreDirectives() {
        int i = 0;
        while (this.directiveIdx + i < this.tks.size()) {
            if (this.tks.get(this.directiveIdx + i).getChannel() == 4) {
                return true;
            }
            ++i;
        }
        return false;
    }

    @Override
    public TestStatement next() {
        int currIdx;
        if (!this.cachedRunScript.isEmpty()) {
            return TestStatement.of(this.cachedRunScript.removeFirst());
        }
        if (!this.cachedStatement && !this.parser.isMatchedEOF()) {
            this.testStatement = this.parser.testStatement();
            this.cachedStatement = true;
        }
        int n = currIdx = this.cachedStatement ? this.testStatement.getStart().getTokenIndex() : this.tks.size();
        while (this.directiveIdx < currIdx) {
            Token tok;
            if ((tok = this.tks.get(this.directiveIdx++)).getChannel() != 4) continue;
            return TestStatement.of(DirectiveParser.parse(tok));
        }
        this.cachedStatement = false;
        if (this.testStatement.singleStatement() != null) {
            return TestStatement.of(DefaultKsqlParser.parsedStatement((SqlBaseParser.SingleStatementContext)this.testStatement.singleStatement()));
        }
        if (this.testStatement.runScript() != null) {
            return this.handleRunScript();
        }
        if (this.testStatement.assertStatement() != null) {
            return TestStatement.of(new AstBuilder(TypeRegistry.EMPTY).buildAssertStatement((ParserRuleContext)this.testStatement.assertStatement()));
        }
        throw new IllegalStateException("Unexpected parse tree for statement " + this.testStatement);
    }

    private TestStatement handleRunScript() {
        List<String> lines;
        String script = ParserUtil.unquote((String)this.testStatement.runScript().STRING().getText(), (String)"'");
        try {
            lines = this.getClass().getResource(script) != null ? Files.readAllLines(Paths.get(this.getClass().getResource(script).getPath(), new String[0])) : Files.readAllLines(Paths.get(script, new String[0]));
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Could not read " + script, e);
        }
        try {
            this.cachedRunScript.addAll(new DefaultKsqlParser().parse(String.join((CharSequence)"\n", lines)));
        }
        catch (ParseFailedException e) {
            throw new ParseFailedException("Failed to parse contents of RUN SCRIPT", "RUN SCRIPT '" + script + "';", (Throwable)e);
        }
        if (this.cachedRunScript.isEmpty()) {
            throw new IllegalArgumentException("Empty run script: " + script);
        }
        return TestStatement.of(this.cachedRunScript.removeFirst());
    }
}

