/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.tools.test.stubs;

import com.google.common.collect.Sets;
import io.confluent.ksql.exception.KafkaTopicExistsException;
import io.confluent.ksql.services.KafkaTopicClient;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.kafka.clients.admin.CreateTopicsOptions;
import org.apache.kafka.clients.admin.OffsetSpec;
import org.apache.kafka.clients.admin.TopicDescription;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.TopicPartitionInfo;
import org.apache.kafka.common.acl.AclOperation;
import org.apache.kafka.common.errors.UnknownTopicOrPartitionException;

public class StubKafkaTopicClient
implements KafkaTopicClient {
    private final Map<String, StubTopic> topicMap = new HashMap<String, StubTopic>();

    public boolean createTopic(String topic, int numPartitions, short replicationFactor, Map<String, ?> configs, CreateTopicsOptions createOptions) {
        short replicas = replicationFactor == -1 ? (short)1 : replicationFactor;
        StubTopic existing = this.topicMap.get(topic);
        if (existing != null) {
            StubKafkaTopicClient.validateTopicProperties(numPartitions, replicas, existing);
            return false;
        }
        StubTopic info = StubKafkaTopicClient.createStubTopic(topic, numPartitions, replicas, configs);
        this.topicMap.put(topic, info);
        return true;
    }

    public boolean isTopicExists(String topic) {
        return this.topicMap.containsKey(topic);
    }

    public Set<String> listTopicNames() {
        return this.topicMap.keySet();
    }

    public Map<String, TopicDescription> describeTopics(Collection<String> topicNames, Boolean skipRetriesOnFailure) {
        return topicNames.stream().collect(Collectors.toMap(Function.identity(), this::describeTopic));
    }

    public TopicDescription describeTopic(String topicName) {
        StubTopic stubTopic = this.topicMap.get(topicName);
        if (stubTopic == null) {
            throw new UnknownTopicOrPartitionException("unknown topic: " + topicName);
        }
        return stubTopic.getDescription();
    }

    public Map<String, String> getTopicConfig(String topicName) {
        return Collections.emptyMap();
    }

    public boolean addTopicConfig(String topicName, Map<String, ?> overrides) {
        return false;
    }

    public KafkaTopicClient.TopicCleanupPolicy getTopicCleanupPolicy(String topicName) {
        return this.topicMap.get(topicName).cleanupPolicy;
    }

    public void deleteTopics(Collection<String> topicsToDelete) {
        for (String topicName : topicsToDelete) {
            this.topicMap.remove(topicName);
        }
    }

    public void deleteInternalTopics(String applicationId) {
    }

    public Map<TopicPartition, Long> listTopicsOffsets(Collection<String> topicNames, OffsetSpec offsetSpec) {
        return Collections.emptyMap();
    }

    private static StubTopic createStubTopic(String topic, int numPartitions, int replicationFactor, Map<String, ?> configs) {
        KafkaTopicClient.TopicCleanupPolicy cleanUpPolicy = "compact".equals(configs.get("cleanup.policy")) ? KafkaTopicClient.TopicCleanupPolicy.COMPACT : KafkaTopicClient.TopicCleanupPolicy.DELETE;
        return new StubTopic(topic, numPartitions, replicationFactor, cleanUpPolicy);
    }

    private static void validateTopicProperties(int requiredNumPartition, int requiredNumReplicas, StubTopic existing) {
        if (existing.numPartitions != requiredNumPartition || requiredNumReplicas != -1 && existing.replicationFactor < requiredNumReplicas) {
            throw new KafkaTopicExistsException(String.format("A Kafka topic with the name '%s' already exists, with different partition/replica configuration than required. KSQL expects %d partitions (topic has %d), and %d replication factor (topic has %d).", existing.topicName, requiredNumPartition, existing.numPartitions, requiredNumReplicas, existing.replicationFactor), true);
        }
    }

    public static class StubTopic {
        private final String topicName;
        private final int numPartitions;
        private final int replicationFactor;
        private final KafkaTopicClient.TopicCleanupPolicy cleanupPolicy;

        public StubTopic(String topicName, int numPartitions, int replicationFactor, KafkaTopicClient.TopicCleanupPolicy cleanupPolicy) {
            this.topicName = topicName;
            this.numPartitions = numPartitions;
            this.replicationFactor = replicationFactor;
            this.cleanupPolicy = cleanupPolicy;
        }

        private TopicDescription getDescription() {
            Node node = new Node(0, "localhost", 9091);
            List replicas = IntStream.range(0, this.replicationFactor).mapToObj(idx -> null).collect(Collectors.toList());
            List partitionInfoList = IntStream.range(0, this.numPartitions).mapToObj(p -> new TopicPartitionInfo(p, node, replicas, Collections.emptyList())).collect(Collectors.toList());
            return new TopicDescription(this.topicName, false, partitionInfoList, (Set)Sets.newHashSet((Object[])new AclOperation[]{AclOperation.READ, AclOperation.WRITE}));
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            StubTopic stubTopic = (StubTopic)o;
            return this.numPartitions == stubTopic.numPartitions && this.replicationFactor == stubTopic.replicationFactor && Objects.equals(this.topicName, stubTopic.topicName) && this.cleanupPolicy == stubTopic.cleanupPolicy;
        }

        public int hashCode() {
            return Objects.hash(this.topicName, this.numPartitions, this.replicationFactor, this.cleanupPolicy);
        }
    }
}

