/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.auditlog.emitter.audittest;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonParser;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.MessageOrBuilder;
import com.google.protobuf.util.JsonFormat;
import io.confluent.auditlog.emitter.errormappers.GoldenFileTestingException;
import io.confluent.protobuf.events.auditlog.v2.AuditLog;
import io.confluent.telemetry.api.events.Event;
import io.confluent.telemetry.events.EventUtils;
import java.io.IOException;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.time.OffsetDateTime;
import java.util.NoSuchElementException;
import org.json.JSONException;
import org.skyscreamer.jsonassert.JSONCompare;
import org.skyscreamer.jsonassert.JSONCompareMode;
import org.skyscreamer.jsonassert.JSONCompareResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Golden {
    private static final Logger log = LoggerFactory.getLogger(Golden.class);
    private static final String updateAuditLogGoldenFilesFlag = "AUDITLOG_UPDATE_GOLDEN";
    private static final boolean update = Boolean.parseBoolean(System.getenv("AUDITLOG_UPDATE_GOLDEN"));

    private static Event standardizedJsonEvent(Event event) throws InvalidProtocolBufferException, NoSuchElementException {
        AuditLog auditLog = AuditLog.parseFrom((byte[])((byte[])event.data().get()));
        return new Event().setId("aaaaaaaa-bbbb-cccc-dddd-eeeeeeeeeeee").setType(event.type()).setData("application/json", URI.create("https://confluent.io/internal/events/AuditLog.v2"), JsonFormat.printer().print((MessageOrBuilder)auditLog).getBytes(StandardCharsets.UTF_8)).setSubject(event.subject()).setSource(event.source().toString()).setTime(OffsetDateTime.MAX);
    }

    private static String prettyPrintJson(String data) {
        Gson gson = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
        return gson.toJson(JsonParser.parseString((String)data));
    }

    private static Path getGoldenFileLocation(String filename) throws IOException {
        Path currentPath = Paths.get(System.getProperty("user.dir"), new String[0]);
        String testDataFolder = "/src/test/resources/testdata";
        Path path = Paths.get(currentPath.toString(), testDataFolder);
        if (!Files.exists(path, new LinkOption[0])) {
            Files.createDirectories(path, new FileAttribute[0]);
        }
        return Paths.get(path.toString(), filename);
    }

    private static byte[] loadGoldenFile(String filename) throws IOException {
        Path golden = Golden.getGoldenFileLocation(filename);
        return Files.readAllBytes(golden);
    }

    private static void updateGoldenFile(String filename, Event rawEvent) throws IOException, NoSuchElementException {
        log.info("Because the update audit log golden file environment variable was set, we'll write the actual json into the expected golden file");
        Event event = Golden.standardizedJsonEvent(rawEvent);
        String actual = EventUtils.toJson((Event)event);
        String prettyPrintedJson = Golden.prettyPrintJson(actual);
        Path golden = Golden.getGoldenFileLocation(filename);
        Files.write(golden, prettyPrintedJson.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
        Files.write(golden, "\n".getBytes(StandardCharsets.UTF_8), StandardOpenOption.APPEND);
    }

    private static void diffEventWithExpectedOutput(String expected, Event rawEvent) throws JSONException, InvalidProtocolBufferException, NoSuchElementException {
        Event event = Golden.standardizedJsonEvent(rawEvent);
        String actual = EventUtils.toJson((Event)event);
        JSONCompareResult result = JSONCompare.compareJSON((String)expected, (String)actual, (JSONCompareMode)JSONCompareMode.STRICT);
        if (result.failed()) {
            log.error(String.format("Test failed, golden file does not match output. \n=== EXPECTED\n%s \n=== ACTUAL \n%s", Golden.prettyPrintJson(expected), Golden.prettyPrintJson(actual)));
            throw new GoldenFileTestingException("Test failed, Golden file does not match output.");
        }
    }

    public static void diffEventWithGoldenFile(String filename, Event rawEvent) {
        try {
            if (update) {
                Golden.updateGoldenFile(filename, rawEvent);
            }
            byte[] expected = Golden.loadGoldenFile(filename);
            Golden.diffEventWithExpectedOutput(new String(expected, StandardCharsets.UTF_8), rawEvent);
        }
        catch (Exception e) {
            throw new GoldenFileTestingException(e.getMessage(), e);
        }
    }
}

