/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.auditlog.emitter.transport;

import io.confluent.auditlog.emitter.errormappers.BadTransportException;
import io.confluent.auditlog.emitter.telemetry.NoOpTelemetry;
import io.confluent.auditlog.emitter.telemetry.Telemetry;
import io.confluent.auditlog.emitter.transport.Transport;
import io.confluent.telemetry.api.events.Event;
import java.util.concurrent.atomic.AtomicInteger;

public class BadTransport
implements Transport {
    private final AtomicInteger failedLogCounter = new AtomicInteger(0);
    private Telemetry telemetry = new NoOpTelemetry();
    private String serviceName;

    @Override
    public void log(Event event) {
        this.failedLogCounter.incrementAndGet();
        throw new BadTransportException("cannot log");
    }

    @Override
    public void close() {
        this.failedLogCounter.set(0);
        throw new BadTransportException("cannot close");
    }

    @Override
    public void init(Telemetry telemetry, String serviceName) {
        this.telemetry = telemetry;
        this.serviceName = serviceName;
    }

    public int getFailedLogCounter() {
        return this.failedLogCounter.get();
    }
}

