/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.auditlog.emitter.transport;

import java.util.Map;

public class KafkaTransportOptions {
    public static final int DEFAULT_TOPIC_REPLICATION_FACTOR = 3;
    public static final int DEFAULT_TOPIC_NUM_PARTITIONS = 12;
    public static final String DEFAULT_TOPIC_NAME_AUDIT_LOG_V2 = "confluent-audit-log-events-v2";
    private Map<String, Object> config;
    private String topicName;
    private int topicReplicationFactor;
    private int topicNumPartitions;
    private int transportBufferSize;

    public KafkaTransportOptions(Map<String, Object> config) {
        this(config, DEFAULT_TOPIC_NAME_AUDIT_LOG_V2, 3, 12);
    }

    public KafkaTransportOptions(Map<String, Object> config, String topicName, int topicReplicationFactor, int topicNumPartitions) {
        this(config, topicName, topicReplicationFactor, topicNumPartitions, 0);
    }

    public KafkaTransportOptions(Map<String, Object> config, String topicName, int topicReplicationFactor, int topicNumPartitions, int transportBufferSize) {
        this.config = config;
        this.topicName = topicName;
        this.topicReplicationFactor = topicReplicationFactor;
        this.topicNumPartitions = topicNumPartitions;
        this.transportBufferSize = transportBufferSize;
    }

    public Map<String, Object> getConfig() {
        return this.config;
    }

    public String getTopicName() {
        return this.topicName;
    }

    public int getTopicReplicationFactor() {
        return this.topicReplicationFactor;
    }

    public int getTopicNumPartitions() {
        return this.topicNumPartitions;
    }

    public int getTransportBufferSize() {
        return this.transportBufferSize;
    }
}

