/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.auditlog.emitter.utils;

import io.cloudevents.CloudEvent;
import io.cloudevents.CloudEventData;
import io.cloudevents.core.builder.CloudEventBuilder;
import io.cloudevents.core.data.BytesCloudEventData;
import io.cloudevents.core.format.EventFormat;
import io.cloudevents.core.provider.EventFormatProvider;
import io.confluent.protobuf.events.auditlog.v2.AuditLog;
import io.confluent.protobuf.events.auditlog.v2.AuthenticationInfo;
import io.confluent.protobuf.events.auditlog.v2.CloudScope;
import io.confluent.protobuf.events.auditlog.v2.FullyQualifiedCloudResourceRef;
import io.confluent.protobuf.events.auditlog.v2.Principal;
import io.confluent.protobuf.events.auditlog.v2.RequestMetadata;
import io.confluent.protobuf.events.auditlog.v2.ResourceRef;
import io.confluent.protobuf.events.auditlog.v2.TypedCloudResourceRef;
import io.confluent.telemetry.api.events.Event;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuditLoggerUtils {
    private static final Logger log = LoggerFactory.getLogger(AuditLoggerUtils.class);
    public static final String KAFKA_DYNAMIC_MODULE = "io.confluent.kafka.security.auth.plain.DynamicPlainLoginModule";
    public static final String KAFKA_LOGIN_CALLBACK_HANDLER = "io.confluent.kafka.security.auth.plain.FileBasedDynamicPlainLoginCallbackHandler";
    public static final String KAFKA_CLIENT_CALLBACK_HANDLER = "io.confluent.kafka.security.auth.plain.DynamicPlainClientCallbackHandler";
    public static final String KAFKA_SASL_FILE_CONFIG = "%s required credentials_path=\"%s\"  watch_path=\"%s\" username_config=\"%s\" password_config=\"%s\";";
    public static final String SPIRE_LOGIN_CALLBACK_HANDLER = "io.confluent.kafka.clients.plugins.auth.oauth.SpireJwtLoginCallbackHandler";
    private static EventFormat jsonFormat = EventFormatProvider.getInstance().resolveFormat("application/cloudevents+json");

    private static Map<String, Object> helperConfig(String bootstrapServers) {
        HashMap<String, Object> config = new HashMap<String, Object>();
        config.put("producer.bootstrap.servers", bootstrapServers);
        config.put("type", "kafka");
        config.put("cloudevent.codec", "structured");
        config.put("producer.security.protocol", "SASL_SSL");
        config.put("producer.sasl.mechanism", "PLAIN");
        config.put("producer.ssl.endpoint.identification.algorithm", "https");
        return config;
    }

    public static Map<String, Object> minimalKafkaConfig(String bootstrapServers, String apiKey, String apiSecret) {
        Map<String, Object> config = AuditLoggerUtils.helperConfig(bootstrapServers);
        config.put("producer.sasl.jaas.config", "org.apache.kafka.common.security.plain.PlainLoginModule required username=\"" + apiKey + "\" password=\"" + apiSecret + "\";");
        return config;
    }

    public static Map<String, Object> minimalSpireEnabledKafkaConfig(String bootstrapServers, String logicalCluster, String spireSocketPath) {
        Map<String, Object> config = AuditLoggerUtils.helperConfig(bootstrapServers);
        config.put("producer.sasl.login.callback.handler.class", SPIRE_LOGIN_CALLBACK_HANDLER);
        config.put("producer.sasl.oauthbearer.token.spire.agent.endpoint", spireSocketPath);
        config.put("producer.sasl.mechanism", "OAUTHBEARER");
        config.put("producer.sasl.jaas.config", "org.apache.kafka.common.security.oauthbearer.OAuthBearerLoginModule required logicalCluster=\"" + logicalCluster + "\";");
        return config;
    }

    public static Map<String, Object> dynamicKafkaConfig(String bootstrapServers, String credentialsPath, String watchPath, String apiKeyConfig, String apiSecretConfig) {
        Map<String, Object> config = AuditLoggerUtils.helperConfig(bootstrapServers);
        String saslPath = String.format(KAFKA_SASL_FILE_CONFIG, KAFKA_DYNAMIC_MODULE, credentialsPath, watchPath, apiKeyConfig, apiSecretConfig);
        config.put("producer.sasl.jaas.config", saslPath);
        config.put("producer.sasl.login.callback.handler.class", KAFKA_LOGIN_CALLBACK_HANDLER);
        config.put("producer.sasl.client.callback.handler.class", KAFKA_CLIENT_CALLBACK_HANDLER);
        return config;
    }

    public static AuditLog sampleAuditLog(String methodName) {
        return AuditLoggerUtils.sampleAuditLog(methodName, "org-abc");
    }

    public static AuditLog sampleAuditLog(String methodName, String orgId) {
        TypedCloudResourceRef typedCloudResourceRefForEnv = TypedCloudResourceRef.newBuilder().setResourceId("env-xyz").setInternalId("11").setType(TypedCloudResourceRef.ResourceType.ENVIRONMENT).build();
        TypedCloudResourceRef typedCloudResourceRefForOrg = TypedCloudResourceRef.newBuilder().setResourceId(orgId).setInternalId("12").setType(TypedCloudResourceRef.ResourceType.ORGANIZATION).build();
        CloudScope cloudScope = CloudScope.newBuilder().addResources(typedCloudResourceRefForOrg).build();
        FullyQualifiedCloudResourceRef fullyQualifiedCloudResourceRef = FullyQualifiedCloudResourceRef.newBuilder().setScope(cloudScope).setResource(typedCloudResourceRefForEnv).build();
        AuthenticationInfo authenticationInfo = AuthenticationInfo.newBuilder().setPrincipal(Principal.newBuilder().setConfluentUser(ResourceRef.newBuilder().setResourceId("u-woohoo").setInternalId("12"))).setResult(AuthenticationInfo.Result.SUCCESS).build();
        RequestMetadata requestMetadata = RequestMetadata.newBuilder().addRequestId("this-request-id").addClientAddress(RequestMetadata.Address.newBuilder().setIp("127.0.0.1")).build();
        return AuditLog.newBuilder().setMethodName(methodName).addCloudResources(fullyQualifiedCloudResourceRef).setAuthenticationInfo(authenticationInfo).setRequestMetadata(requestMetadata).build();
    }

    public static String formalServiceName(String serviceName) {
        return "crn://confluent.cloud/service=" + serviceName;
    }

    public static CloudEvent toCloudEvent(Event e) {
        Objects.requireNonNull(e.source());
        Objects.requireNonNull(e.subject());
        Objects.requireNonNull(e.type());
        io.cloudevents.core.v1.CloudEventBuilder builder = CloudEventBuilder.v1().withType(e.type()).withSource(e.source()).withSubject(e.subject());
        if (e.id() == null) {
            builder.withId(UUID.randomUUID().toString());
        } else {
            builder.withId(e.id());
        }
        if (e.time() == null) {
            builder.withTime(OffsetDateTime.now(ZoneOffset.UTC));
        } else {
            builder.withTime(e.time());
        }
        if (e.data().isPresent()) {
            Objects.requireNonNull(e.dataContentType());
            builder.withData(e.dataContentType(), (CloudEventData)BytesCloudEventData.wrap((byte[])((byte[])e.data().get())));
        }
        if (e.dataSchema().isPresent()) {
            builder.withDataSchema((URI)e.dataSchema().get());
        }
        for (String ext : e.extensionNames()) {
            builder.withExtension(ext, e.extension(ext));
        }
        return builder.build();
    }

    public static String toJson(Event event) {
        return AuditLoggerUtils.toJson(AuditLoggerUtils.toCloudEvent(event));
    }

    public static String toJson(CloudEvent event) {
        return new String(jsonFormat.serialize(event), StandardCharsets.UTF_8);
    }

    public static void logEventInJson(Event event, Logger logger) {
        try {
            logger.info(AuditLoggerUtils.toJson(event));
        }
        catch (Exception e) {
            log.warn(String.format("[log]: Could not log JSON event [id = %s] using logger [%s], exception - %s", event.id(), logger.getName()), (Object)e.getMessage());
        }
    }
}

