/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.auditlog.emitter.utils;

import lombok.NonNull;

public class IdentityParams {
    @NonNull
    private final String serviceName;
    private final String cloudProvider;
    private final String region;
    private final String kubernetesCluster;
    private final String kubernetesNamespace;
    private final String kubernetesPod;

    IdentityParams(@NonNull String serviceName, String cloudProvider, String region, String kubernetesCluster, String kubernetesNamespace, String kubernetesPod) {
        if (serviceName == null) {
            throw new NullPointerException("serviceName is marked non-null but is null");
        }
        this.serviceName = serviceName;
        this.cloudProvider = cloudProvider;
        this.region = region;
        this.kubernetesCluster = kubernetesCluster;
        this.kubernetesNamespace = kubernetesNamespace;
        this.kubernetesPod = kubernetesPod;
    }

    public static IdentityParamsBuilder builder() {
        return new IdentityParamsBuilder();
    }

    @NonNull
    public String getServiceName() {
        return this.serviceName;
    }

    public String getCloudProvider() {
        return this.cloudProvider;
    }

    public String getRegion() {
        return this.region;
    }

    public String getKubernetesCluster() {
        return this.kubernetesCluster;
    }

    public String getKubernetesNamespace() {
        return this.kubernetesNamespace;
    }

    public String getKubernetesPod() {
        return this.kubernetesPod;
    }

    public static class IdentityParamsBuilder {
        private String serviceName;
        private String cloudProvider;
        private String region;
        private String kubernetesCluster;
        private String kubernetesNamespace;
        private String kubernetesPod;

        IdentityParamsBuilder() {
        }

        public IdentityParamsBuilder serviceName(@NonNull String serviceName) {
            if (serviceName == null) {
                throw new NullPointerException("serviceName is marked non-null but is null");
            }
            this.serviceName = serviceName;
            return this;
        }

        public IdentityParamsBuilder cloudProvider(String cloudProvider) {
            this.cloudProvider = cloudProvider;
            return this;
        }

        public IdentityParamsBuilder region(String region) {
            this.region = region;
            return this;
        }

        public IdentityParamsBuilder kubernetesCluster(String kubernetesCluster) {
            this.kubernetesCluster = kubernetesCluster;
            return this;
        }

        public IdentityParamsBuilder kubernetesNamespace(String kubernetesNamespace) {
            this.kubernetesNamespace = kubernetesNamespace;
            return this;
        }

        public IdentityParamsBuilder kubernetesPod(String kubernetesPod) {
            this.kubernetesPod = kubernetesPod;
            return this;
        }

        public IdentityParams build() {
            return new IdentityParams(this.serviceName, this.cloudProvider, this.region, this.kubernetesCluster, this.kubernetesNamespace, this.kubernetesPod);
        }

        public String toString() {
            return "IdentityParams.IdentityParamsBuilder(serviceName=" + this.serviceName + ", cloudProvider=" + this.cloudProvider + ", region=" + this.region + ", kubernetesCluster=" + this.kubernetesCluster + ", kubernetesNamespace=" + this.kubernetesNamespace + ", kubernetesPod=" + this.kubernetesPod + ")";
        }
    }
}

