/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.security.auth.store.data;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.confluent.security.auth.store.data.AuthEntryType;
import io.confluent.security.auth.store.data.AuthKey;
import io.confluent.security.auth.store.data.exceptions.MissingJwksEndpointException;
import java.util.Objects;

@JsonInclude(value=JsonInclude.Include.ALWAYS)
@JsonIgnoreProperties(ignoreUnknown=true)
public final class JwtIssuerKeyV2
extends AuthKey {
    private final String issuer;
    private final String jwksEndpoint;

    public JwtIssuerKeyV2(@JsonProperty(value="issuer") String issuer, @JsonProperty(value="jwksEndpoint") String jwksEndpoint) {
        this.issuer = Objects.requireNonNull(issuer, "Argument `issuer` must not be null");
        this.jwksEndpoint = MissingJwksEndpointException.requireNonNull(jwksEndpoint, "JwtIssuerKey");
    }

    @JsonProperty
    public String issuer() {
        return this.issuer;
    }

    @JsonProperty
    public String jwksEndpoint() {
        return this.jwksEndpoint;
    }

    @Override
    @JsonIgnore
    public AuthEntryType entryType() {
        return AuthEntryType.JWT_ISSUER;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        JwtIssuerKeyV2 that = (JwtIssuerKeyV2)o;
        return this.issuer.equals(that.issuer) && this.jwksEndpoint.equals(that.jwksEndpoint);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.entryType().name(), this.issuer, this.jwksEndpoint);
    }

    public String toString() {
        return String.format("JwtIssuerKey{\n\tissuer=%s,\n\tjwksEndpoint=%s\n}", this.issuer, this.jwksEndpoint);
    }

    public String cacheKey() {
        return JwtIssuerKeyV2.cacheKey(this.issuer, this.jwksEndpoint);
    }

    public static String cacheKey(String issuer, String jwksEndpoint) {
        String separator = ":";
        return issuer + separator + jwksEndpoint;
    }
}

