/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.databalancing;

import io.confluent.kafka.databalancing.CommandContext;
import io.confluent.kafka.databalancing.RebalancePolicy;
import io.confluent.kafka.databalancing.Rebalancer;
import io.confluent.kafka.databalancing.RebalancerConfig;
import io.confluent.kafka.databalancing.Utils;
import io.confluent.kafka.databalancing.exception.ValidationException;
import io.confluent.kafka.databalancing.metric.Metrics;
import io.confluent.kafka.databalancing.topology.Broker;
import io.confluent.kafka.databalancing.topology.BrokerMetadata;
import io.confluent.kafka.databalancing.topology.ClusterAssignment;
import io.confluent.kafka.databalancing.topology.TopologyUtils;
import io.confluent.metrics.record.ConfluentMetric;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.server.common.AdminCommandFailedException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractRebalancer
implements Rebalancer {
    private static final Logger logger = LoggerFactory.getLogger(AbstractRebalancer.class);
    protected final RebalancerConfig config;

    protected AbstractRebalancer(RebalancerConfig config) {
        this.config = config;
    }

    protected static AdminCommandFailedException partitionsBeingReassignedException(Set<TopicPartition> partitionsBeingReassigned) {
        StringBuilder sb = new StringBuilder();
        for (String line : TopologyUtils.partitionsByTopicToLines(partitionsBeingReassigned)) {
            sb.append("\t" + line + "\n");
        }
        return new AdminCommandFailedException(String.format("A rebalance is currently in progress for:%n%sExiting.", sb.toString()));
    }

    protected RebalancePolicy.Config policyConfig(Metrics metrics, Map<Broker, BrokerMetadata> allBrokers) {
        return AbstractRebalancer.policyConfig(this.config, metrics, allBrokers);
    }

    protected static RebalancePolicy.Config policyConfig(RebalancerConfig config, Metrics metrics, Map<Broker, BrokerMetadata> allBrokers) {
        boolean volumeSafetyRequested;
        ArrayList<Integer> brokersWithMultipleVolumes = new ArrayList<Integer>();
        for (Map.Entry<Broker, List<ConfluentMetric.VolumeMetrics>> entry2 : metrics.brokerToVolumeMetrics().entrySet()) {
            if (entry2.getValue().size() <= 1) continue;
            brokersWithMultipleVolumes.add(entry2.getKey().id());
            break;
        }
        boolean bl = volumeSafetyRequested = config.originals().get("confluent.rebalancer.min.free.volume.space.percentage") != null;
        if (volumeSafetyRequested && !brokersWithMultipleVolumes.isEmpty()) {
            throw new AdminCommandFailedException("Volume Safety requested via --min-free-volume-space-percentage or the confluent.rebalancer.min.free.volume.space.percentage config, but it is currently only supported if a single log directory is configured in every broker in the Kafka cluster. The following brokers have more than one log directory: " + Utils.mkString(brokersWithMultipleVolumes, ", "));
        }
        Set validBrokers = Stream.concat(metrics.brokerToVolumeMetrics().keySet().stream(), allBrokers.entrySet().stream().filter(entry -> ((BrokerMetadata)entry.getValue()).isOffline()).map(Map.Entry::getKey)).collect(Collectors.toSet());
        Set onlineBrokersWithoutVolumeMetrics = allBrokers.keySet().stream().filter(broker -> !validBrokers.contains(broker)).collect(Collectors.toSet());
        if (volumeSafetyRequested && !onlineBrokersWithoutVolumeMetrics.isEmpty()) {
            throw new AdminCommandFailedException("Volume Safety requested via --min-free-volume-space-percentage or the confluent.rebalancer.min.free.volume.space.percentage config, but we were unable to collect volume data for the following brokers " + onlineBrokersWithoutVolumeMetrics);
        }
        Double minFreeVolumeSpacePercentage = config.getDouble("confluent.rebalancer.min.free.volume.space.percentage");
        if (minFreeVolumeSpacePercentage != null && minFreeVolumeSpacePercentage > 0.0) {
            if (!metrics.brokerToVolumeMetrics().isEmpty() && !onlineBrokersWithoutVolumeMetrics.isEmpty()) {
                throw new AdminCommandFailedException("Unable to collect volume data for the following brokers " + onlineBrokersWithoutVolumeMetrics);
            }
            if (!brokersWithMultipleVolumes.isEmpty()) {
                logger.debug("Disabling volume safety by default as there is at least one broker with multiple log directories.");
                minFreeVolumeSpacePercentage = null;
            }
            if (metrics.brokerToVolumeMetrics().isEmpty()) {
                logger.debug("Disabling volume safety by default as volume data is not available.");
                minFreeVolumeSpacePercentage = null;
            }
        }
        return new RebalancePolicy.Config(minFreeVolumeSpacePercentage);
    }

    protected static List<Broker> brokersToRemove(Map<Broker, BrokerMetadata> brokers, ClusterAssignment currentAssignment, CommandContext ctx) {
        List offlineBrokersNotSelectedForRemoval;
        if (!ctx.replicaPlacementOnly && !(offlineBrokersNotSelectedForRemoval = brokers.values().stream().filter(md -> md.isOffline() && !ctx.brokerIdsToRemove.contains(md.id())).map(BrokerMetadata::id).collect(Collectors.toList())).isEmpty()) {
            throw new ValidationException("Brokers with ids: " + offlineBrokersNotSelectedForRemoval + " exist in the current assignment but are not online. Please run this tool with `--remove-broker-ids " + Utils.mkString(offlineBrokersNotSelectedForRemoval, ",") + "` to move partitions away from these brokers. Or use --replica-placement-only if the goal is only to restore replication constraints.");
        }
        ArrayList<Broker> brokersToRemove = new ArrayList<Broker>();
        for (int brokerId : ctx.brokerIdsToRemove) {
            Broker broker = new Broker(brokerId);
            BrokerMetadata metadata = brokers.get(broker);
            if (metadata == null && !currentAssignment.brokers().contains(broker)) {
                throw new ValidationException("Broker with id " + brokerId + " which has been requested for removal is not online and is not a replica of any partition in the scope of this rebalance");
            }
            brokersToRemove.add(broker);
        }
        return brokersToRemove;
    }
}

