/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.databalancing;

import io.confluent.kafka.databalancing.MutableRebalanceContext;
import io.confluent.kafka.databalancing.RebalancePolicy;
import io.confluent.kafka.databalancing.Utils;
import io.confluent.kafka.databalancing.metric.Metrics;
import io.confluent.kafka.databalancing.topology.Broker;
import io.confluent.kafka.databalancing.topology.BrokerMetadata;
import io.confluent.kafka.databalancing.topology.ClusterAssignment;
import io.confluent.kafka.databalancing.topology.PartitionAssignment;
import io.confluent.metrics.record.ConfluentMetric;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.metadata.TopicPlacement;

public class DefaultRebalanceContext
implements MutableRebalanceContext {
    private final Map<String, Integer> replicationFactors;
    private final Map<String, TopicPlacement> topicPlacements;
    private final Map<Broker, BrokerMetadata> brokers;
    private final Map<String, List<Broker>> rackToBrokers;
    private final Set<Broker> brokersToBeRemoved;
    private final Map<TopicPartition, Long> partitionToSize;
    private final RebalancePolicy.Config policyConfig;
    private final Map<Broker, Set<TopicPartition>> brokerToPartitionsBeforeRebalance;
    private final Map<Broker, Long> brokerToTotalBytes;
    private final Map<TopicPartition, PartitionAssignment> assignments;
    private final Map<Broker, List<TopicPartition>> brokerToPartitions;
    private final Map<Broker, List<TopicPartition>> brokerToLeaders;
    private final Map<Broker, List<TopicPartition>> brokerToFollowers;
    private final Map<Broker, List<TopicPartition>> brokerToFirstObservers;
    private final Map<Broker, Long> brokerToUsableBytes;

    private DefaultRebalanceContext(Map<TopicPartition, PartitionAssignment> assignments, Map<Broker, BrokerMetadata> brokers, Map<String, Integer> replicationFactors, Map<String, TopicPlacement> topicPlacements, Metrics metrics, RebalancePolicy.Config policyConfig, Set<Broker> brokersToBeRemoved) {
        this.replicationFactors = replicationFactors;
        this.assignments = assignments;
        this.brokers = brokers;
        this.partitionToSize = Collections.unmodifiableMap(metrics.partitionToSize());
        this.brokersToBeRemoved = Collections.unmodifiableSet(brokersToBeRemoved);
        this.policyConfig = policyConfig;
        this.topicPlacements = topicPlacements;
        HashMap<Broker, Long> brokerToTotalBytes = new HashMap<Broker, Long>();
        HashMap<Broker, Long> brokerToUsableBytes = new HashMap<Broker, Long>();
        if (policyConfig.hasMinFreeVolumeSpace()) {
            for (Map.Entry<Broker, List<ConfluentMetric.VolumeMetrics>> entry : metrics.brokerToVolumeMetrics().entrySet()) {
                Broker broker = entry.getKey();
                List<ConfluentMetric.VolumeMetrics> value = entry.getValue();
                if (value.isEmpty()) {
                    throw new IllegalArgumentException("No volume metrics found for broker " + broker);
                }
                if (value.size() > 1) {
                    throw new IllegalArgumentException("We only support metrics for a single volume, but broker " + broker + " has " + value.size() + " volumes.");
                }
                ConfluentMetric.VolumeMetrics volumeMetrics = value.get(0);
                brokerToTotalBytes.put(broker, volumeMetrics.getTotalBytes());
                brokerToUsableBytes.put(broker, volumeMetrics.getUsableBytes());
            }
        }
        HashMap<Broker, List<TopicPartition>> brokerToPartitions = new HashMap<Broker, List<TopicPartition>>();
        HashMap<Broker, List<TopicPartition>> brokerToFollowers = new HashMap<Broker, List<TopicPartition>>();
        HashMap<Broker, List<TopicPartition>> brokerToFirstObservers = new HashMap<Broker, List<TopicPartition>>();
        HashMap<Broker, List<TopicPartition>> brokerToLeaders = new HashMap<Broker, List<TopicPartition>>();
        for (Map.Entry<TopicPartition, PartitionAssignment> entry : assignments.entrySet()) {
            TopicPartition topicPartition = entry.getKey();
            PartitionAssignment assignment = entry.getValue();
            for (Broker broker : assignment.replicas) {
                DefaultRebalanceContext.addOrUpdate(brokerToPartitions, topicPartition, broker);
                assignment.firstObserver().ifPresent(firstObserver -> {
                    if (broker.equals(firstObserver)) {
                        DefaultRebalanceContext.addOrUpdate(brokerToFirstObservers, topicPartition, broker);
                    }
                });
                assignment.preferredLeader().ifPresent(leader -> {
                    if (broker.equals(leader)) {
                        DefaultRebalanceContext.addOrUpdate(brokerToLeaders, topicPartition, broker);
                    } else {
                        DefaultRebalanceContext.addOrUpdate(brokerToFollowers, topicPartition, broker);
                    }
                });
            }
        }
        HashMap<String, List<Broker>> rackToBrokers = new HashMap<String, List<Broker>>();
        for (Map.Entry<Broker, BrokerMetadata> entry : brokers.entrySet()) {
            Broker broker;
            BrokerMetadata metadata = entry.getValue();
            if (!metadata.rack().isPresent()) continue;
            List brokersOnRack = rackToBrokers.computeIfAbsent(metadata.rack().get(), k -> new ArrayList());
            broker = entry.getKey();
            brokersOnRack.add(broker);
        }
        for (Broker broker : brokers.keySet()) {
            DefaultRebalanceContext.putIfAbsent(brokerToPartitions, broker, Collections.emptyList());
            DefaultRebalanceContext.putIfAbsent(brokerToFollowers, broker, Collections.emptyList());
            DefaultRebalanceContext.putIfAbsent(brokerToLeaders, broker, Collections.emptyList());
        }
        this.brokerToUsableBytes = brokerToUsableBytes;
        this.brokerToTotalBytes = Collections.unmodifiableMap(brokerToTotalBytes);
        this.rackToBrokers = rackToBrokers;
        this.brokerToPartitionsBeforeRebalance = Collections.unmodifiableMap(this.mapValuesToSet(brokerToPartitions));
        this.brokerToPartitions = brokerToPartitions;
        this.brokerToFollowers = brokerToFollowers;
        this.brokerToFirstObservers = brokerToFirstObservers;
        this.brokerToLeaders = brokerToLeaders;
    }

    private <K, V> Map<K, Set<V>> mapValuesToSet(Map<K, List<V>> map) {
        HashMap result = new HashMap(map.size());
        for (Map.Entry<K, List<V>> entry : map.entrySet()) {
            result.put(entry.getKey(), new HashSet(entry.getValue()));
        }
        return result;
    }

    private static <K, V> void putIfAbsent(Map<K, V> map, K key, V value) {
        if (!map.containsKey(key)) {
            map.put(key, value);
        }
    }

    private static void addOrUpdate(Map<Broker, List<TopicPartition>> brokerToPartitions, TopicPartition topicPartition, Broker broker) {
        List<TopicPartition> partitions = brokerToPartitions.get(broker);
        if (partitions == null) {
            partitions = new ArrayList<TopicPartition>();
            brokerToPartitions.put(broker, partitions);
        }
        partitions.add(topicPartition);
    }

    @Override
    public boolean isOffline(Broker broker) {
        BrokerMetadata metadata = this.brokers.get(broker);
        return metadata == null || metadata.isOffline();
    }

    @Override
    public Set<Broker> offlineBrokers() {
        return this.brokers.keySet().stream().filter(this::isOffline).collect(Collectors.toSet());
    }

    @Override
    public List<Broker> syncReplicas(TopicPartition topicPartition) {
        PartitionAssignment assignment = this.assignments.get(topicPartition);
        if (assignment == null) {
            return Collections.emptyList();
        }
        return this.brokersOnRack(assignment.syncReplicas(), null);
    }

    @Override
    public List<Broker> observers(TopicPartition topicPartition) {
        PartitionAssignment assignment = this.assignments.get(topicPartition);
        if (assignment == null) {
            return Collections.emptyList();
        }
        return this.brokersOnRack(assignment.observers(), null);
    }

    @Override
    public List<Broker> brokers(TopicPartition topicPartition, String rack) {
        PartitionAssignment assignment = this.assignments.get(topicPartition);
        if (assignment == null) {
            return Collections.emptyList();
        }
        return this.brokersOnRack(assignment.replicas, rack);
    }

    @Override
    public List<Broker> brokers(TopicPartition topicPartition) {
        return this.brokers(topicPartition, null);
    }

    @Override
    public PartitionAssignment assignment(TopicPartition topicPartition) {
        PartitionAssignment assignment = this.assignments.get(topicPartition);
        return assignment == null ? null : assignment.dup();
    }

    @Override
    public Set<String> allRacks() {
        return Collections.unmodifiableSet(this.rackToBrokers.keySet());
    }

    @Override
    public Set<String> allRetainedRacks() {
        return this.brokersToBeRemoved.isEmpty() ? this.allRacks() : this.allBrokers().stream().filter(broker -> !this.brokersToBeRemoved.contains(broker)).map(this::brokerRack).filter(Objects::nonNull).collect(Collectors.toSet());
    }

    private List<Broker> brokersOnRack(List<Broker> replicas, String rack) {
        if (rack == null) {
            return new ArrayList<Broker>(replicas);
        }
        ArrayList<Broker> brokersOnRack = new ArrayList<Broker>(replicas.size());
        for (Broker broker : replicas) {
            BrokerMetadata metadata = this.brokers.get(broker);
            if (!metadata.matchesRack(rack)) continue;
            brokersOnRack.add(broker);
        }
        return brokersOnRack;
    }

    @Override
    public Collection<Broker> brokersOnRack(String rack) {
        if (rack == null) {
            return this.allBrokers();
        }
        List<Broker> brokers = this.rackToBrokers.get(rack);
        return brokers == null ? Collections.emptyList() : Collections.unmodifiableList(brokers);
    }

    @Override
    public Collection<Broker> brokersOnRacks(Collection<String> racks) {
        HashSet<Broker> brokers = new HashSet<Broker>();
        for (String rack : racks) {
            List<Broker> brokersOnRack = this.rackToBrokers.get(rack);
            if (brokersOnRack == null) continue;
            brokers.addAll(brokersOnRack);
        }
        return Collections.unmodifiableCollection(brokers);
    }

    @Override
    public Map<String, String> brokerProperties(Broker broker) {
        BrokerMetadata metadata = this.brokers.get(broker);
        if (metadata == null) {
            return Collections.emptyMap();
        }
        return metadata.properties();
    }

    @Override
    public Collection<Broker> allBrokers() {
        return Collections.unmodifiableSet(this.brokerToPartitions.keySet());
    }

    @Override
    public ClusterAssignment buildAssignment() {
        return new ClusterAssignment(Collections.unmodifiableMap(this.assignments));
    }

    @Override
    public int replicationFactor(String topic) {
        Optional<TopicPlacement> topicPlacement = this.topicPlacement(topic);
        if (topicPlacement.isPresent()) {
            return Utils.getExpectedReplicaCount(topicPlacement.get()) + Utils.getExpectedObserverCount(topicPlacement.get());
        }
        Integer rf = this.replicationFactors.get(topic);
        if (rf == null) {
            throw new IllegalArgumentException("Unknown topic " + topic);
        }
        return rf;
    }

    @Override
    public Collection<TopicPartition> allPartitions() {
        return Collections.unmodifiableCollection(this.assignments.keySet());
    }

    @Override
    public Broker leader(TopicPartition topicPartition) {
        List<Broker> replicas = this.brokers(topicPartition);
        return replicas.isEmpty() ? null : replicas.get(0);
    }

    @Override
    public Optional<Broker> firstObserver(TopicPartition topicPartition) {
        PartitionAssignment assignment = this.assignments.get(topicPartition);
        return assignment == null ? Optional.empty() : assignment.firstObserver();
    }

    @Override
    public Optional<TopicPlacement> topicPlacement(String topic) {
        return Optional.ofNullable(this.topicPlacements.get(topic));
    }

    @Override
    public List<TopicPartition> followers(Broker broker) {
        List<TopicPartition> followers = this.brokerToFollowers.get(broker);
        return followers == null ? Collections.emptyList() : Collections.unmodifiableList(followers);
    }

    @Override
    public List<TopicPartition> syncFollowers(Broker broker) {
        return this.brokerToFollowers.getOrDefault(broker, Collections.emptyList()).stream().filter(tp -> {
            PartitionAssignment partitionAssignment = this.assignments.get(tp);
            return partitionAssignment != null && !partitionAssignment.observers.contains(broker);
        }).collect(Collectors.toList());
    }

    @Override
    public int brokerTopicReplicaCount(Broker broker, String topic) {
        int result = 0;
        for (TopicPartition tp : this.replicas(broker)) {
            if (topic != null && !tp.topic().equals(topic)) continue;
            ++result;
        }
        return result;
    }

    @Override
    public List<TopicPartition> replicas(Broker broker) {
        List<TopicPartition> topicPartitions = this.brokerToPartitions.get(broker);
        return topicPartitions == null ? Collections.emptyList() : Collections.unmodifiableList(topicPartitions);
    }

    @Override
    public List<TopicPartition> leaders(Broker broker) {
        List<TopicPartition> leaders = this.brokerToLeaders.get(broker);
        return leaders == null ? Collections.emptyList() : Collections.unmodifiableList(leaders);
    }

    @Override
    public List<TopicPartition> firstObservers(Broker broker) {
        List<TopicPartition> firstObservers = this.brokerToFirstObservers.get(broker);
        return firstObservers == null ? Collections.emptyList() : Collections.unmodifiableList(firstObservers);
    }

    @Override
    public String brokerRack(Broker broker) {
        BrokerMetadata metadata = this.brokers.get(broker);
        if (metadata == null) {
            return null;
        }
        return metadata.rack().orElse(null);
    }

    @Override
    public Set<Broker> brokersToBeRemoved() {
        return this.brokersToBeRemoved;
    }

    @Override
    public Collection<String> topics() {
        HashSet<String> topics = new HashSet<String>();
        for (TopicPartition tp : this.allPartitions()) {
            topics.add(tp.topic());
        }
        return topics;
    }

    @Override
    public Long brokerUsableBytes(Broker broker) {
        return this.brokerToUsableBytes.get(broker);
    }

    @Override
    public Long brokerUsableBytesAfterPartitionRemoval(Broker broker, TopicPartition topicPartition) {
        Long usableDiskSpace = this.brokerToUsableBytes.get(broker);
        if (usableDiskSpace == null) {
            return null;
        }
        if (this.brokerToPartitionsBeforeRebalance.get(broker).contains(topicPartition)) {
            return usableDiskSpace;
        }
        return usableDiskSpace + this.partitionSize(topicPartition);
    }

    @Override
    public Long brokerTotalBytes(Broker broker) {
        return this.brokerToTotalBytes.get(broker);
    }

    @Override
    public RebalancePolicy.Config policyConfig() {
        return this.policyConfig;
    }

    @Override
    public boolean hasBrokerSpaceInfo() {
        return !this.brokerToUsableBytes.isEmpty();
    }

    @Override
    public int brokerTopicLeaderCount(Broker broker, String topic) {
        int result = 0;
        for (TopicPartition tp : this.leaders(broker)) {
            if (topic != null && !tp.topic().equals(topic)) continue;
            ++result;
        }
        return result;
    }

    @Override
    public int brokerTopicFirstObserverCount(Broker broker, String topic) {
        return (int)this.firstObservers(broker).stream().filter(topicPartition -> topic == null || topicPartition.topic().equals(topic)).count();
    }

    @Override
    public long brokerSize(Broker broker) {
        return this.brokerTopicSize(broker, null);
    }

    @Override
    public long brokerTopicSize(Broker broker, String topic) {
        long result = 0L;
        for (TopicPartition partition : this.replicas(broker)) {
            if (topic != null && !partition.topic().equals(topic)) continue;
            result += this.partitionSize(partition);
        }
        return result;
    }

    @Override
    public long brokerTopicLeadersSize(Broker broker, String topic) {
        long result = 0L;
        for (TopicPartition partition : this.leaders(broker)) {
            if (topic != null && !partition.topic().equals(topic)) continue;
            result += this.partitionSize(partition);
        }
        return result;
    }

    @Override
    public long partitionSize(TopicPartition topicPartition) {
        Long size = this.partitionToSize.get(topicPartition);
        if (size == null) {
            throw new IllegalArgumentException("Unknown partition " + topicPartition);
        }
        return size;
    }

    @Override
    public void addSyncReplica(TopicPartition topicPartition, Broker destinationBroker) {
        this.addReplica(topicPartition, destinationBroker, assignment -> assignment.addSyncReplica(destinationBroker));
    }

    @Override
    public void addObserver(TopicPartition topicPartition, Broker destinationBroker) {
        this.addReplica(topicPartition, destinationBroker, assignment -> assignment.addObserver(destinationBroker));
    }

    private void addReplica(TopicPartition topicPartition, Broker destinationBroker, Consumer<PartitionAssignment> updateAssignment) {
        PartitionAssignment assignment = this.assignments.get(topicPartition);
        Broker leader = assignment.preferredLeader().orElse(null);
        Broker firstObserver = assignment.firstObserver().orElse(null);
        updateAssignment.accept(assignment);
        assert (leader == null || leader.equals(assignment.preferredLeader().orElse(null)));
        assert (firstObserver == null || firstObserver.equals(assignment.firstObserver().orElse(null)));
        if (destinationBroker.equals(assignment.preferredLeader().orElse(null))) {
            DefaultRebalanceContext.updateBrokerToPartitionsMap(this.brokerToLeaders, topicPartition, null, destinationBroker);
        } else {
            DefaultRebalanceContext.updateBrokerToPartitionsMap(this.brokerToFollowers, topicPartition, null, destinationBroker);
            if (destinationBroker.equals(assignment.firstObserver().orElse(null))) {
                DefaultRebalanceContext.updateBrokerToPartitionsMap(this.brokerToFirstObservers, topicPartition, null, destinationBroker);
            }
        }
        ArrayList<TopicPartition> partitions = new ArrayList<TopicPartition>((Collection)this.brokerToPartitions.get(destinationBroker));
        if (partitions.contains(topicPartition)) {
            throw new AssertionError((Object)("Inconsistent state between assignments and brokerToPartitions with regards to " + topicPartition + " and " + destinationBroker));
        }
        partitions.add(topicPartition);
        this.brokerToPartitions.put(destinationBroker, partitions);
        this.removeUsableDiskSpace(destinationBroker, topicPartition);
    }

    @Override
    public void removeReplica(TopicPartition topicPartition, Broker broker) {
        PartitionAssignment assignment = this.assignments.get(topicPartition);
        boolean wasPreferredLeader = broker.equals(assignment.preferredLeader().orElse(null));
        boolean wasFirstObserver = broker.equals(assignment.firstObserver().orElse(null));
        if (!assignment.removeReplica(broker)) {
            throw new IllegalArgumentException("Broker " + broker + " does not contain " + topicPartition);
        }
        if (wasPreferredLeader) {
            Broker newLeader = assignment.preferredLeader().orElse(null);
            DefaultRebalanceContext.updateBrokerToPartitionsMap(this.brokerToFollowers, topicPartition, newLeader, null);
            DefaultRebalanceContext.updateBrokerToPartitionsMap(this.brokerToLeaders, topicPartition, broker, newLeader);
        } else {
            if (wasFirstObserver) {
                Broker newFirstObserver = assignment.firstObserver().orElse(null);
                DefaultRebalanceContext.updateBrokerToPartitionsMap(this.brokerToFirstObservers, topicPartition, broker, newFirstObserver);
            }
            DefaultRebalanceContext.updateBrokerToPartitionsMap(this.brokerToFollowers, topicPartition, broker, null);
        }
        ArrayList partitions = new ArrayList(this.brokerToPartitions.get(broker));
        if (!partitions.contains(topicPartition)) {
            throw new AssertionError((Object)("Inconsistent state between assignments and brokerToPartitions with regards to " + topicPartition + " and " + broker));
        }
        partitions.remove(topicPartition);
        this.brokerToPartitions.put(broker, partitions);
        this.addUsableDiskSpace(broker, topicPartition);
    }

    public static MutableRebalanceContext create(Collection<BrokerMetadata> brokers, ClusterAssignment currentAssignment, Map<String, Integer> replicationFactors, Map<String, TopicPlacement> topicPlacements, Metrics metrics, RebalancePolicy.Config policyConfig, List<Broker> brokersToRemove) {
        return DefaultRebalanceContext.create(Utils.brokersMap(brokers), currentAssignment, replicationFactors, topicPlacements, metrics, policyConfig, brokersToRemove);
    }

    public static MutableRebalanceContext create(Map<Broker, BrokerMetadata> brokers, ClusterAssignment currentAssignment, Map<String, Integer> replicationFactors, Map<String, TopicPlacement> topicPlacements, Metrics metrics, RebalancePolicy.Config policyConfig, List<Broker> brokersToRemove) {
        HashMap<TopicPartition, PartitionAssignment> assignments = new HashMap<TopicPartition, PartitionAssignment>(currentAssignment.size());
        for (Map.Entry<TopicPartition, PartitionAssignment> entry : currentAssignment.asMap().entrySet()) {
            TopicPartition tp = entry.getKey();
            if (!metrics.partitionToSize().containsKey(tp)) {
                throw new IllegalArgumentException("`partitionToSize` is missing an entry for partition " + tp);
            }
            if (!replicationFactors.containsKey(tp.topic())) {
                throw new IllegalArgumentException("`replicationFactors` is missing an entry for topic " + tp.topic());
            }
            PartitionAssignment assignment = entry.getValue();
            assignments.put(tp, assignment.dup());
        }
        return new DefaultRebalanceContext(assignments, brokers, replicationFactors, topicPlacements == null ? Collections.emptyMap() : topicPlacements, metrics, policyConfig, new HashSet<Broker>(brokersToRemove));
    }

    @Override
    public Set<String> racks(List<Broker> brokers) {
        HashSet<String> racks = new HashSet<String>();
        for (Broker broker : brokers) {
            BrokerMetadata metadata = this.brokers.get(broker);
            if (metadata == null || !metadata.rack().isPresent()) continue;
            racks.add(metadata.rack().get());
        }
        return Collections.unmodifiableSet(racks);
    }

    @Override
    public void movePartition(TopicPartition topicPartition, Broker from, Broker to) {
        DefaultRebalanceContext.updateBrokerToPartitionsMap(this.brokerToPartitions, topicPartition, from, to);
        PartitionAssignment assignment = this.assignments.get(topicPartition);
        assignment.replace(from, to);
        if (to.equals(assignment.firstObserver().orElse(null))) {
            DefaultRebalanceContext.updateBrokerToPartitionsMap(this.brokerToFirstObservers, topicPartition, from, to);
        }
        if (to.equals(assignment.preferredLeader().orElse(null))) {
            DefaultRebalanceContext.updateBrokerToPartitionsMap(this.brokerToLeaders, topicPartition, from, to);
        } else {
            DefaultRebalanceContext.updateBrokerToPartitionsMap(this.brokerToFollowers, topicPartition, from, to);
        }
        this.addUsableDiskSpace(from, topicPartition);
        this.removeUsableDiskSpace(to, topicPartition);
    }

    private void removeUsableDiskSpace(Broker broker, TopicPartition topicPartition) {
        if (this.brokerToUsableBytes.isEmpty()) {
            return;
        }
        Long usableDiskSpace = this.brokerToUsableBytes.get(broker);
        if (usableDiskSpace == null && !this.brokers.get(broker).isOffline()) {
            throw new IllegalArgumentException("No information about usable disk space for broker " + broker.id());
        }
        if (usableDiskSpace != null) {
            this.brokerToUsableBytes.put(broker, usableDiskSpace - this.partitionSize(topicPartition));
        }
    }

    private void addUsableDiskSpace(Broker broker, TopicPartition topicPartition) {
        if (this.brokerToUsableBytes.isEmpty()) {
            return;
        }
        if (!this.brokerToPartitions.containsKey(broker)) {
            return;
        }
        this.brokerToUsableBytes.put(broker, this.brokerUsableBytesAfterPartitionRemoval(broker, topicPartition));
    }

    @Override
    public void makeLeader(TopicPartition topicPartition, Broker newLeader) {
        PartitionAssignment assignment = this.assignments.get(topicPartition);
        Broker previousLeader = assignment.makeLeader(newLeader);
        DefaultRebalanceContext.updateBrokerToPartitionsMap(this.brokerToLeaders, topicPartition, previousLeader, newLeader);
        DefaultRebalanceContext.updateBrokerToPartitionsMap(this.brokerToFollowers, topicPartition, newLeader, previousLeader);
    }

    @Override
    public void makeFirstObserver(TopicPartition topicPartition, Broker newFirstObserver) {
        PartitionAssignment assignment = this.assignments.get(topicPartition);
        Broker previousFirstObserver = assignment.makeFirstObserver(newFirstObserver);
        DefaultRebalanceContext.updateBrokerToPartitionsMap(this.brokerToFirstObservers, topicPartition, previousFirstObserver, newFirstObserver);
        DefaultRebalanceContext.updateBrokerToPartitionsMap(this.brokerToFollowers, topicPartition, previousFirstObserver, newFirstObserver);
        DefaultRebalanceContext.updateBrokerToPartitionsMap(this.brokerToPartitions, topicPartition, previousFirstObserver, newFirstObserver);
    }

    @Override
    public void swapObservers(TopicPartition topicPartition, Broker newFirstObserver) {
        PartitionAssignment assignment = this.assignments.get(topicPartition);
        Broker previousFirstObserver = assignment.swapObservers(newFirstObserver);
        DefaultRebalanceContext.updateBrokerToPartitionsMap(this.brokerToFirstObservers, topicPartition, previousFirstObserver, newFirstObserver);
    }

    private static void updateBrokerToPartitionsMap(Map<Broker, List<TopicPartition>> map, TopicPartition topicPartition, Broker toRemove, Broker toAdd) {
        if (toRemove != null) {
            ArrayList partitionsToRemove = new ArrayList(map.getOrDefault(toRemove, Collections.emptyList()));
            if (!partitionsToRemove.contains(topicPartition)) {
                throw new IllegalArgumentException(toRemove + " does not hold partition " + topicPartition);
            }
            partitionsToRemove.remove(topicPartition);
            map.put(toRemove, partitionsToRemove);
        }
        if (toAdd != null) {
            ArrayList<TopicPartition> partitionsToAdd = new ArrayList<TopicPartition>(map.getOrDefault(toAdd, Collections.emptyList()));
            if (partitionsToAdd.contains(topicPartition)) {
                throw new IllegalArgumentException(toAdd + " already holds partition " + topicPartition);
            }
            partitionsToAdd.add(topicPartition);
            map.put(toAdd, partitionsToAdd);
        }
    }
}

