/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.databalancing;

import io.confluent.kafka.databalancing.AlterTopicConfigsEntry;
import io.confluent.kafka.databalancing.DefaultRebalancer;
import io.confluent.kafka.databalancing.RebalancerAdmin;
import io.confluent.kafka.databalancing.topology.BrokerMetadata;
import io.confluent.kafka.databalancing.topology.ClusterAssignment;
import io.confluent.kafka.databalancing.topology.ClusterReassignment;
import io.confluent.kafka.databalancing.topology.PartitionAssignment;
import io.confluent.kafka.databalancing.topology.PartitionReassignment;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.admin.AlterConfigOp;
import org.apache.kafka.clients.admin.Config;
import org.apache.kafka.clients.admin.ConfigEntry;
import org.apache.kafka.clients.admin.ListTopicsOptions;
import org.apache.kafka.clients.admin.NewPartitionReassignment;
import org.apache.kafka.clients.admin.TopicDescription;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.KafkaFuture;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.TopicPartitionInfo;
import org.apache.kafka.common.config.ConfigResource;
import org.apache.kafka.common.errors.InterruptException;

public class RebalancerAdminClient
implements RebalancerAdmin {
    private final Admin admin;

    public RebalancerAdminClient(Admin admin) {
        this.admin = admin;
    }

    private <T> T getValue(KafkaFuture<T> future) {
        try {
            return (T)future.get();
        }
        catch (InterruptedException ex) {
            throw new InterruptException(ex);
        }
        catch (ExecutionException ex) {
            throw new KafkaException(ex.getCause());
        }
    }

    @Override
    public String getClusterId() {
        return (String)this.getValue(this.admin.describeCluster().clusterId());
    }

    private Map<String, Optional<String>> toStringMap(Config config) {
        HashMap<String, Optional<String>> result = new HashMap<String, Optional<String>>(config.entries().size());
        for (ConfigEntry entry : config.entries()) {
            Optional<String> value = Optional.ofNullable(entry.value());
            if (!value.isPresent() && !entry.isSensitive()) continue;
            result.put(entry.name(), value);
        }
        return result;
    }

    private <T> Map<T, Map<String, Optional<String>>> toStringMap(Map<ConfigResource, Config> configs, Function<String, T> convert) {
        HashMap<T, Map<String, Optional<String>>> result = new HashMap<T, Map<String, Optional<String>>>(configs.size());
        for (Map.Entry<ConfigResource, Config> entry : configs.entrySet()) {
            result.put(convert.apply(entry.getKey().name()), this.toStringMap(entry.getValue()));
        }
        return result;
    }

    @Override
    public Map<String, Map<String, Optional<String>>> fetchTopicConfigs(Set<String> topics) {
        ArrayList<ConfigResource> configResources = new ArrayList<ConfigResource>(topics.size());
        for (String topic : topics) {
            configResources.add(new ConfigResource(ConfigResource.Type.TOPIC, topic));
        }
        return this.toStringMap((Map)this.getValue(this.admin.describeConfigs(configResources).all()), Function.identity());
    }

    @Override
    public Set<String> getAllTopicsInCluster(boolean listInternal) {
        return (Set)this.getValue(this.admin.listTopics(new ListTopicsOptions().listInternal(listInternal)).names());
    }

    @Override
    public Set<String> getAllDeletedTopicsInCluster() {
        return Collections.emptySet();
    }

    private Collection<AlterConfigOp> toAlterConfigOps(Map<String, String> alterations) {
        ArrayList<AlterConfigOp> alterConfigOps = new ArrayList<AlterConfigOp>(alterations.size());
        for (Map.Entry<String, String> entry : alterations.entrySet()) {
            alterConfigOps.add(new AlterConfigOp(new ConfigEntry(entry.getKey(), entry.getValue()), entry.getValue() != null ? AlterConfigOp.OpType.SET : AlterConfigOp.OpType.DELETE));
        }
        return alterConfigOps;
    }

    @Override
    public void alterTopicConfigs(Collection<AlterTopicConfigsEntry> alterEntries) {
        HashMap<ConfigResource, Collection<AlterConfigOp>> configs = new HashMap<ConfigResource, Collection<AlterConfigOp>>(alterEntries.size());
        for (AlterTopicConfigsEntry entry : alterEntries) {
            configs.put(new ConfigResource(ConfigResource.Type.TOPIC, entry.topic()), this.toAlterConfigOps(entry.alterations()));
        }
        this.getValue(this.admin.incrementalAlterConfigs(configs).all());
    }

    @Override
    public Map<Integer, Map<String, Optional<String>>> fetchBrokerConfigs(Collection<Integer> brokerIds) {
        ArrayList<ConfigResource> configResources = new ArrayList<ConfigResource>(brokerIds.size());
        for (Integer brokerId : brokerIds) {
            configResources.add(new ConfigResource(ConfigResource.Type.BROKER, brokerId.toString()));
        }
        return this.toStringMap((Map)this.getValue(this.admin.describeConfigs(configResources).all()), Integer::valueOf);
    }

    @Override
    public List<BrokerMetadata> getAllBrokerMetadata() {
        Collection nodes = (Collection)this.getValue(this.admin.describeCluster().nodes());
        ArrayList<BrokerMetadata> result = new ArrayList<BrokerMetadata>(nodes.size());
        for (Node node : nodes) {
            result.add(BrokerMetadata.online(node.id(), Optional.ofNullable(node.rack())));
        }
        return result;
    }

    @Override
    public Set<Integer> getAllBrokersInCluster() {
        return ((Collection)this.getValue(this.admin.describeCluster().nodes())).stream().map(Node::id).collect(Collectors.toSet());
    }

    @Override
    public void alterBrokerConfigs(Map<Integer, Map<String, Optional<String>>> configs, Map<String, String> alterations) {
        HashMap<ConfigResource, Collection<AlterConfigOp>> alterConfigs = new HashMap<ConfigResource, Collection<AlterConfigOp>>(alterations.size());
        Collection<AlterConfigOp> alterConfigOps = this.toAlterConfigOps(alterations);
        for (Integer brokerId : configs.keySet()) {
            alterConfigs.put(new ConfigResource(ConfigResource.Type.BROKER, brokerId.toString()), alterConfigOps);
        }
        this.getValue(this.admin.incrementalAlterConfigs(alterConfigs).all());
    }

    @Override
    public boolean reassignPartitionsInProgress() {
        return !((Map)this.getValue(this.admin.listPartitionReassignments().reassignments())).isEmpty();
    }

    @Override
    public ClusterReassignment currentReassignment() {
        Map reassignments = (Map)this.getValue(this.admin.listPartitionReassignments().reassignments());
        HashMap<TopicPartition, PartitionReassignment> result = new HashMap<TopicPartition, PartitionReassignment>(reassignments.size());
        for (Map.Entry entry : reassignments.entrySet()) {
            org.apache.kafka.clients.admin.PartitionReassignment reassignment = (org.apache.kafka.clients.admin.PartitionReassignment)entry.getValue();
            ArrayList<Integer> originalReplicas = new ArrayList<Integer>(reassignment.replicas());
            originalReplicas.removeAll(reassignment.addingReplicas());
            ArrayList<Integer> targetReplicas = new ArrayList<Integer>(reassignment.replicas());
            targetReplicas.removeAll(reassignment.removingReplicas());
            result.put((TopicPartition)entry.getKey(), new PartitionReassignment(originalReplicas, targetReplicas));
        }
        return new ClusterReassignment(result);
    }

    @Override
    public void createPartitionReassignment(Map<TopicPartition, NewPartitionReassignment> assignment) {
        Map<TopicPartition, Optional> reassignment = assignment.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> Optional.of(e.getValue())));
        this.getValue(this.admin.alterPartitionReassignments(reassignment).all());
    }

    @Override
    public void cancelPartitionReassignment(Set<TopicPartition> partitions) {
        Map cancellations = partitions.stream().collect(Collectors.toMap(Function.identity(), tp -> Optional.empty()));
        this.getValue(this.admin.alterPartitionReassignments(cancellations).all());
    }

    private Collection<String> getTopicsToQuery(Optional<Set<String>> filterTopics, boolean excludeInternalTopics) {
        if (!filterTopics.isPresent() && excludeInternalTopics) {
            Set<String> nonInternalTopics = this.getAllTopicsInCluster(false);
            return nonInternalTopics.stream().filter(t -> !DefaultRebalancer.isInternalTopic(t, nonInternalTopics)).collect(Collectors.toSet());
        }
        return filterTopics.orElse(this.getAllTopicsInCluster(true));
    }

    @Override
    public ClusterAssignment currentAssignment(Optional<Set<String>> filterTopics, boolean excludeInternalTopics) {
        Collection<String> topicsToQuery = this.getTopicsToQuery(filterTopics, excludeInternalTopics);
        HashMap<TopicPartition, PartitionAssignment> result = new HashMap<TopicPartition, PartitionAssignment>();
        for (Map.Entry entry : ((Map)this.getValue(this.admin.describeTopics(topicsToQuery).all())).entrySet()) {
            for (TopicPartitionInfo info : ((TopicDescription)entry.getValue()).partitions()) {
                List<Integer> replicas = info.replicas().stream().map(Node::id).collect(Collectors.toList());
                List<Integer> observers = info.observers().stream().map(Node::id).collect(Collectors.toList());
                TopicPartition partition = new TopicPartition((String)entry.getKey(), info.partition());
                result.put(partition, PartitionAssignment.create(replicas, observers));
            }
        }
        return new ClusterAssignment(result);
    }

    @Override
    public void close() {
        this.admin.close();
    }
}

