/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.databalancing;

import io.confluent.kafka.databalancing.MutableRebalanceContext;
import io.confluent.kafka.databalancing.RebalanceContext;
import io.confluent.kafka.databalancing.topology.Broker;
import io.confluent.kafka.databalancing.topology.BrokerMetadata;
import java.text.DecimalFormat;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.kafka.metadata.TopicPlacement;

public class Utils {
    private static final DecimalFormat mbFormatter = new DecimalFormat("#,###.#");

    public static <T extends Comparable<T>> List<T> sorted(Collection<T> collection) {
        ArrayList<T> res = new ArrayList<T>(collection);
        Collections.sort(res);
        return res;
    }

    public static <T> List<T> sorted(Collection<T> collection, Comparator<T> comparator) {
        ArrayList<T> res = new ArrayList<T>(collection);
        Collections.sort(res, comparator);
        return res;
    }

    public static <T> String mkString(Collection<T> c, String separator) {
        boolean first = true;
        StringBuilder result = new StringBuilder();
        for (T element : c) {
            if (first) {
                first = false;
            } else {
                result.append(separator);
            }
            result.append(element.toString());
        }
        return result.toString();
    }

    public static String bytesToFormattedMb(long value) {
        return mbFormatter.format((double)value / 1000000.0);
    }

    private static boolean brokerMatchesReplicaPlacement(RebalanceContext context, Broker broker, Optional<TopicPlacement> placement) {
        return placement.map(topicPlacement -> topicPlacement.matchesReplicas(context.brokerProperties(broker))).orElse(true);
    }

    static boolean brokerMatchesObserverPlacement(RebalanceContext context, Broker broker, Optional<TopicPlacement> placement) {
        return placement.map(topicPlacement -> topicPlacement.matchesObservers(context.brokerProperties(broker))).orElse(false);
    }

    private static List<TopicPlacement.ConstraintCount> getAllConstraints(TopicPlacement topicPlacement) {
        ArrayList<TopicPlacement.ConstraintCount> allConstraints = new ArrayList<TopicPlacement.ConstraintCount>(topicPlacement.replicas());
        allConstraints.addAll(topicPlacement.observers());
        return allConstraints;
    }

    public static boolean brokersMatchSameConstraint(RebalanceContext context, Broker firstBroker, Broker secondBroker, Optional<TopicPlacement> placement) {
        if (!placement.isPresent()) {
            return true;
        }
        Map<String, String> firstBrokerProperties = context.brokerProperties(firstBroker);
        Map<String, String> secondBrokerProperties = context.brokerProperties(secondBroker);
        for (TopicPlacement.ConstraintCount constraint : Utils.getAllConstraints(placement.get())) {
            if (!constraint.matches(firstBrokerProperties)) continue;
            return constraint.matches(secondBrokerProperties);
        }
        return false;
    }

    public static boolean brokerMatchesAnyConstraint(RebalanceContext context, Broker broker, Optional<TopicPlacement> placement) {
        if (!placement.isPresent()) {
            return true;
        }
        Map<String, String> brokerProperties = context.brokerProperties(broker);
        for (TopicPlacement.ConstraintCount constraint : Utils.getAllConstraints(placement.get())) {
            if (!constraint.matches(brokerProperties)) continue;
            return true;
        }
        return false;
    }

    public static int getExpectedReplicaCount(TopicPlacement placement) {
        return placement.replicas().stream().mapToInt(TopicPlacement.ConstraintCount::count).sum();
    }

    static int getExpectedObserverCount(TopicPlacement placement) {
        return placement.observers().stream().mapToInt(TopicPlacement.ConstraintCount::count).sum();
    }

    static Map.Entry<List<Broker>, List<Broker>> partitionBrokers(MutableRebalanceContext context, Optional<TopicPlacement> topicPlacement, Collection<Broker> syncReplicas, Collection<Broker> observers) {
        List matchingSyncReplicas = syncReplicas.stream().filter(broker -> Utils.brokerMatchesReplicaPlacement(context, broker, topicPlacement)).collect(Collectors.toList());
        List matchingObservers = observers.stream().filter(broker -> Utils.brokerMatchesObserverPlacement(context, broker, topicPlacement)).collect(Collectors.toList());
        return new AbstractMap.SimpleEntry<List<Broker>, List<Broker>>(matchingSyncReplicas, matchingObservers);
    }

    public static Map<Broker, BrokerMetadata> brokersMap(Collection<BrokerMetadata> brokers) {
        return brokers.stream().collect(Collectors.toMap(md -> new Broker(md.id()), md -> md));
    }
}

