/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.databalancing.constraint;

import com.google.common.annotations.VisibleForTesting;
import io.confluent.kafka.databalancing.RebalanceContext;
import io.confluent.kafka.databalancing.Utils;
import io.confluent.kafka.databalancing.constraint.RebalanceConstraints;
import io.confluent.kafka.databalancing.topology.Broker;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.metadata.TopicPlacement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Constraints
implements RebalanceConstraints {
    private static final Logger logger = LoggerFactory.getLogger(Constraints.class);
    private final RebalanceContext context;
    private final String rack;
    private final int rackCount;

    public Constraints(RebalanceContext context, String rack) {
        this.context = context;
        this.rack = rack;
        this.rackCount = rack == null ? context.allRetainedRacks().size() : 1;
    }

    private <T> void replaceAddOrRemove(List<T> list, T toBeReplaced, T toReplace) {
        int index;
        int n = index = toBeReplaced == null ? -1 : list.indexOf(toBeReplaced);
        if (index != -1) {
            if (toReplace == null) {
                list.remove(index);
            } else {
                list.set(index, toReplace);
            }
        } else if (toReplace != null) {
            list.add(toReplace);
        }
    }

    @Override
    public boolean obeysRackConstraint(TopicPartition partition, Optional<TopicPlacement> placement, Broker brokerFrom, Broker brokerTo) {
        boolean result;
        if (brokerFrom == null && brokerTo == null) {
            throw new IllegalArgumentException("At least one of `brokerFrom` and `brokerTo` should not be null");
        }
        logger.debug("Checking rack constraint for moving partition {} from broker {} to broker {}.", new Object[]{partition, brokerFrom, brokerTo});
        ArrayList<Broker> proposedReplicas = new ArrayList<Broker>(this.context.brokers(partition, this.rack));
        if (placement.isPresent()) {
            result = this.rackMoveObeysPlacementConstraint(partition, placement, brokerFrom, brokerTo);
        } else {
            int minRacksSpanned = Math.min(this.context.replicationFactor(partition.topic()), this.rackCount);
            int currentRackSpanned = this.context.racks(proposedReplicas).size();
            this.replaceAddOrRemove(proposedReplicas, brokerFrom, brokerTo);
            int newRacksSpanned = this.context.racks(proposedReplicas).size();
            if (brokerFrom == null) {
                result = newRacksSpanned > currentRackSpanned || newRacksSpanned >= minRacksSpanned;
            } else {
                boolean bl = result = newRacksSpanned >= minRacksSpanned;
            }
        }
        if (!result) {
            logger.debug("failing rack constraint {}:{}, {} -> {} ", new Object[]{partition, proposedReplicas, brokerFrom, brokerTo});
        }
        return result;
    }

    @VisibleForTesting
    boolean rackMoveObeysPlacementConstraint(TopicPartition partition, Optional<TopicPlacement> placement, Broker brokerFrom, Broker brokerTo) {
        if (brokerFrom != null && brokerTo != null) {
            if (Utils.brokersMatchSameConstraint(this.context, brokerFrom, brokerTo, placement)) {
                logger.debug("For partition {} both broker (from {}, to {}) should match same placement constraint {}", new Object[]{partition, brokerFrom, brokerTo, placement.map(TopicPlacement::toJson).orElse("empty")});
                return true;
            }
            return false;
        }
        if (brokerFrom == null && !Utils.brokerMatchesAnyConstraint(this.context, brokerTo, placement)) {
            logger.debug("Broker {} doesn't match any placement constraint: {}", (Object)brokerTo, (Object)placement.map(TopicPlacement::toJson).orElse("empty"));
            return false;
        }
        return true;
    }

    @Override
    public boolean obeysPartitionConstraint(TopicPartition partition, Broker brokerTo) {
        boolean result;
        Objects.requireNonNull(brokerTo, "brokerTo should not be null");
        List<Broker> replicas = this.context.brokers(partition, this.rack);
        boolean bl = result = !replicas.contains(brokerTo);
        if (!result) {
            logger.debug("Failing partition constraint for {}:{} -> {}", new Object[]{partition, replicas, brokerTo});
        }
        return result;
    }

    @Override
    public boolean obeysDiskSpaceConstraint(TopicPartition partition, Broker brokerTo) {
        return this.obeysDiskSpaceConstraint(null, brokerTo, partition);
    }

    @Override
    public boolean obeysDiskSpaceConstraint(TopicPartition partitionToRemove, Broker broker, TopicPartition partitionToAdd) {
        boolean result;
        Double minFreeVolumeSpacePercentage = this.context.policyConfig().minFreeVolumeSpacePercentage();
        if (minFreeVolumeSpacePercentage == null || !this.context.hasBrokerSpaceInfo()) {
            return true;
        }
        double minFreeBytes = (double)this.context.brokerTotalBytes(broker).longValue() * (minFreeVolumeSpacePercentage / 100.0);
        long usableBytesAfterPartitionRemoval = partitionToRemove == null ? this.context.brokerUsableBytes(broker) : this.context.brokerUsableBytesAfterPartitionRemoval(broker, partitionToRemove);
        long remainingUsableBytes = usableBytesAfterPartitionRemoval - this.context.partitionSize(partitionToAdd);
        boolean bl = result = (double)remainingUsableBytes >= minFreeBytes;
        if (!result) {
            logger.debug("Failing disk space constraint for {} <- {} <- {}", new Object[]{partitionToRemove, broker, partitionToAdd});
        }
        return result;
    }
}

