/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.databalancing.topology;

import io.confluent.kafka.databalancing.ScalaUtils;
import io.confluent.kafka.databalancing.topology.Broker;
import io.confluent.kafka.databalancing.topology.ClusterReassignment;
import io.confluent.kafka.databalancing.topology.PartitionAssignment;
import io.confluent.kafka.databalancing.topology.PartitionReassignment;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import kafka.admin.ReassignPartitionsCommand;
import org.apache.kafka.clients.admin.NewPartitionReassignment;
import org.apache.kafka.common.TopicPartition;
import scala.collection.JavaConverters;
import scala.collection.Map;

public class ClusterAssignment {
    private final java.util.Map<TopicPartition, PartitionAssignment> underlying;

    public ClusterAssignment(java.util.Map<TopicPartition, PartitionAssignment> assignmentMap) {
        this.underlying = Objects.requireNonNull(assignmentMap, "assignmentMap cannot be null");
    }

    public ClusterAssignment cloneWithoutTopics(Set<String> topics) {
        HashMap<TopicPartition, PartitionAssignment> newUnderlying = new HashMap<TopicPartition, PartitionAssignment>(this.underlying.size());
        for (Map.Entry<TopicPartition, PartitionAssignment> entry : this.underlying.entrySet()) {
            if (topics.contains(entry.getKey().topic())) continue;
            newUnderlying.put(entry.getKey(), entry.getValue());
        }
        return new ClusterAssignment(newUnderlying);
    }

    public boolean isEmpty() {
        return this.underlying.isEmpty();
    }

    public java.util.Map<TopicPartition, PartitionAssignment> asMap() {
        return Collections.unmodifiableMap(this.underlying);
    }

    public java.util.Map<TopicPartition, NewPartitionReassignment> asNewPartitionReassignmentMap() {
        HashMap<TopicPartition, NewPartitionReassignment> ret = new HashMap<TopicPartition, NewPartitionReassignment>(this.underlying.size());
        for (Map.Entry<TopicPartition, PartitionAssignment> entry : this.underlying.entrySet()) {
            TopicPartition tp = entry.getKey();
            PartitionAssignment assignment = entry.getValue();
            ret.put(tp, NewPartitionReassignment.ofReplicasAndObservers(assignment.replicaIds(), assignment.observerIds()));
        }
        return ret;
    }

    public Collection<Broker> brokers() {
        HashSet<Broker> result = new HashSet<Broker>();
        for (PartitionAssignment assignment : this.underlying.values()) {
            result.addAll(assignment.replicas);
        }
        return result;
    }

    public Collection<String> topics() {
        HashSet<String> result = new HashSet<String>();
        for (TopicPartition partition : this.underlying.keySet()) {
            result.add(partition.topic());
        }
        return result;
    }

    public Collection<Integer> partitionsForTopic(String topic) {
        ArrayList<Integer> result = new ArrayList<Integer>();
        for (TopicPartition tp : this.underlying.keySet()) {
            if (!tp.topic().equals(topic)) continue;
            result.add(tp.partition());
        }
        return result;
    }

    public java.util.Map<Broker, Collection<TopicPartition>> brokerToLeaders() {
        HashMap<Broker, Collection<TopicPartition>> result = new HashMap<Broker, Collection<TopicPartition>>();
        for (Map.Entry<TopicPartition, PartitionAssignment> entry : this.underlying.entrySet()) {
            PartitionAssignment assignment = entry.getValue();
            assignment.preferredLeader().ifPresent(leader -> {
                Collection partitions = result.computeIfAbsent((Broker)leader, broker -> new ArrayList());
                partitions.add(entry.getKey());
            });
        }
        return result;
    }

    public java.util.Map<Broker, Collection<TopicPartition>> brokerToReplicas() {
        HashMap<Broker, Collection<TopicPartition>> result = new HashMap<Broker, Collection<TopicPartition>>();
        for (Map.Entry<TopicPartition, PartitionAssignment> entry : this.underlying.entrySet()) {
            for (Broker broker : entry.getValue().replicas) {
                Collection partitions = result.computeIfAbsent(broker, b -> new ArrayList());
                partitions.add(entry.getKey());
            }
        }
        return result;
    }

    public String toJson() {
        return ReassignPartitionsCommand.formatAsReassignmentJson(ScalaUtils.assignmentToScalaMap(this.underlying), (Map)JavaConverters.mapAsScalaMap(new HashMap()));
    }

    public Set<TopicPartition> topicPartitions() {
        return Collections.unmodifiableSet(this.underlying.keySet());
    }

    public PartitionAssignment assignment(TopicPartition topicPartition) {
        return this.underlying.get(topicPartition);
    }

    public List<Integer> replicas(TopicPartition topicPartition) {
        PartitionAssignment assignment = this.underlying.get(topicPartition);
        return assignment == null ? Collections.emptyList() : Collections.unmodifiableList(assignment.replicaIds());
    }

    public ClusterReassignment reassignTo(ClusterAssignment assignment) {
        HashMap<TopicPartition, PartitionReassignment> reassignments = new HashMap<TopicPartition, PartitionReassignment>(this.underlying.size());
        for (Map.Entry<TopicPartition, PartitionAssignment> entry : this.underlying.entrySet()) {
            TopicPartition tp = entry.getKey();
            PartitionAssignment current = entry.getValue();
            PartitionAssignment proposed = assignment.underlying.get(tp);
            if (proposed == null || Objects.equals(current, proposed)) continue;
            reassignments.put(tp, new PartitionReassignment(current.replicaIds(), proposed.replicaIds()));
        }
        return new ClusterReassignment(reassignments);
    }

    public java.util.Map<String, Integer> replicationFactors() {
        HashMap<String, Integer> result = new HashMap<String, Integer>();
        for (Map.Entry<TopicPartition, PartitionAssignment> entry : this.underlying.entrySet()) {
            String topic = entry.getKey().topic();
            if (result.containsKey(topic)) continue;
            int replicaCount = entry.getValue().replicas.size();
            result.put(topic, replicaCount);
        }
        return result;
    }

    public int size() {
        return this.underlying.size();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ClusterAssignment that = (ClusterAssignment)o;
        return this.underlying.equals(that.underlying);
    }

    public int hashCode() {
        return this.underlying.hashCode();
    }

    public String toString() {
        return "ClusterAssignment(" + this.underlying + ")";
    }
}

