/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.databalancing.topology;

import io.confluent.kafka.databalancing.topology.Broker;
import java.util.Objects;
import java.util.Optional;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.metadata.TopicPlacement;

public class Replica {
    private final TopicPartition topicPartition;
    private final Optional<TopicPlacement> topicPlacement;
    private final Broker broker;

    public Replica(TopicPartition topicPartition, Optional<TopicPlacement> topicPlacement, Broker broker) {
        this.topicPartition = Objects.requireNonNull(topicPartition, "topicPartition should not be null");
        this.topicPlacement = topicPlacement;
        this.broker = Objects.requireNonNull(broker, "broker should not be null");
    }

    public Broker broker() {
        return this.broker;
    }

    public TopicPartition topicPartition() {
        return this.topicPartition;
    }

    public Optional<TopicPlacement> topicPlacement() {
        return this.topicPlacement;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Replica replica = (Replica)o;
        return this.broker.equals(replica.broker) && this.topicPartition.equals((Object)replica.topicPartition);
    }

    public int hashCode() {
        int result = this.topicPartition.hashCode();
        result = 31 * result + this.broker.hashCode();
        return result;
    }

    public String toString() {
        return "(partition=" + this.topicPartition + ", replica=" + this.broker.id() + ")";
    }
}

