/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.databalancing.view;

import io.confluent.kafka.databalancing.RebalanceContext;
import io.confluent.kafka.databalancing.fairness.FirstObserverCountFairness;
import io.confluent.kafka.databalancing.fairness.FirstObserverFairness;
import io.confluent.kafka.databalancing.fairness.LeaderCountFairness;
import io.confluent.kafka.databalancing.fairness.LeaderFairness;
import io.confluent.kafka.databalancing.fairness.ReplicaCountFairness;
import io.confluent.kafka.databalancing.fairness.ReplicaFairness;
import io.confluent.kafka.databalancing.topology.Broker;
import io.confluent.kafka.databalancing.topology.Replica;
import io.confluent.kafka.databalancing.topology.TopologyUtils;
import io.confluent.kafka.databalancing.view.BrokerFairView;
import io.confluent.kafka.databalancing.view.ClusterView;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.kafka.common.TopicPartition;

public class BrokerCountFairView
extends BrokerFairView {
    public BrokerCountFairView(RebalanceContext context, String rack, String topic) {
        super(context, rack, topic);
    }

    @Override
    protected List<TopicPartition> createLeadersOnAboveParBrokers(RebalanceContext context, LeaderFairness fairness, String topic) {
        return TopologyUtils.leaders(context, fairness.aboveParBrokers(), topic);
    }

    @Override
    protected List<Replica> createReplicasOnAboveParBrokers(RebalanceContext context, ReplicaFairness fairness, String topic) {
        return TopologyUtils.interleavedReplicas(context, fairness.aboveParBrokers(), topic);
    }

    @Override
    protected List<Replica> createFirstObserversOnAboveParBrokers(RebalanceContext context, FirstObserverFairness fairness, String topic) {
        List<Broker> firstObserverAboveParBrokers = fairness.aboveParBrokers();
        HashMap brokerToFirstObserverMap = new HashMap();
        for (Broker broker : firstObserverAboveParBrokers) {
            List firstObserverTopicPartitions = context.firstObservers(broker).stream().filter(topicPartition -> topic == null || topicPartition.topic().equals(topic)).collect(Collectors.toList());
            brokerToFirstObserverMap.put(broker, firstObserverTopicPartitions);
        }
        return brokerToFirstObserverMap.entrySet().stream().flatMap(entry -> ((List)entry.getValue()).stream().map(tp -> new Replica((TopicPartition)tp, context.topicPlacement(tp.topic()), (Broker)entry.getKey()))).collect(Collectors.toList());
    }

    @Override
    public ClusterView refresh(RebalanceContext context) {
        return new BrokerCountFairView(context, this.rack, this.topic);
    }

    @Override
    protected ReplicaFairness createReplicaFairness(RebalanceContext context, String rack, String topic) {
        return new ReplicaCountFairness(context, rack, topic);
    }

    @Override
    protected LeaderFairness createLeaderFairness(RebalanceContext context, String rack, String topic) {
        return new LeaderCountFairness(context, rack, topic);
    }

    @Override
    protected FirstObserverFairness createFirstObserverFairness(RebalanceContext context, String rack, String topic) {
        return new FirstObserverCountFairness(context, rack, topic);
    }
}

