/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.databalancing.view;

import io.confluent.kafka.databalancing.CompareResult;
import io.confluent.kafka.databalancing.RebalanceContext;
import io.confluent.kafka.databalancing.constraint.Constraints;
import io.confluent.kafka.databalancing.constraint.RebalanceConstraints;
import io.confluent.kafka.databalancing.fairness.FirstObserverFairness;
import io.confluent.kafka.databalancing.fairness.LeaderFairness;
import io.confluent.kafka.databalancing.fairness.ReplicaFairness;
import io.confluent.kafka.databalancing.topology.Broker;
import io.confluent.kafka.databalancing.topology.Replica;
import io.confluent.kafka.databalancing.view.ClusterView;
import java.util.Collections;
import java.util.List;
import org.apache.kafka.common.TopicPartition;

public abstract class BrokerFairView
implements ClusterView {
    protected final RebalanceContext context;
    protected final String rack;
    protected final String topic;
    private final ReplicaFairness replicaFairness;
    private final LeaderFairness leaderFairness;
    private final FirstObserverFairness firstObserverFairness;
    private final Constraints constraints;
    private List<TopicPartition> leadersOnAboveParBrokers;
    private List<Replica> replicasOnAboveParBrokers;
    private List<Replica> firstObserversOnAboveParBrokers;

    public BrokerFairView(RebalanceContext context, String rack, String topic) {
        this.context = context;
        this.rack = rack;
        this.topic = topic;
        this.replicaFairness = this.createReplicaFairness(this.context, rack, topic);
        this.leaderFairness = this.createLeaderFairness(this.context, rack, topic);
        this.firstObserverFairness = this.createFirstObserverFairness(this.context, rack, topic);
        this.constraints = new Constraints(this.context, rack);
    }

    protected abstract List<TopicPartition> createLeadersOnAboveParBrokers(RebalanceContext var1, LeaderFairness var2, String var3);

    protected abstract List<Replica> createReplicasOnAboveParBrokers(RebalanceContext var1, ReplicaFairness var2, String var3);

    protected abstract List<Replica> createFirstObserversOnAboveParBrokers(RebalanceContext var1, FirstObserverFairness var2, String var3);

    protected abstract ReplicaFairness createReplicaFairness(RebalanceContext var1, String var2, String var3);

    protected abstract LeaderFairness createLeaderFairness(RebalanceContext var1, String var2, String var3);

    protected abstract FirstObserverFairness createFirstObserverFairness(RebalanceContext var1, String var2, String var3);

    @Override
    public CompareResult compareLeaderFairness(TopicPartition topicPartition, Broker b1, Broker b2) {
        return this.leaderFairness.compareBrokerFairness(topicPartition, b1, b2);
    }

    @Override
    public CompareResult compareFirstObserverFairness(TopicPartition topicPartition, Broker b1, Broker b2) {
        return this.firstObserverFairness.compareBrokerFairness(topicPartition, b1, b2);
    }

    @Override
    public CompareResult compareReplicaFairness(TopicPartition topicPartition, Broker b1, Broker b2) {
        return this.replicaFairness.compareBrokerFairness(topicPartition, b1, b2);
    }

    @Override
    public CompareResult compareReplicaFairness(Broker b1, TopicPartition tp1, Broker b2, TopicPartition tp2) {
        return this.replicaFairness.compareBrokerFairness(b1, tp1, b2, tp2);
    }

    @Override
    public List<Replica> replicasOnAboveParBrokers() {
        if (this.replicasOnAboveParBrokers == null) {
            this.replicasOnAboveParBrokers = Collections.unmodifiableList(this.createReplicasOnAboveParBrokers(this.context, this.replicaFairness, this.topic));
        }
        return this.replicasOnAboveParBrokers;
    }

    @Override
    public List<Broker> brokersWithBelowParReplicaFairness() {
        return this.replicaFairness.belowParBrokers();
    }

    public List<Broker> brokersWithBelowParFirstObserverFairness() {
        return this.firstObserverFairness.belowParBrokers();
    }

    public List<Replica> firstObserversOnAboveParBrokers() {
        if (this.firstObserversOnAboveParBrokers == null) {
            this.firstObserversOnAboveParBrokers = Collections.unmodifiableList(this.createFirstObserversOnAboveParBrokers(this.context, this.firstObserverFairness, this.topic));
        }
        return this.firstObserversOnAboveParBrokers;
    }

    @Override
    public List<TopicPartition> leadersOnAboveParBrokers() {
        if (this.leadersOnAboveParBrokers == null) {
            this.leadersOnAboveParBrokers = Collections.unmodifiableList(this.createLeadersOnAboveParBrokers(this.context, this.leaderFairness, this.topic));
        }
        return this.leadersOnAboveParBrokers;
    }

    @Override
    public List<Broker> brokersWithBelowParLeaderFairness() {
        return this.leaderFairness.belowParBrokers();
    }

    @Override
    public RebalanceConstraints constraints() {
        return this.constraints;
    }

    public ReplicaFairness replicaFairness() {
        return this.replicaFairness;
    }

    public LeaderFairness leaderFairness() {
        return this.leaderFairness;
    }

    public FirstObserverFairness firstObserverFairness() {
        return this.firstObserverFairness;
    }
}

