/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.databalancing.view;

import io.confluent.kafka.databalancing.RebalanceContext;
import io.confluent.kafka.databalancing.fairness.BaseFairness;
import io.confluent.kafka.databalancing.fairness.FirstObserverFairness;
import io.confluent.kafka.databalancing.fairness.FirstObserverSizeFairness;
import io.confluent.kafka.databalancing.fairness.LeaderFairness;
import io.confluent.kafka.databalancing.fairness.LeaderSizeFairness;
import io.confluent.kafka.databalancing.fairness.ReplicaFairness;
import io.confluent.kafka.databalancing.fairness.ReplicaSizeFairness;
import io.confluent.kafka.databalancing.topology.Broker;
import io.confluent.kafka.databalancing.topology.Replica;
import io.confluent.kafka.databalancing.topology.TopologyUtils;
import io.confluent.kafka.databalancing.view.BrokerFairView;
import io.confluent.kafka.databalancing.view.ClusterView;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.kafka.common.TopicPartition;

public class BrokerSizeFairView
extends BrokerFairView {
    public BrokerSizeFairView(RebalanceContext context, String rack, String topic) {
        super(context, rack, topic);
    }

    @Override
    protected List<TopicPartition> createLeadersOnAboveParBrokers(RebalanceContext context, LeaderFairness fairness, String topic) {
        ArrayList<TopicPartition> result = new ArrayList<TopicPartition>();
        for (Broker broker : fairness.aboveParBrokers()) {
            List<TopicPartition> leaders = BrokerSizeFairView.createSortedBrokerLeaders(context, fairness, broker, topic, context.leaders(broker));
            result.addAll(leaders);
        }
        return result;
    }

    private static List<TopicPartition> createSortedBrokerLeaders(final RebalanceContext context, LeaderFairness fairness, Broker broker, String topic, List<TopicPartition> brokerPartitions) {
        ArrayList<TopicPartition> sorted = new ArrayList<TopicPartition>();
        for (TopicPartition topicPartition : brokerPartitions) {
            if (topic != null && !topicPartition.topic().equals(topic)) continue;
            sorted.add(topicPartition);
        }
        final double deviation = (double)context.brokerTopicLeadersSize(broker, topic) - fairness.brokerFairValue();
        Collections.sort(sorted, new Comparator<TopicPartition>(){

            @Override
            public int compare(TopicPartition tp1, TopicPartition tp2) {
                long c1 = context.partitionSize(tp1);
                long c2 = context.partitionSize(tp2);
                int result = Double.compare(Math.abs((double)c1 - deviation), Math.abs((double)c2 - deviation));
                if (result != 0) {
                    return result;
                }
                if (c1 != c2) {
                    return Long.compare(c1, c2);
                }
                return TopologyUtils.topicPartitionComparator.compare(tp1, tp2);
            }
        });
        return sorted;
    }

    @Override
    protected List<Replica> createReplicasOnAboveParBrokers(RebalanceContext context, ReplicaFairness fairness, String topic) {
        ArrayList<Replica> result = new ArrayList<Replica>();
        for (Broker broker : fairness.aboveParBrokers()) {
            List<Replica> replicas = BrokerSizeFairView.createSortedBrokerReplicas(context, fairness, broker, topic, context.replicas(broker));
            result.addAll(replicas);
        }
        return result;
    }

    @Override
    protected List<Replica> createFirstObserversOnAboveParBrokers(RebalanceContext context, FirstObserverFairness fairness, String topic) {
        ArrayList<Replica> result = new ArrayList<Replica>();
        for (Broker broker : fairness.aboveParBrokers()) {
            List<Replica> replicas = BrokerSizeFairView.createSortedBrokerReplicas(context, fairness, broker, topic, context.firstObservers(broker));
            result.addAll(replicas);
        }
        return result;
    }

    private static List<Replica> createSortedBrokerReplicas(final RebalanceContext context, BaseFairness fairness, Broker broker, String topic, List<TopicPartition> brokerPartitions) {
        ArrayList<Replica> replicas = new ArrayList<Replica>();
        for (TopicPartition topicPartition : brokerPartitions) {
            if (topic != null && !topicPartition.topic().equals(topic)) continue;
            Replica replica = new Replica(topicPartition, context.topicPlacement(topicPartition.topic()), broker);
            replicas.add(replica);
        }
        final double deviation = (double)context.brokerTopicSize(broker, topic) - fairness.brokerFairValue();
        Collections.sort(replicas, new Comparator<Replica>(){

            @Override
            public int compare(Replica r1, Replica r2) {
                TopicPartition tp1 = r1.topicPartition();
                TopicPartition tp2 = r2.topicPartition();
                long c1 = context.partitionSize(tp1);
                long c2 = context.partitionSize(tp2);
                int result = Double.compare(Math.abs((double)c1 - deviation), Math.abs((double)c2 - deviation));
                if (result != 0) {
                    return result;
                }
                if (c1 != c2) {
                    return Long.compare(c1, c2);
                }
                return TopologyUtils.topicPartitionComparator.compare(tp1, tp2);
            }
        });
        return replicas;
    }

    @Override
    public ClusterView refresh(RebalanceContext context) {
        return new BrokerSizeFairView(context, this.rack, this.topic);
    }

    @Override
    protected ReplicaFairness createReplicaFairness(RebalanceContext context, String rack, String topic) {
        return new ReplicaSizeFairness(context, rack, topic);
    }

    @Override
    protected LeaderFairness createLeaderFairness(RebalanceContext context, String rack, String topic) {
        return new LeaderSizeFairness(context, rack, topic);
    }

    @Override
    protected FirstObserverFairness createFirstObserverFairness(RebalanceContext context, String rack, String topic) {
        return new FirstObserverSizeFairness(context, rack, topic);
    }
}

