/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.databalancing.view;

import io.confluent.kafka.databalancing.RebalanceContext;
import io.confluent.kafka.databalancing.fairness.FirstObserverCountFairness;
import io.confluent.kafka.databalancing.fairness.FirstObserverFairness;
import io.confluent.kafka.databalancing.fairness.LeaderCountFairness;
import io.confluent.kafka.databalancing.fairness.LeaderFairness;
import io.confluent.kafka.databalancing.fairness.ReplicaCountFairness;
import io.confluent.kafka.databalancing.fairness.ReplicaFairness;
import io.confluent.kafka.databalancing.topology.Broker;
import io.confluent.kafka.databalancing.topology.Replica;
import io.confluent.kafka.databalancing.topology.TopologyUtils;
import io.confluent.kafka.databalancing.view.ClusterView;
import io.confluent.kafka.databalancing.view.RackFairView;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.kafka.common.TopicPartition;

public class RackCountFairView
extends RackFairView {
    public RackCountFairView(RebalanceContext context, String topic) {
        super(context, topic);
    }

    @Override
    protected List<TopicPartition> createLeadersOnAboveParRacks(RebalanceContext context, LeaderFairness fairness, String topic) {
        ArrayList<TopicPartition> result = new ArrayList<TopicPartition>();
        for (String rack : fairness.aboveParRacks()) {
            List<Broker> brokers = TopologyUtils.sortBrokersByLeaderCount(context, TopologyUtils.availableBrokersOnRack(context, rack), topic);
            Collections.reverse(brokers);
            result.addAll(TopologyUtils.leaders(context, brokers, topic));
        }
        return result;
    }

    @Override
    protected List<Replica> createReplicasOnAboveParRacks(RebalanceContext context, ReplicaFairness fairness, String topic) {
        ArrayList<Replica> result = new ArrayList<Replica>();
        for (String rack : fairness.aboveParRacks()) {
            List<Broker> brokers = TopologyUtils.sortBrokersByReplicaCount(context, TopologyUtils.availableBrokersOnRack(context, rack), topic);
            Collections.reverse(brokers);
            result.addAll(TopologyUtils.interleavedReplicas(context, brokers, topic));
        }
        return result;
    }

    @Override
    protected List<Broker> createBrokersWithBelowParLeaderMetric(RebalanceContext context, LeaderFairness fairness, String topic) {
        ArrayList<Broker> result = new ArrayList<Broker>();
        for (String rack : fairness.belowParRacks()) {
            result.addAll(TopologyUtils.sortBrokersByLeaderCount(context, TopologyUtils.availableBrokersOnRack(context, rack), topic));
        }
        return result;
    }

    @Override
    protected List<Broker> createBrokersWithBelowParReplicaMetric(RebalanceContext context, ReplicaFairness fairness, String topic) {
        ArrayList<Broker> result = new ArrayList<Broker>();
        for (String rack : fairness.belowParRacks()) {
            result.addAll(TopologyUtils.sortBrokersByReplicaCount(context, TopologyUtils.availableBrokersOnRack(context, rack), topic));
        }
        return result;
    }

    @Override
    protected ReplicaFairness createReplicaFairness(RebalanceContext context, String topic) {
        return new ReplicaCountFairness(context, null, topic);
    }

    @Override
    protected FirstObserverFairness createFirstObserverFairness(RebalanceContext context, String topic) {
        return new FirstObserverCountFairness(context, null, topic);
    }

    @Override
    protected LeaderFairness createLeaderFairness(RebalanceContext context, String topic) {
        return new LeaderCountFairness(context, null, topic);
    }

    @Override
    public ClusterView refresh(RebalanceContext context) {
        return new RackCountFairView(context, this.topic);
    }
}

