/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.databalancing.view;

import io.confluent.kafka.databalancing.RebalanceContext;
import io.confluent.kafka.databalancing.view.BrokerCountFairView;
import io.confluent.kafka.databalancing.view.BrokerFairView;
import io.confluent.kafka.databalancing.view.BrokerSizeFairView;
import io.confluent.kafka.databalancing.view.ClusterView;
import io.confluent.kafka.databalancing.view.RackCountFairView;
import io.confluent.kafka.databalancing.view.RackFairView;
import io.confluent.kafka.databalancing.view.RackSizeFairView;
import java.util.HashMap;
import java.util.Map;

public abstract class TopicViewSupplier<V extends ClusterView> {
    private final Map<String, V> topicToView = new HashMap<String, V>();

    public static TopicViewSupplier<BrokerFairView> brokerCount(final RebalanceContext context, final String rack) {
        return new TopicViewSupplier<BrokerFairView>(){

            @Override
            public BrokerFairView create(String topic) {
                return new BrokerCountFairView(context, rack, topic);
            }
        };
    }

    public static TopicViewSupplier<BrokerFairView> brokerSize(final RebalanceContext context, final String rack) {
        return new TopicViewSupplier(){

            public BrokerFairView create(String topic) {
                return new BrokerSizeFairView(context, rack, topic);
            }
        };
    }

    public static TopicViewSupplier<RackFairView> rackCount(final RebalanceContext context) {
        return new TopicViewSupplier(){

            public RackFairView create(String topic) {
                return new RackCountFairView(context, topic);
            }
        };
    }

    public static TopicViewSupplier<RackFairView> rackSize(final RebalanceContext context) {
        return new TopicViewSupplier(){

            public RackFairView create(String topic) {
                return new RackSizeFairView(context, topic);
            }
        };
    }

    public V get(String topic) {
        ClusterView view = (ClusterView)this.topicToView.get(topic);
        if (view == null) {
            view = this.create(topic);
            this.topicToView.put(topic, view);
        }
        return (V)view;
    }

    public void clear() {
        this.topicToView.clear();
    }

    protected abstract V create(String var1);
}

