/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.security.authentication.oidc;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jdk8.Jdk8Module;
import com.fasterxml.jackson.jaxrs.json.JacksonJaxbJsonProvider;
import io.confluent.security.authentication.oidc.CachedGrant;
import io.confluent.security.authentication.oidc.ClientCredentials;
import io.confluent.security.authentication.oidc.GrantBase;
import io.confluent.security.authentication.oidc.MetadataResponse;
import io.confluent.security.authentication.oidc.TokenError;
import io.confluent.security.authentication.oidc.TokenResponse;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.Calendar;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.net.ssl.SSLContext;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.Entity;
import javax.ws.rs.core.Form;
import javax.ws.rs.core.Response;

public class OpenIdClient {
    static final String METADATA_PATH = ".well-known/openid-configuration";
    private static final String CLIENT_SECRET_BASIC_PREFIX = "Basic";
    private final Client client;
    private final Supplier<ClientCredentials> credentialsSupplier;
    private final Function<ClientCredentials, String> authMethod;
    private final ObjectMapper objectMapper;
    private final MetadataResponse providerMetadata;
    private final Calendar calendar;
    private CachedGrant cachedClientCredentialsGrant;

    private OpenIdClient(Client client, Supplier<ClientCredentials> credentialsSupplier, Function<ClientCredentials, String> authMethod, MetadataResponse providerMetadata, ObjectMapper objectMapper, Calendar calendar) {
        this.client = client;
        this.credentialsSupplier = credentialsSupplier;
        this.authMethod = authMethod;
        this.objectMapper = objectMapper;
        this.providerMetadata = providerMetadata;
        this.calendar = calendar;
        this.cachedClientCredentialsGrant = null;
    }

    public void handleGrant(GrantBase grant) {
        switch (grant.getTokenRequest().grantType()) {
            case CLIENT_CREDENTIALS: {
                this.handleCredentialsGrant(grant);
            }
        }
    }

    private void handleCredentialsGrant(GrantBase grant) {
        if (this.cachedClientCredentialsGrant != null && !this.cachedClientCredentialsGrant.isExpired()) {
            grant.setTokenResponse(TokenResponse.fromCachedEntry(this.cachedClientCredentialsGrant));
            return;
        }
        Response response = this.client.target(this.providerMetadata.tokenEndpoint()).request(new String[]{"application/x-www-form-urlencoded"}).accept(new String[]{"application/json"}).header("Authorization", (Object)this.authMethod.apply(this.credentialsSupplier.get())).post(this.formEncoder(grant.getTokenRequest()));
        this.handleResponse(grant, response);
        if (grant.getTokenResponse() != null) {
            this.cachedClientCredentialsGrant = CachedGrant.fromTokenResponse(grant.getTokenResponse(), this.calendar);
        }
    }

    private void handleResponse(GrantBase grant, Response response) {
        Response.Status.Family statusFamily = response.getStatusInfo().getFamily();
        if (statusFamily == Response.Status.Family.SUCCESSFUL) {
            grant.setTokenResponse((TokenResponse)response.readEntity(TokenResponse.class));
            return;
        }
        if (statusFamily == Response.Status.Family.REDIRECTION) {
            System.out.println("Redirecting to " + response.getLocation());
        }
        if (statusFamily == Response.Status.Family.CLIENT_ERROR) {
            grant.setTokenError((TokenError)response.readEntity(TokenError.class));
        }
    }

    private <T> Entity<Form> formEncoder(T obj) {
        Map params = (Map)this.objectMapper.convertValue(obj, (TypeReference)new TypeReference<Map<String, String>>(){});
        Form grantForm = new Form();
        for (Map.Entry entry : params.entrySet()) {
            grantForm.param((String)entry.getKey(), (String)entry.getValue());
        }
        return Entity.form((Form)grantForm);
    }

    private static String clientSecretBasic(ClientCredentials credentials) {
        String userInfo = String.join((CharSequence)":", credentials.getClientId(), credentials.getClientSecret());
        return String.join((CharSequence)" ", CLIENT_SECRET_BASIC_PREFIX, Base64.getEncoder().encodeToString(userInfo.getBytes(StandardCharsets.UTF_8)));
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private Client client;
        private String metadataEndpoint;
        private ObjectMapper objectMapper;
        private Function<ClientCredentials, String> authMethod;
        private Supplier<ClientCredentials> credentialsSupplier;
        private SSLContext sslContext;
        private Calendar calendar;

        public Builder client(Client client) {
            this.client = client;
            return this;
        }

        public Builder issuer(String issuer) {
            this.metadataEndpoint = String.join((CharSequence)"/", issuer.replaceAll("/$", ""), OpenIdClient.METADATA_PATH);
            return this;
        }

        public Builder credentialsSupplier(Supplier<ClientCredentials> credentialsSupplier) {
            this.credentialsSupplier = credentialsSupplier;
            return this;
        }

        public Builder authMethod(Function<ClientCredentials, String> authMethod) {
            this.authMethod = authMethod;
            return this;
        }

        public Builder objectMapper(ObjectMapper objectMapper) {
            this.objectMapper = objectMapper;
            return this;
        }

        private ObjectMapper objectMapper() {
            if (this.objectMapper != null) {
                return this.objectMapper;
            }
            return new ObjectMapper().configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false).enable(DeserializationFeature.READ_ENUMS_USING_TO_STRING).registerModule((Module)new Jdk8Module());
        }

        public Builder sslContext(SSLContext context) {
            this.sslContext = context;
            return this;
        }

        public Builder calendar(Calendar calendar) {
            this.calendar = calendar;
            return this;
        }

        public OpenIdClient build() {
            this.objectMapper = this.objectMapper();
            ClientBuilder clientBuilder = ClientBuilder.newBuilder();
            if (this.sslContext != null) {
                clientBuilder.sslContext(this.sslContext);
            }
            if (this.client == null) {
                this.client = (Client)clientBuilder.build().register((Object)new JacksonJaxbJsonProvider(this.objectMapper, JacksonJaxbJsonProvider.DEFAULT_ANNOTATIONS));
            }
            try {
                MetadataResponse providerMetadata = (MetadataResponse)this.objectMapper.readValue(new URL(this.metadataEndpoint), MetadataResponse.class);
                return new OpenIdClient(this.client, this.credentialsSupplier, this.authMethod == null ? x$0 -> OpenIdClient.clientSecretBasic(x$0) : this.authMethod, providerMetadata, this.objectMapper, this.calendar == null ? Calendar.getInstance() : this.calendar);
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to obtain OpenId Provider metadata", e);
            }
        }
    }
}

