/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.consumer.internals;

import java.util.Collections;
import java.util.Objects;
import java.util.Optional;
import org.apache.kafka.clients.consumer.internals.ErrorEventHandler;
import org.apache.kafka.clients.consumer.internals.NetworkClientDelegate;
import org.apache.kafka.clients.consumer.internals.RequestManager;
import org.apache.kafka.clients.consumer.internals.RequestState;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.errors.GroupAuthorizationException;
import org.apache.kafka.common.errors.RetriableException;
import org.apache.kafka.common.message.FindCoordinatorRequestData;
import org.apache.kafka.common.message.FindCoordinatorResponseData;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.FindCoordinatorRequest;
import org.apache.kafka.common.requests.FindCoordinatorResponse;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.Time;
import org.slf4j.Logger;

public class CoordinatorRequestManager
implements RequestManager {
    private static final long COORDINATOR_DISCONNECT_LOGGING_INTERVAL_MS = 60000L;
    private final Time time;
    private final Logger log;
    private final ErrorEventHandler nonRetriableErrorHandler;
    private final String groupId;
    private final RequestState coordinatorRequestState;
    private long timeMarkedUnknownMs = -1L;
    private long totalDisconnectedMin = 0L;
    private Node coordinator;

    public CoordinatorRequestManager(Time time, LogContext logContext, long retryBackoffMs, ErrorEventHandler errorHandler, String groupId) {
        Objects.requireNonNull(groupId);
        this.time = time;
        this.log = logContext.logger(this.getClass());
        this.nonRetriableErrorHandler = errorHandler;
        this.groupId = groupId;
        this.coordinatorRequestState = new RequestState(logContext, CoordinatorRequestManager.class.getSimpleName(), retryBackoffMs);
    }

    @Override
    public NetworkClientDelegate.PollResult poll(long currentTimeMs) {
        if (this.coordinator != null) {
            return new NetworkClientDelegate.PollResult(Long.MAX_VALUE, Collections.emptyList());
        }
        if (this.coordinatorRequestState.canSendRequest(currentTimeMs)) {
            NetworkClientDelegate.UnsentRequest request = this.makeFindCoordinatorRequest(currentTimeMs);
            return new NetworkClientDelegate.PollResult(Long.MAX_VALUE, Collections.singletonList(request));
        }
        return new NetworkClientDelegate.PollResult(this.coordinatorRequestState.remainingBackoffMs(currentTimeMs), Collections.emptyList());
    }

    private NetworkClientDelegate.UnsentRequest makeFindCoordinatorRequest(long currentTimeMs) {
        this.coordinatorRequestState.onSendAttempt(currentTimeMs);
        FindCoordinatorRequestData data = new FindCoordinatorRequestData().setKeyType(FindCoordinatorRequest.CoordinatorType.GROUP.id()).setKey(this.groupId);
        NetworkClientDelegate.UnsentRequest unsentRequest = new NetworkClientDelegate.UnsentRequest(new FindCoordinatorRequest.Builder(data), Optional.empty());
        unsentRequest.future().whenComplete((clientResponse, throwable) -> {
            long responseTimeMs = this.time.milliseconds();
            if (clientResponse != null) {
                FindCoordinatorResponse response = (FindCoordinatorResponse)clientResponse.responseBody();
                this.onResponse(responseTimeMs, response);
            } else {
                this.onFailedResponse(responseTimeMs, (Throwable)throwable);
            }
        });
        return unsentRequest;
    }

    public void markCoordinatorUnknown(String cause, long currentTimeMs) {
        if (this.coordinator != null) {
            this.log.info("Group coordinator {} is unavailable or invalid due to cause: {}. Rediscovery will be attempted.", (Object)this.coordinator, (Object)cause);
            this.coordinator = null;
            this.timeMarkedUnknownMs = currentTimeMs;
            this.totalDisconnectedMin = 0L;
        } else {
            long durationOfOngoingDisconnectMs = Math.max(0L, currentTimeMs - this.timeMarkedUnknownMs);
            long currDisconnectMin = durationOfOngoingDisconnectMs / 60000L;
            if (currDisconnectMin > this.totalDisconnectedMin) {
                this.log.debug("Consumer has been disconnected from the group coordinator for {}ms", (Object)durationOfOngoingDisconnectMs);
                this.totalDisconnectedMin = currDisconnectMin;
            }
        }
    }

    private void onSuccessfulResponse(long currentTimeMs, FindCoordinatorResponseData.Coordinator coordinator) {
        int coordinatorConnectionId = Integer.MAX_VALUE - coordinator.nodeId();
        this.coordinator = new Node(coordinatorConnectionId, coordinator.host(), coordinator.port());
        this.log.info("Discovered group coordinator {}", (Object)coordinator);
        this.coordinatorRequestState.onSuccessfulAttempt(currentTimeMs);
    }

    private void onFailedResponse(long currentTimeMs, Throwable exception) {
        this.coordinatorRequestState.onFailedAttempt(currentTimeMs);
        this.markCoordinatorUnknown("FindCoordinator failed with exception", currentTimeMs);
        if (exception instanceof RetriableException) {
            this.log.debug("FindCoordinator request failed due to retriable exception", exception);
            return;
        }
        if (exception == Errors.GROUP_AUTHORIZATION_FAILED.exception()) {
            this.log.debug("FindCoordinator request failed due to authorization error {}", (Object)exception.getMessage());
            this.nonRetriableErrorHandler.handle(GroupAuthorizationException.forGroupId(this.groupId));
            return;
        }
        this.log.warn("FindCoordinator request failed due to fatal exception", exception);
        this.nonRetriableErrorHandler.handle(exception);
    }

    private void onResponse(long currentTimeMs, FindCoordinatorResponse response) {
        Optional<FindCoordinatorResponseData.Coordinator> coordinator = response.coordinatorByKey(this.groupId);
        if (!coordinator.isPresent()) {
            String msg = String.format("Response did not contain expected coordinator section for groupId: %s", this.groupId);
            this.onFailedResponse(currentTimeMs, new IllegalStateException(msg));
            return;
        }
        FindCoordinatorResponseData.Coordinator node = coordinator.get();
        if (node.errorCode() != Errors.NONE.code()) {
            this.onFailedResponse(currentTimeMs, Errors.forCode(node.errorCode()).exception());
            return;
        }
        this.onSuccessfulResponse(currentTimeMs, node);
    }

    public Optional<Node> coordinator() {
        return Optional.ofNullable(this.coordinator);
    }
}

