/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.consumer.internals;

import java.io.Closeable;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.function.Predicate;
import org.apache.kafka.clients.consumer.internals.CompletedFetch;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.internals.IdempotentCloser;
import org.apache.kafka.common.utils.LogContext;
import org.slf4j.Logger;

public class FetchBuffer
implements Closeable {
    private final Logger log;
    private final ConcurrentLinkedQueue<CompletedFetch> completedFetches;
    private final IdempotentCloser idempotentCloser = new IdempotentCloser();
    private CompletedFetch nextInLineFetch;

    public FetchBuffer(LogContext logContext) {
        this.log = logContext.logger(FetchBuffer.class);
        this.completedFetches = new ConcurrentLinkedQueue();
    }

    boolean isEmpty() {
        return this.completedFetches.isEmpty();
    }

    boolean hasCompletedFetches(Predicate<CompletedFetch> predicate) {
        return this.completedFetches.stream().anyMatch(predicate);
    }

    void add(CompletedFetch completedFetch) {
        this.completedFetches.add(completedFetch);
    }

    void addAll(Collection<CompletedFetch> completedFetches) {
        this.completedFetches.addAll(completedFetches);
    }

    CompletedFetch nextInLineFetch() {
        return this.nextInLineFetch;
    }

    void setNextInLineFetch(CompletedFetch completedFetch) {
        this.nextInLineFetch = completedFetch;
    }

    CompletedFetch peek() {
        return this.completedFetches.peek();
    }

    CompletedFetch poll() {
        return this.completedFetches.poll();
    }

    void retainAll(Set<TopicPartition> partitions) {
        this.completedFetches.removeIf(cf -> this.maybeDrain(partitions, (CompletedFetch)cf));
        if (this.maybeDrain(partitions, this.nextInLineFetch)) {
            this.nextInLineFetch = null;
        }
    }

    private boolean maybeDrain(Set<TopicPartition> partitions, CompletedFetch completedFetch) {
        if (completedFetch != null && !partitions.contains(completedFetch.partition)) {
            this.log.debug("Removing {} from buffered fetch data as it is not in the set of partitions to retain ({})", (Object)completedFetch.partition, partitions);
            completedFetch.drain();
            return true;
        }
        return false;
    }

    Set<TopicPartition> bufferedPartitions() {
        HashSet<TopicPartition> partitions = new HashSet<TopicPartition>();
        if (this.nextInLineFetch != null && !this.nextInLineFetch.isConsumed()) {
            partitions.add(this.nextInLineFetch.partition);
        }
        this.completedFetches.forEach(cf -> partitions.add(cf.partition));
        return partitions;
    }

    @Override
    public void close() {
        this.idempotentCloser.close(() -> {
            this.log.debug("Closing the fetch buffer");
            if (this.nextInLineFetch != null) {
                this.nextInLineFetch.drain();
                this.nextInLineFetch = null;
            }
            this.completedFetches.forEach(CompletedFetch::drain);
            this.completedFetches.clear();
        }, () -> this.log.warn("The fetch buffer was previously closed"));
    }
}

