/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.shaded.io.reactivex.internal.operators.observable;

import io.confluent.shaded.io.reactivex.Maybe;
import io.confluent.shaded.io.reactivex.MaybeObserver;
import io.confluent.shaded.io.reactivex.ObservableSource;
import io.confluent.shaded.io.reactivex.Observer;
import io.confluent.shaded.io.reactivex.disposables.Disposable;
import io.confluent.shaded.io.reactivex.internal.disposables.DisposableHelper;
import io.confluent.shaded.io.reactivex.plugins.RxJavaPlugins;

public final class ObservableSingleMaybe<T>
extends Maybe<T> {
    final ObservableSource<T> source;

    public ObservableSingleMaybe(ObservableSource<T> source) {
        this.source = source;
    }

    @Override
    public void subscribeActual(MaybeObserver<? super T> t) {
        this.source.subscribe(new SingleElementObserver<T>(t));
    }

    static final class SingleElementObserver<T>
    implements Observer<T>,
    Disposable {
        final MaybeObserver<? super T> downstream;
        Disposable upstream;
        T value;
        boolean done;

        SingleElementObserver(MaybeObserver<? super T> downstream) {
            this.downstream = downstream;
        }

        @Override
        public void onSubscribe(Disposable d) {
            if (DisposableHelper.validate(this.upstream, d)) {
                this.upstream = d;
                this.downstream.onSubscribe(this);
            }
        }

        @Override
        public void dispose() {
            this.upstream.dispose();
        }

        @Override
        public boolean isDisposed() {
            return this.upstream.isDisposed();
        }

        @Override
        public void onNext(T t) {
            if (this.done) {
                return;
            }
            if (this.value != null) {
                this.done = true;
                this.upstream.dispose();
                this.downstream.onError(new IllegalArgumentException("Sequence contains more than one element!"));
                return;
            }
            this.value = t;
        }

        @Override
        public void onError(Throwable t) {
            if (this.done) {
                RxJavaPlugins.onError(t);
                return;
            }
            this.done = true;
            this.downstream.onError(t);
        }

        @Override
        public void onComplete() {
            if (this.done) {
                return;
            }
            this.done = true;
            T v = this.value;
            this.value = null;
            if (v == null) {
                this.downstream.onComplete();
            } else {
                this.downstream.onSuccess(v);
            }
        }
    }
}

