/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.metadata.placement;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public class PartitionAssignment {
    private final List<Integer> replicas;
    private final List<Integer> observers;

    public PartitionAssignment(List<Integer> replicas, List<Integer> observers) {
        this.replicas = Collections.unmodifiableList(new ArrayList<Integer>(replicas));
        this.observers = Collections.unmodifiableList(new ArrayList<Integer>(observers));
    }

    public PartitionAssignment(List<Integer> replicas) {
        this.replicas = Collections.unmodifiableList(new ArrayList<Integer>(replicas));
        this.observers = Collections.emptyList();
    }

    public List<Integer> replicas() {
        return this.replicas;
    }

    public List<Integer> observers() {
        return this.observers;
    }

    public List<Integer> syncReplicas() {
        HashSet<Integer> observersSet = new HashSet<Integer>(this.observers);
        return this.replicas.stream().filter(x -> !observersSet.contains(x)).collect(Collectors.toList());
    }

    public boolean equals(Object o) {
        if (!(o instanceof PartitionAssignment)) {
            return false;
        }
        PartitionAssignment other = (PartitionAssignment)o;
        return this.replicas.equals(other.replicas) && this.observers.equals(other.observers);
    }

    public int hashCode() {
        return Objects.hash(this.replicas, this.observers);
    }

    public String toString() {
        return "PartitionAssignment(replicas=" + this.replicas + ", observers=" + this.observers + ")";
    }
}

