/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafkarest.auth;

import com.google.common.collect.ImmutableMap;
import io.confluent.kafka.clients.plugins.auth.jwt.UnverifiedJwtBearerToken;
import io.confluent.kafka.clients.plugins.auth.oauth.OAuthBearerLoginCallbackHandler;
import io.confluent.kafkarest.auth.AuthorizationHeader;
import io.confluent.kafkarest.auth.IdentityPoolIdHeader;
import io.confluent.kafkarest.auth.OAuthBearerLoginWithIdentityPoolCallbackHandler;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.Principal;
import java.util.Base64;
import java.util.Objects;
import java.util.Optional;
import java.util.regex.Pattern;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.security.oauthbearer.OAuthBearerToken;
import org.apache.kafka.common.security.oauthbearer.internals.OAuthBearerSaslClientCallbackHandler;

public abstract class CloudPrincipal
implements Principal {
    private final String clusterId;

    private CloudPrincipal(String clusterId) {
        this.clusterId = Objects.requireNonNull(clusterId);
    }

    public static CloudPrincipal create(String clusterId, AuthorizationHeader header, Optional<IdentityPoolIdHeader> identityPoolIdHeader) {
        switch (header.getScheme()) {
            case BASIC: {
                return CloudPrincipal.fromBasicCredentials(clusterId, header.getCredentials());
            }
            case BEARER: {
                return CloudPrincipal.fromBearerCredentials(clusterId, header.getCredentials(), identityPoolIdHeader);
            }
        }
        throw new AssertionError((Object)String.format("Unknown scheme: %s", new Object[]{header.getScheme()}));
    }

    public static CloudPrincipal create(String clusterId, AuthorizationHeader header) {
        return CloudPrincipal.create(clusterId, header, Optional.empty());
    }

    private static BasicCloudPrincipal fromBasicCredentials(String clusterId, String credentials) {
        String decoded = new String(Base64.getDecoder().decode(credentials), StandardCharsets.ISO_8859_1);
        int separator = decoded.indexOf(58);
        String apiKey = decoded.substring(0, separator);
        String apiSecret = decoded.substring(separator + 1);
        return new BasicCloudPrincipal(clusterId, apiKey, apiSecret);
    }

    private static BearerCloudPrincipal fromBearerCredentials(String clusterId, String credentials, Optional<IdentityPoolIdHeader> identityPoolIdHeader) {
        return new BearerCloudPrincipal(clusterId, (OAuthBearerToken)new UnverifiedJwtBearerToken(credentials), identityPoolIdHeader);
    }

    public String getClusterId() {
        return this.clusterId;
    }

    final String getClientId() {
        return "proxy:" + this.getName();
    }

    final String getSecurityProtocol() {
        return SecurityProtocol.SASL_SSL.name();
    }

    public abstract ImmutableMap<String, String> getClientConfigs();

    public abstract String getCacheKey();

    protected String hashSecret(char[] secret) {
        try {
            MessageDigest md = MessageDigest.getInstance("SHA-512");
            byte[] hashedPassword = md.digest(new String(secret).getBytes(StandardCharsets.UTF_8));
            Base64.Encoder enc = Base64.getEncoder();
            return enc.encodeToString(hashedPassword);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("Unexpected error in principal", e);
        }
    }

    public abstract AuthorizationHeader.Scheme getScheme();

    @Override
    public final boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CloudPrincipal that = (CloudPrincipal)o;
        return this.getClusterId().equals(that.getClusterId()) && this.getName().equals(that.getName());
    }

    @Override
    public final int hashCode() {
        return Objects.hash(this.getClusterId(), this.getName());
    }

    @Override
    public String toString() {
        return String.format("CloudPrincipal[name=%s, clusterId=%s]", this.getName(), this.getClusterId());
    }

    private static final class BearerCloudPrincipal
    extends CloudPrincipal {
        private final OAuthBearerToken token;
        private final Optional<IdentityPoolIdHeader> identityPoolIdHeader;

        private BearerCloudPrincipal(String clusterId, OAuthBearerToken token, Optional<IdentityPoolIdHeader> identityPoolIdHeader) {
            super(clusterId);
            this.token = Objects.requireNonNull(token);
            this.identityPoolIdHeader = identityPoolIdHeader;
        }

        @Override
        public String getName() {
            return this.token.principalName();
        }

        @Override
        public AuthorizationHeader.Scheme getScheme() {
            return AuthorizationHeader.Scheme.BEARER;
        }

        @Override
        public String getCacheKey() {
            String poolAndToken = this.identityPoolIdHeader.map(poolIdHeader -> poolIdHeader.getIdentityPoolId() + ":").orElse("") + this.token.value();
            return this.getClusterId() + ":" + this.token.principalName() + ":" + this.hashSecret(poolAndToken.toCharArray());
        }

        @Override
        public ImmutableMap<String, String> getClientConfigs() {
            return ImmutableMap.builder().put((Object)"client.id", (Object)this.getClientId()).put((Object)"security.protocol", (Object)this.getSecurityProtocol()).put((Object)"sasl.mechanism", (Object)this.getSaslMechanism()).put((Object)"sasl.client.callback.handler.class", (Object)this.getSaslClientCallbackHandlerClass()).put((Object)"sasl.login.callback.handler.class", (Object)this.getSaslLoginCallbackHandlerClass()).put((Object)"sasl.jaas.config", (Object)this.getSaslJaasConfig()).build();
        }

        private String getSaslMechanism() {
            return "OAUTHBEARER";
        }

        private String getSaslClientCallbackHandlerClass() {
            return OAuthBearerSaslClientCallbackHandler.class.getName();
        }

        private String getSaslLoginCallbackHandlerClass() {
            if (this.identityPoolIdHeader.isPresent()) {
                return OAuthBearerLoginWithIdentityPoolCallbackHandler.class.getName();
            }
            return OAuthBearerLoginCallbackHandler.class.getName();
        }

        private String getSaslJaasConfig() {
            if (this.identityPoolIdHeader.isPresent()) {
                return "org.apache.kafka.common.security.oauthbearer.OAuthBearerLoginModule required token=\"" + this.token.value() + "\" logicalCluster=\"" + this.getClusterId() + "\" identityPoolId=\"" + this.identityPoolIdHeader.get().getIdentityPoolId() + "\";";
            }
            return "org.apache.kafka.common.security.oauthbearer.OAuthBearerLoginModule required token=\"" + this.token.value() + "\" cluster=\"" + this.getClusterId() + "\";";
        }
    }

    private static final class BasicCloudPrincipal
    extends CloudPrincipal {
        private static final Pattern JAAS_INPUT_PATTERN = Pattern.compile("(\"|\n|\r|\\$\\{)");
        private final String apiKey;
        private final char[] apiSecret;

        private BasicCloudPrincipal(String clusterId, String apiKey, String apiSecret) {
            super(clusterId);
            Objects.requireNonNull(apiKey);
            Objects.requireNonNull(apiSecret);
            this.apiKey = apiKey;
            this.apiSecret = apiSecret.toCharArray();
        }

        @Override
        public String getName() {
            return this.apiKey;
        }

        @Override
        public AuthorizationHeader.Scheme getScheme() {
            return AuthorizationHeader.Scheme.BASIC;
        }

        @Override
        public String getCacheKey() {
            return this.getClusterId() + ":" + this.apiKey + ":" + this.hashSecret(this.apiSecret);
        }

        @Override
        public ImmutableMap<String, String> getClientConfigs() {
            return ImmutableMap.builder().put((Object)"client.id", (Object)this.getClientId()).put((Object)"security.protocol", (Object)this.getSecurityProtocol()).put((Object)"sasl.mechanism", (Object)this.getSaslMechanism()).put((Object)"sasl.jaas.config", (Object)this.getSaslJaasConfig()).build();
        }

        private String getSaslMechanism() {
            return "PLAIN";
        }

        private String getSaslJaasConfig() {
            return "org.apache.kafka.common.security.plain.PlainLoginModule required username=\"" + JAAS_INPUT_PATTERN.matcher(this.apiKey).replaceAll("") + "\" password=\"" + JAAS_INPUT_PATTERN.matcher(new String(this.apiSecret)).replaceAll("") + "\";";
        }
    }
}

