/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafkarest.auth;

import io.confluent.kafka.common.multitenant.oauth.OAuthBearerJwsToken;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Base64;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.AppConfigurationEntry;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.security.auth.AuthenticateCallbackHandler;
import org.apache.kafka.common.security.auth.SaslExtensions;
import org.apache.kafka.common.security.auth.SaslExtensionsCallback;
import org.apache.kafka.common.security.oauthbearer.OAuthBearerToken;
import org.apache.kafka.common.security.oauthbearer.OAuthBearerTokenCallback;
import org.jose4j.jwt.JwtClaims;
import org.jose4j.jwt.MalformedClaimException;
import org.jose4j.jwt.NumericDate;
import org.jose4j.jwt.consumer.InvalidJwtException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OAuthBearerLoginWithIdentityPoolCallbackHandler
implements AuthenticateCallbackHandler {
    private final Logger log = LoggerFactory.getLogger(OAuthBearerLoginWithIdentityPoolCallbackHandler.class);
    private String authToken;
    private String logicalCluster;
    private String identityPoolId;
    private boolean configured = false;

    public void configure(Map<String, ?> configs, String saslMechanism, List<AppConfigurationEntry> jaasConfigEntries) {
        if (!"OAUTHBEARER".equals(saslMechanism)) {
            throw new IllegalArgumentException(String.format("Unexpected SASL mechanism: %s", saslMechanism));
        }
        if (Objects.requireNonNull(jaasConfigEntries).size() != 1 || jaasConfigEntries.get(0) == null) {
            throw new IllegalArgumentException(String.format("Must supply exactly 1 non-null JAAS mechanism configuration (size was %d)", jaasConfigEntries.size()));
        }
        Map<String, ?> moduleOptions = Collections.unmodifiableMap(jaasConfigEntries.get(0).getOptions());
        this.authToken = (String)moduleOptions.get("token");
        if (this.authToken == null || this.authToken.isEmpty()) {
            this.log.error("No authentication token was provided in the JAAS config!");
            throw new ConfigException("Authentication token must be provided in the JAAS config.");
        }
        this.logicalCluster = (String)moduleOptions.get("logicalCluster");
        if (this.logicalCluster == null || this.logicalCluster.isEmpty()) {
            this.log.error("No cluster extensions for the auth token was provided in the JAAS config!");
            throw new ConfigException("Cluster for token must be set in the JAAS config.");
        }
        this.identityPoolId = (String)moduleOptions.get("identityPoolId");
        if (this.identityPoolId == null || this.identityPoolId.isEmpty()) {
            this.log.error("No identity Pool Id for the auth token was provided in the JAAS config!");
            throw new ConfigException("Identity Pool Id for token must be set in the JAAS config.");
        }
        this.configured = true;
    }

    public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
        if (!this.configured) {
            throw new IllegalStateException("Callback handler not configured");
        }
        for (Callback callback : callbacks) {
            if (callback instanceof OAuthBearerTokenCallback) {
                this.attachAuthToken((OAuthBearerTokenCallback)callback);
                continue;
            }
            if (callback instanceof SaslExtensionsCallback) {
                this.attachTenantLogicalCluster((SaslExtensionsCallback)callback);
                continue;
            }
            throw new UnsupportedCallbackException(callback);
        }
    }

    public void close() {
    }

    private void attachTenantLogicalCluster(SaslExtensionsCallback callback) throws ConfigException {
        HashMap<String, String> extensions = new HashMap<String, String>();
        extensions.put("logicalCluster", this.logicalCluster);
        extensions.put("identityPoolId", this.identityPoolId);
        callback.extensions(new SaslExtensions(extensions));
    }

    private void attachAuthToken(OAuthBearerTokenCallback callback) {
        NumericDate startTimeMs;
        String principal;
        NumericDate lifeTimeMs;
        if (callback.token() != null) {
            throw new IllegalArgumentException("Callback had a token already");
        }
        String[] chunks = this.authToken.split("\\.");
        Base64.Decoder decoder = Base64.getDecoder();
        String payload = new String(decoder.decode(chunks[1]), Charset.defaultCharset());
        try {
            JwtClaims claims = JwtClaims.parse((String)payload);
            lifeTimeMs = claims.getExpirationTime();
            principal = claims.getSubject();
            startTimeMs = claims.getIssuedAt();
        }
        catch (MalformedClaimException | InvalidJwtException e) {
            this.log.error("Failed to parse payload due to {}", (Object)e.getMessage());
            return;
        }
        callback.token((OAuthBearerToken)new OAuthBearerJwsToken(this.authToken, Collections.emptySet(), lifeTimeMs.getValueInMillis(), principal, startTimeMs != null ? Long.valueOf(startTimeMs.getValueInMillis()) : null));
    }
}

