/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafkarest.controllers;

import io.confluent.kafkarest.common.CompletableFutures;
import io.confluent.kafkarest.exceptions.ClusterLinkExistsException;
import java.util.concurrent.CompletableFuture;
import org.apache.kafka.common.errors.ClusterAuthorizationException;
import org.apache.kafka.common.errors.ClusterLinkNotFoundException;
import org.apache.kafka.common.errors.InvalidClusterLinkException;
import org.apache.kafka.common.errors.TimeoutException;
import org.apache.kafka.common.errors.UnrepresentableBrokerIdException;

final class ErrorUtils {
    private ErrorUtils() {
    }

    static <T> CompletableFuture<T> catchInvalidClusterLinkException(CompletableFuture<T> future) {
        return CompletableFutures.catchingCompose(future, InvalidClusterLinkException.class, e -> {
            throw new io.confluent.kafkarest.exceptions.InvalidClusterLinkException((InvalidClusterLinkException)e);
        });
    }

    static <T> CompletableFuture<T> catchClusterAuthorizationException(CompletableFuture<T> future) {
        return CompletableFutures.catchingCompose(future, ClusterAuthorizationException.class, e -> {
            throw new io.confluent.kafkarest.exceptions.ClusterAuthorizationException((Throwable)e);
        });
    }

    static <T> CompletableFuture<T> catchClusterLinkExistsException(CompletableFuture<T> future) {
        return CompletableFutures.catchingCompose(future, org.apache.kafka.common.errors.ClusterLinkExistsException.class, e -> {
            throw new ClusterLinkExistsException((Throwable)e);
        });
    }

    static <T> CompletableFuture<T> catchTimeoutException(CompletableFuture<T> future) {
        return CompletableFutures.catchingCompose(future, TimeoutException.class, e -> {
            throw new io.confluent.kafkarest.exceptions.TimeoutException((Throwable)e);
        });
    }

    static <T> CompletableFuture<T> catchTimeoutExceptionCause(CompletableFuture<T> future) {
        return CompletableFutures.catchingCompose(future, TimeoutException.class, e -> {
            throw new io.confluent.kafkarest.exceptions.TimeoutException(e.getMessage(), e.getCause());
        });
    }

    static <T> CompletableFuture<T> catchClusterLinkNotFoundException(CompletableFuture<T> future) {
        return CompletableFutures.catchingCompose(future, ClusterLinkNotFoundException.class, e -> {
            throw new io.confluent.kafkarest.exceptions.ClusterLinkNotFoundException((Throwable)e);
        });
    }

    static <T> CompletableFuture<T> catchClusterLinkingExceptions(CompletableFuture<T> future) {
        return ErrorUtils.catchClusterAuthorizationException(ErrorUtils.catchClusterLinkNotFoundException(ErrorUtils.catchClusterLinkExistsException(ErrorUtils.catchInvalidClusterLinkException(ErrorUtils.catchTimeoutException(future)))));
    }

    static <T> CompletableFuture<T> catchUnrepresentableBrokerIdException(CompletableFuture<T> future) {
        return CompletableFutures.catchingCompose(future, UnrepresentableBrokerIdException.class, e -> {
            throw new io.confluent.kafkarest.exceptions.UnrepresentableBrokerIdException((Exception)e);
        });
    }
}

