/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafkarest.controllers;

import com.google.common.collect.ImmutableList;
import io.confluent.kafkarest.common.KafkaFutures;
import io.confluent.kafkarest.controllers.ClusterManager;
import io.confluent.kafkarest.controllers.Entities;
import io.confluent.kafkarest.controllers.ErrorUtils;
import io.confluent.kafkarest.controllers.LinkManager;
import io.confluent.kafkarest.entities.Cluster;
import io.confluent.kafkarest.entities.Link;
import io.confluent.kafkarest.exceptions.BadRequestException;
import java.time.Duration;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.apache.kafka.clients.admin.ClusterLinkDescription;
import org.apache.kafka.clients.admin.ConfluentAdmin;
import org.apache.kafka.clients.admin.CreateClusterLinksOptions;
import org.apache.kafka.clients.admin.DeleteClusterLinksOptions;
import org.apache.kafka.clients.admin.DescribeClusterLinksOptions;
import org.apache.kafka.clients.admin.NewClusterLink;
import org.apache.kafka.common.KafkaFuture;
import org.apache.kafka.common.Uuid;

final class LinkManagerImpl
implements LinkManager {
    private final ConfluentAdmin adminClient;
    private final ClusterManager clusterManager;
    private static final Duration DEFAULT_METADATA_TIMEOUT = Duration.ofSeconds(60L);
    DescribeClusterLinksOptions DESCRIBE_CLUSTER_LINKS_OPTIONS = (DescribeClusterLinksOptions)new DescribeClusterLinksOptions().includeTopics(true).timeoutMs(Integer.valueOf(Math.toIntExact(DEFAULT_METADATA_TIMEOUT.toMillis())));

    @Inject
    LinkManagerImpl(ConfluentAdmin adminClient, ClusterManager clusterManager) {
        this.adminClient = Objects.requireNonNull(adminClient);
        this.clusterManager = Objects.requireNonNull(clusterManager);
    }

    private CompletableFuture<Cluster> getValidCluster(String clusterId) {
        return this.clusterManager.getCluster(clusterId).thenApply(cluster -> (Cluster)Entities.checkEntityExists((Optional)cluster, (String)"Cluster %s cannot be found.", (Object[])new Object[]{clusterId}));
    }

    private static Link toLink(ClusterLinkDescription description) {
        return Link.create(description.linkName(), description.remoteClusterId(), description.clusterLinkId(), description.linkMode(), (ImmutableList<String>)description.topics().map(topics -> (ImmutableList)topics.stream().collect(ImmutableList.toImmutableList())).orElse(ImmutableList.of()), description.clusterLinkError(), description.linkErrorMessage() != null ? description.linkErrorMessage() : "", description.linkState());
    }

    private static List<Link> toLinks(Collection<ClusterLinkDescription> links) {
        return links.stream().map(LinkManagerImpl::toLink).collect(Collectors.toList());
    }

    private static Optional<Link> filterLink(Collection<ClusterLinkDescription> links, String linkName) {
        return links.stream().filter(description -> description.linkName().equals(linkName)).map(LinkManagerImpl::toLink).findAny();
    }

    @Override
    public CompletableFuture<List<Link>> listLinks(String clusterId) {
        CompletionStage result = ((CompletableFuture)this.getValidCluster(clusterId).thenCompose(cluster -> KafkaFutures.toCompletableFuture((KafkaFuture)this.adminClient.describeClusterLinks(this.DESCRIBE_CLUSTER_LINKS_OPTIONS).result()))).thenApply(LinkManagerImpl::toLinks);
        return ErrorUtils.catchClusterLinkingExceptions(result);
    }

    @Override
    public CompletableFuture<Optional<Link>> getLink(String clusterId, String linkName) {
        DescribeClusterLinksOptions describeClusterLinksOption = (DescribeClusterLinksOptions)new DescribeClusterLinksOptions().linkNames(Arrays.asList(linkName)).includeTopics(true).timeoutMs(Integer.valueOf(Math.toIntExact(DEFAULT_METADATA_TIMEOUT.toMillis())));
        CompletionStage result = this.getValidCluster(clusterId).thenCompose(cluster -> KafkaFutures.toCompletableFuture((KafkaFuture)this.adminClient.describeClusterLinks(describeClusterLinksOption).result()).thenApply(description -> LinkManagerImpl.filterLink(description, linkName)));
        return ErrorUtils.catchClusterLinkingExceptions(result);
    }

    @Override
    public CompletableFuture<Void> createLink(String localClusterId, Optional<String> sourceClusterId, Optional<String> destinationClusterId, Optional<String> remoteClusterId, Optional<String> clusterLinkId, String linkName, Map<String, String> configs, boolean validateLink, boolean validateOnly) {
        Uuid linkIdUuid;
        CreateClusterLinksOptions createOptions = ((CreateClusterLinksOptions)new CreateClusterLinksOptions().timeoutMs(Integer.valueOf(Math.toIntExact(DEFAULT_METADATA_TIMEOUT.toMillis())))).validateLink(validateLink).validateOnly(validateOnly);
        String linkModeProp = "link.mode";
        String destinationLinkMode = ClusterLinkDescription.LinkMode.DESTINATION.name();
        Optional<String> adminClientRemoteClusterId = remoteClusterId;
        if (!adminClientRemoteClusterId.isPresent()) {
            String linkMode;
            switch (linkMode = configs.containsKey("link.mode") ? configs.get("link.mode") : destinationLinkMode) {
                case "DESTINATION": {
                    adminClientRemoteClusterId = sourceClusterId;
                    break;
                }
                case "SOURCE": {
                    adminClientRemoteClusterId = destinationClusterId;
                    break;
                }
            }
        }
        if (clusterLinkId.isPresent()) {
            try {
                linkIdUuid = Uuid.fromString((String)clusterLinkId.get());
            }
            catch (IllegalArgumentException e) {
                throw new BadRequestException("Invalid link ID " + clusterLinkId.get());
            }
        } else {
            linkIdUuid = null;
        }
        NewClusterLink link = new NewClusterLink(linkName, (String)adminClientRemoteClusterId.orElse(null), configs, linkIdUuid);
        CompletionStage result = this.getValidCluster(localClusterId).thenCompose(cluster -> KafkaFutures.toCompletableFuture((KafkaFuture)this.adminClient.createClusterLinks(Collections.singletonList(link), createOptions).all()));
        return ErrorUtils.catchClusterLinkingExceptions(result);
    }

    @Override
    public CompletableFuture<Void> deleteLink(String clusterId, String linkName, boolean force, boolean validateOnly) {
        DeleteClusterLinksOptions deleteOptions = ((DeleteClusterLinksOptions)new DeleteClusterLinksOptions().timeoutMs(Integer.valueOf(Math.toIntExact(DEFAULT_METADATA_TIMEOUT.toMillis())))).force(force).validateOnly(validateOnly);
        CompletionStage result = ((CompletableFuture)this.getValidCluster(clusterId).thenApply(cluster -> this.adminClient.deleteClusterLinks(Collections.singletonList(linkName), deleteOptions))).thenCompose(deleteResult -> KafkaFutures.toCompletableFuture((KafkaFuture)deleteResult.all()));
        return ErrorUtils.catchClusterLinkingExceptions(result);
    }
}

