/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafkarest.entities;

import io.confluent.kafkarest.entities.BalancerAnyUnevenLoadStatus;
import java.time.Instant;
import java.util.Optional;
import javax.annotation.Nullable;
import org.apache.kafka.clients.admin.EvenClusterLoadStatus;

final class AutoValue_BalancerAnyUnevenLoadStatus
extends BalancerAnyUnevenLoadStatus {
    private final String clusterId;
    private final EvenClusterLoadStatus status;
    private final Optional<EvenClusterLoadStatus> previousStatus;
    private final Optional<Instant> statusUpdatedAt;
    private final Optional<Instant> previousStatusUpdatedAt;
    private final Optional<Short> errorCode;
    private final Optional<String> errorMessage;

    private AutoValue_BalancerAnyUnevenLoadStatus(String clusterId, EvenClusterLoadStatus status, Optional<EvenClusterLoadStatus> previousStatus, Optional<Instant> statusUpdatedAt, Optional<Instant> previousStatusUpdatedAt, Optional<Short> errorCode, Optional<String> errorMessage) {
        this.clusterId = clusterId;
        this.status = status;
        this.previousStatus = previousStatus;
        this.statusUpdatedAt = statusUpdatedAt;
        this.previousStatusUpdatedAt = previousStatusUpdatedAt;
        this.errorCode = errorCode;
        this.errorMessage = errorMessage;
    }

    @Override
    public String getClusterId() {
        return this.clusterId;
    }

    @Override
    public EvenClusterLoadStatus getStatus() {
        return this.status;
    }

    @Override
    public Optional<EvenClusterLoadStatus> getPreviousStatus() {
        return this.previousStatus;
    }

    @Override
    public Optional<Instant> getStatusUpdatedAt() {
        return this.statusUpdatedAt;
    }

    @Override
    public Optional<Instant> getPreviousStatusUpdatedAt() {
        return this.previousStatusUpdatedAt;
    }

    @Override
    public Optional<Short> getErrorCode() {
        return this.errorCode;
    }

    @Override
    public Optional<String> getErrorMessage() {
        return this.errorMessage;
    }

    public String toString() {
        return "BalancerAnyUnevenLoadStatus{clusterId=" + this.clusterId + ", status=" + this.status + ", previousStatus=" + this.previousStatus + ", statusUpdatedAt=" + this.statusUpdatedAt + ", previousStatusUpdatedAt=" + this.previousStatusUpdatedAt + ", errorCode=" + this.errorCode + ", errorMessage=" + this.errorMessage + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof BalancerAnyUnevenLoadStatus) {
            BalancerAnyUnevenLoadStatus that = (BalancerAnyUnevenLoadStatus)o;
            return this.clusterId.equals(that.getClusterId()) && this.status.equals((Object)that.getStatus()) && this.previousStatus.equals(that.getPreviousStatus()) && this.statusUpdatedAt.equals(that.getStatusUpdatedAt()) && this.previousStatusUpdatedAt.equals(that.getPreviousStatusUpdatedAt()) && this.errorCode.equals(that.getErrorCode()) && this.errorMessage.equals(that.getErrorMessage());
        }
        return false;
    }

    public int hashCode() {
        int h$ = 1;
        h$ *= 1000003;
        h$ ^= this.clusterId.hashCode();
        h$ *= 1000003;
        h$ ^= this.status.hashCode();
        h$ *= 1000003;
        h$ ^= this.previousStatus.hashCode();
        h$ *= 1000003;
        h$ ^= this.statusUpdatedAt.hashCode();
        h$ *= 1000003;
        h$ ^= this.previousStatusUpdatedAt.hashCode();
        h$ *= 1000003;
        h$ ^= this.errorCode.hashCode();
        h$ *= 1000003;
        return h$ ^= this.errorMessage.hashCode();
    }

    static final class Builder
    extends BalancerAnyUnevenLoadStatus.Builder {
        private String clusterId;
        private EvenClusterLoadStatus status;
        private Optional<EvenClusterLoadStatus> previousStatus = Optional.empty();
        private Optional<Instant> statusUpdatedAt = Optional.empty();
        private Optional<Instant> previousStatusUpdatedAt = Optional.empty();
        private Optional<Short> errorCode = Optional.empty();
        private Optional<String> errorMessage = Optional.empty();

        Builder() {
        }

        @Override
        public BalancerAnyUnevenLoadStatus.Builder setClusterId(String clusterId) {
            if (clusterId == null) {
                throw new NullPointerException("Null clusterId");
            }
            this.clusterId = clusterId;
            return this;
        }

        @Override
        public BalancerAnyUnevenLoadStatus.Builder setStatus(EvenClusterLoadStatus status) {
            if (status == null) {
                throw new NullPointerException("Null status");
            }
            this.status = status;
            return this;
        }

        @Override
        public BalancerAnyUnevenLoadStatus.Builder setPreviousStatus(@Nullable EvenClusterLoadStatus previousStatus) {
            this.previousStatus = Optional.ofNullable(previousStatus);
            return this;
        }

        @Override
        public BalancerAnyUnevenLoadStatus.Builder setStatusUpdatedAt(@Nullable Instant statusUpdatedAt) {
            this.statusUpdatedAt = Optional.ofNullable(statusUpdatedAt);
            return this;
        }

        @Override
        public BalancerAnyUnevenLoadStatus.Builder setPreviousStatusUpdatedAt(@Nullable Instant previousStatusUpdatedAt) {
            this.previousStatusUpdatedAt = Optional.ofNullable(previousStatusUpdatedAt);
            return this;
        }

        @Override
        public BalancerAnyUnevenLoadStatus.Builder setErrorCode(@Nullable Short errorCode) {
            this.errorCode = Optional.ofNullable(errorCode);
            return this;
        }

        @Override
        public BalancerAnyUnevenLoadStatus.Builder setErrorMessage(@Nullable String errorMessage) {
            this.errorMessage = Optional.ofNullable(errorMessage);
            return this;
        }

        @Override
        public BalancerAnyUnevenLoadStatus build() {
            String missing = "";
            if (this.clusterId == null) {
                missing = missing + " clusterId";
            }
            if (this.status == null) {
                missing = missing + " status";
            }
            if (!missing.isEmpty()) {
                throw new IllegalStateException("Missing required properties:" + missing);
            }
            return new AutoValue_BalancerAnyUnevenLoadStatus(this.clusterId, this.status, this.previousStatus, this.statusUpdatedAt, this.previousStatusUpdatedAt, this.errorCode, this.errorMessage);
        }
    }
}

